<?php
require '../vendor/autoload.php';
require_once '../include/DbConnect.php';
require_once '../include/MCrypt.php';

use \Psr\Http\Message\ServerRequestInterface as Request;
//use \Psr\Http\Message\ResponseInterface as Response;

$config['displayErrorDetails'] = true;
$config['addContentLengthHeader'] = false;

$app = new \Slim\App(["settings" => $config]);
$key = base64_encode('apbs_surya_369');
$sub = "012surya980";

$app->get('/reply/{idkeluhan}', function(Request $request) {
	
	$dc = new DbConnect2();
	$db = $dc->connect();
	
	$idkeluhan = $request->getAttribute('idkeluhan');
	
	$stmt = $db->prepare("SELECT id_keluhan, 
								reply_send, 
								id_user, 
								reply_text, 
								reply_date_create, 
								reply_pelaksana, 
								reply_status, 
								reply_aktif
							FROM tb_keluhan_reply
							WHERE id_keluhan = ?");
	$stmt->bind_param("i", $idkeluhan);
   	$stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
       $results[] = array_map('utf8_encode', $row);
    }
	$hasil = "{data:".json_encode($results)."}";
	echo $hasil;
	
	$stmt->close();
});

$app->post('/reply', function(Request $request) {
	
	$dc = new DbConnect();
	$dc2 = new DbConnect2();
	$crypt = new MCrypt();
	
	$db = $dc->connect();
	$db2 = $dc2->connect();

	$parsedBody = $request->getParsedBody();
	$parameter = $parsedBody['p'];
	
	$decparam = $crypt->decrypt($parameter);
	$arr_param = explode(chr(0).chr(1),$decparam);
	
	$idkeluhan = $arr_param[0];
	
	$stmt = $db->prepare("SELECT * FROM 
						(SELECT id_keluhan, 
								perihal, 
								no_telpon,
								isi_keluhan, 
								no_sambungan, 
								nama_pelanggan, 
								tglwaktu_buat_data, 
								isSelesai, 
								tgl_perbaikan, 
								nama_pegawai_perbaikan, 
								status, 
								kode_keluhan_grup,
								alamat 
						FROM t_keluhan
						WHERE username = '' AND no_sambungan <> '' AND aktif='1'
						ORDER BY id_keluhan ASC
					) AS sudq
					WHERE kode_keluhan_grup <> ''
					GROUP BY kode_keluhan_grup
					ORDER BY tglwaktu_buat_data DESC");
	$stmt->execute();
	$result = $stmt->get_result();
	$stmt->close();
	
	$stmt2 = $db2->prepare("SELECT * FROM tb_keluhan WHERE keluhan_type='pelanggan' AND keluhan_aktif = '1' ORDER BY date_create DESC");
	$stmt2->execute();
	$result2 = $stmt2->get_result();
	$stmt2->close();
	
	while ($row = $result2->fetch_assoc()) {
       $results2[] = array_map('utf8_encode', $row);
    }
	
	while ($row = $result->fetch_assoc()) {
       $results[] = array_map('utf8_encode', $row);
    }
	
	if(count($results2) > 0){
		
		for($i=0; $i<count($results2); $i++){

			if($results2[$i]['id_keluhan'] == $idkeluhan){
				$group = $results[$i]['kode_keluhan_grup'];
				$id_kel_lama = $results[$i]['id_keluhan'];
				$perihal = $results[$i]['perihal'];
				$no_sambungan = $results[$i]['no_sambungan'];
				$namapel = $results[$i]['nama_pelanggan'];
				$alamat = $results[$i]['alamat'];
				$telp = $kolom['no_telpon'];
				$selesai = $results[$i]['isSelesai'];
			}
		}
	} else {
		$hasil = "Tidak ada data";
	}
	
	$timezone = "Asia/Makassar";
	date_default_timezone_set($timezone);
	$idkeluhan = $arr_param[0];
	$replysend = 'pelapor';
	$iduser = 0;
	$isikeluhan = $arr_param[1];
	$tglwaktu = date('Y-m-d H:i:s');
	$status = '-';
	$aktif = '1';
	
	$stmt2 = $db2->prepare("INSERT INTO tb_keluhan_reply (id_keluhan, 
														reply_send, 
														id_user, 
														reply_text, 
														reply_date_create, 
														reply_status, 
														reply_aktif) 
							VALUES (?, ?, ?, ?, ?, ?, ?)");
	$stmt = $db->prepare("INSERT INTO t_keluhan (perihal, 
												 no_telpon, 
												 isi_keluhan, 
												 no_sambungan, 
												 nama_pelanggan, 
												 tglwaktu_buat_data, 
												 status, 
												 aktif, 
												 isSelesai, 
												 kode_keluhan_grup,
												 alamat) 
						VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
	$stmt2->bind_param("isissss", $idkeluhan, $replysend, $iduser, $isikeluhan, $tglwaktu, $status, $aktif);
	$stmt->bind_param("ssssssssssss", $perihal, $telp, $isikeluhan, $no_sambungan, $namapel, $tglwaktu, $status, $aktif, $selesai, $group, $alamat);
	$stmt2->execute();
	$stmt->execute();
	
    if ($stmt2->affected_rows) {
    	$results["success"] = 1;
		$results["message"] = "Posting keluhan sukses";
	} else {
    	$results["success"] = 0;
		$results["message"] = "Posting keluhan error";
		
	}
	echo json_encode($results);
	$stmt2->close();
	$stmt->close();
});

$app->put('/keluhan/{idkeluhan}', function(Request $request) {

	$dc = new DbConnect();
	$dc2 = new DbConnect2();
	$crypt = new MCrypt();
	
	$db = $dc->connect();
	$db2 = $dc2->connect();
	
	$idkeluhan = $request->getAttribute('idkeluhan');

	$parsedBody = $request->getParsedBody();
	$parameter = $parsedBody['p'];
	
	$decparam = $crypt->decrypt($parameter);
	$arr_param = explode(chr(0).chr(1),$decparam);
	
	$timezone = "Asia/Makassar";
	date_default_timezone_set($timezone);
	
	$stmt = $db->prepare("SELECT * FROM 
						(SELECT id_keluhan, 
								perihal, 
								no_telpon,
								isi_keluhan, 
								no_sambungan, 
								nama_pelanggan, 
								tglwaktu_buat_data, 
								isSelesai, 
								tgl_perbaikan, 
								nama_pegawai_perbaikan, 
								status, 
								kode_keluhan_grup,
								alamat 
						FROM t_keluhan
						WHERE username = '' AND no_sambungan <> '' AND aktif='1'
						ORDER BY id_keluhan ASC
					) AS sudq
					WHERE kode_keluhan_grup <> ''
					GROUP BY kode_keluhan_grup
					ORDER BY tglwaktu_buat_data DESC");
	$stmt->execute();
	$result = $stmt->get_result();
	$stmt->close();
	
	$stmt2 = $db2->prepare("SELECT * FROM tb_keluhan WHERE keluhan_type='pelanggan' AND keluhan_aktif = '1' ORDER BY date_create DESC");
	$stmt2->execute();
	$result2 = $stmt2->get_result();
	$stmt2->close();
	
	while ($row = $result2->fetch_assoc()) {
       $results2[] = array_map('utf8_encode', $row);
    }
	
	while ($row = $result->fetch_assoc()) {
       $results[] = array_map('utf8_encode', $row);
    }
	
	if(count($results2) > 0){
		
		for($i=0; $i<count($results2); $i++){

			if($results2[$i]['id_keluhan'] == $idkeluhan){
				$id_kel_lama = $results[$i]['id_keluhan'];
			}
		}
	} else {
		$hasil = "Tidak ada data";
	}
	
	$idperihalsub = $arr_param[0];
	$perihalsub = $arr_param[1];
	$lokasikeluhan = $arr_param[2];
	$isikeluhan = $arr_param[3];
	
	$tglupdate = date('Y-m-d H:i:s');
	
	$stmt = $db->prepare("UPDATE tb_keluhan SET 
								 id_keluhan_prihal_sub = ?, 
								 keluhan_prihal_sub = ?, 
								 keluhan_text = ?, 
								 lokasi_keluhan = ?, 
								 date_update = ? 
						WHERE no_keluhan = ?");
	$stmt->bind_param("ssssss", $idperihalsub, $perihalsub, $isikeluhan, $lokasikeluhan, $tglupdate, $nokeluhan);
	$stmt->execute();
	
	$stmt2 = $db2->prepare("UPDATE t_keluhan SET
									perihal = ?,
									isi_keluhan = ?
									tglwaktu_buat_data = ?
									WHERE id_keluhan = ?");
	$stmt2->bind_param("ssss", $perihalsub, $isikeluhan, $tglupdate, $id_kel_lama);
	$stmt2->execute();
	if ($stmt2->affected_rows) {
    	$results["success"] = 1;
		$results["message"] = "Perbaharuan keluhan sukses";
	} else {
    	$results["success"] = 0;
		$results["message"] = "Perbaharuan keluhan error";
		
	}
	echo json_encode($results);
	$stmt2->close();
	$stmt->close();
});

$app->post('/keluhan', function(Request $request) {
	
	$dc = new DbConnect();
	$dc2 = new DbConnect2();
	$crypt = new MCrypt();
	
	$db = $dc->connect();
	$db2 = $dc2->connect();

	$parsedBody = $request->getParsedBody();
	$parameter = $parsedBody['p'];
	
	$decparam = $crypt->decrypt($parameter);
	$arr_param = explode(chr(0).chr(1),$decparam);
	
	$timezone = "Asia/Makassar";
	date_default_timezone_set($timezone);
	$idperihalsub = $arr_param[0];
	$perihalsub = $arr_param[1];
	$lokasikeluhan = $arr_param[2];
	$isikeluhan = $arr_param[3];
	$keluhantype = $arr_param[4];
	$nosamb = $arr_param[5];
	$namapelapor = $arr_param[6];
	$alamat = $arr_param[7];
	$notelp = $arr_param[8];
	$ipaddr = $arr_param[9];
	$username = $arr_param[10];
	$grup = $arr_param[11];

	$tglbuat = date('Y-m-d H:i:s');
	$status = '2';
	$aktif = '1';
	$selesai = '0';
	
	$nokeluhan = time().random_number(3);

	$stmt = $db->prepare("INSERT INTO t_keluhan (perihal, 
													no_telpon, 
													isi_keluhan, 
													no_sambungan, 
													nama_pelanggan, 
													username, 
													tglwaktu_buat_data, 
													ip, 
													status, 
													aktif, 
													isSelesai, 
													kode_keluhan_grup, 
													alamat) 
							VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
	$stmt->bind_param("sssssssssssss", $perihalsub, $notelp, $isikeluhan, $nosamb, $namapelapor, $username, $tglbuat, $ipaddr, $status, $aktif, $selesai, $grup, $lokasikeluhan);
	$stmt->execute();
    if ($stmt->affected_rows) {
    	$results["success"] = 1;
		$results["message"] = "Posting keluhan sukses";
	} else {
    	$results["success"] = 0;
		$results["message"] = "Posting keluhan error";
	}
	$stmt->close();
	$stmt2 = $db2->prepare("INSERT INTO tb_keluhan (no_keluhan,
													id_keluhan_prihal_sub, 
													keluhan_prihal_sub, 
													keluhan_type, 
													no_sambungan, 
													no_telepon, 
													nama_pelapor, 
													keluhan_text,
													date_create, 
													keluhan_status, 
													lokasi_keluhan, 
													keluhan_selesai,
													keluhan_aktif) 
							VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
	$stmt2->bind_param("sisssssssssii", $nokeluhan, $idperihalsub, $perihalsub, $keluhantype, $nosamb, $notelp, $namapelapor, $isikeluhan, $tglbuat, $status, $lokasikeluhan, $selesai, $aktif);
	$stmt2->execute();
	$stmt2->close();
	echo json_encode($results);
});

$app->run();
?>