<?php
	/**
	* Class untuk modul dashboard
	*/
	class DashboardClass extends class_connectDB
	{
		private $date_time;
		private $kode_prefix;
		public $arr_input;
		public $start_limit;
		public $id_user;

		private $connect;

		public function selectKJTTgsSKPJadwal()
		{
			if (empty($this->id_user) && empty($id_peg)) {
				return array("status" => "error");
			}

			$id_peg = mysqli_real_escape_string($this->connect, $id_peg);

			$q = " SELECT
					SUM( IF(ak.jenis = 'aktivitas', IF(ak.`id_pegawai` = $this->id_user, 1, 0), 0) ) AS jum_ak,
					SUM( IF(ak.jenis = 'tugas', IF(ak.`id_pegawai` = $this->id_user, 1, 0), 0) ) AS jum_tgs,
					SUM( IF(ak.jenis = 'jobdes', IF(ak.`id_pegawai` = $this->id_user, 1, 0), 0) ) AS jum_jd,
					SUM( IF(jd.`id_pegawai` = $this->id_user, 1, 0) ) AS jum_jdwl,
					SUM( IF(ak.`id_pegawai` > 0, 1, 0) ) AS tot_all,
					SUM( IF(ak.jenis = 'aktivitas', 1, 0) ) AS jum_all_ak
				FROM `tb_crm_aktivitas` ak, `tb_crm_jadwal` jd
				WHERE ak.aktif = '1' ";
			$arr = $this->selectTB($q);

			//echo $q;

			if (count($arr) > 0) {
				foreach ($arr as $kol) {
					$data = array(
						"jum_ak" => $kol['jum_ak'], "jum_tgs" => $kol['jum_tgs'],
						"jum_jd" => $kol['jum_jd'], "jum_jdwl" => $kol['jum_jdwl'],
						"tot_all" => $kol['tot_all'], "jum_all_ak" => $kol['jum_all_ak'],
						);
				}
				return $data;
			}
			return array(
						"jum_ak" => 0, "jum_tgs" => 0,
						"jum_jd" => 0, "jum_jdwl" => 0,
						"tot_all" => 0, "jum_all_ak" => 0,
					);
		}

		public function selectAkhirPegawaiAktivitas()
		{
			if (empty($this->id_user)) {
				return array("status" => "error");
			}

			$q = "SELECT ak.`id_pegawai`, pg.nama, pg.`foto`
			FROM `tb_crm_aktivitas` ak INNER JOIN `tb_kepegawaian_pegawai` pg ON ak.`id_pegawai` = pg.`id_pegawai`
			WHERE ak.`aktif` = '1'
			GROUP BY ak.`id_pegawai`
			ORDER BY ak.tglwaktu DESC
			LIMIT 4";

			$arr = $this->selectTB($q);

			//echo $q;

			if (count($arr) > 0) {
				foreach ($arr as $kol) {
					$data[] = array(
						"id_peg" => $kol['id_pegawai'],
						"nama" => $kol['nama'],
						"foto" => $kol['foto'],
					);
				}
				return $data;
			}
			else {
				return $this->selectPegawai();
			}
			return "";
		}

		private function selectPegawai()
		{
			$q = "  SELECT id_pegawai, nama, foto
					FROM `tb_kepegawaian_pegawai`
					WHERE aktif = '1' AND nama <> 'Admin'
					LIMIT 4";

			$arr = $this->selectTB($q);

			if (count($arr) > 0) {
				foreach ($arr as $kol) {
					$data[] = array(
						"id_peg" => $kol['id_pegawai'],
						"nama" => $kol['nama'],
						"foto" => $kol['foto'],
					);
				}
				return $data;
			}
			return "";
		}

		function __construct(){
			$this->connect = parent::connectDB();
			$this->date_time = date("Y-m-d H:i:s");
			$this->kode_prefix = date("ymdHis");
		}

		function __destruct(){
			parent::closeDB();
			//echo "<br />destruk";
		}
	}
?>