<?php
	/**
	* Class untuk modul Disposisi
	*/
	class DisposisiClass extends class_connectDB
	{
		private $date_time;
		private $kode_prefix;
		public $arr_input;
		public $start_limit;
		public $id_user;
		public $kode_disposur;
		public $kode_dis_lap;
		public $kode_dis_lap_komen;

		private $connect;

        public function selectDisposisiSurat(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $where = "";
            if (!empty($this->kode_disposur)) {
                $this->kode_disposur = mysqli_real_escape_string($this->connect, $this->kode_disposur);
                $where = " AND kode_disposisi_surat = '$this->kode_disposur' ";
            }

            $query =
            " SELECT kode_disposisi_surat, tglsurat, nosurat, id_pegawai, disposur_jenis, disposur_klasifikasi,
                     pengirim, tujuansurat, perihal, isi, kepada AS tag_pegawai, filesurat,
                     tglwaktu, tglwaktubuatdata
              FROM tb_disposur
              WHERE aktif = '1' $where
            ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "k_disposur" => $kol['kode_disposisi_surat'],
                        "tgl_surat" => $kol['tglsurat'],
                        "no_surat" => $kol['nosurat'],
                        "id_peg" => $kol['id_pegawai'],
                        "jenis" => $kol['disposur_jenis'],
                        "klas" => $kol['disposur_klasifikasi'],
                        "pengirim" => $kol['pengirim'],
                        "tujuan" => $kol['tujuansurat'],
                        "perihal" => $kol['perihal'],
                        "isi" => $kol['isi'],
                        "tag_peg" => $kol['tag_pegawai'],
                        "file_berkas" => $kol['filesurat'],
                        "tglwaktu_update" => $kol['tglwaktu'],
                        "tglwaktu_create" => $kol['tglwaktubuatdata'],
                    );
                }
                return $data;
            }
            return '';
        }

		public function selectAllNotifReceiver()
		{
			$this->kode_disposur = mysqli_real_escape_string($this->connect, $this->kode_disposur);
			if (empty($this->kode_disposur) || empty($this->id_user)) {
				return array("status" => "error");
			}

			$query =
		    " SELECT id_pegawai, kepada AS tag_pegawai
		      FROM tb_disposur
		      WHERE kode_disposisi_surat = '$this->kode_disposur' AND aktif = '1'
		    ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
            	foreach ($arr as $kol) {
            		$arr_tag_peg[] = $kol['tag_pegawai'];
            		$id_pegawai_dis = $kol['id_pegawai'];
            	}
            	$arr_id_peg[] = $id_pegawai_dis;
            }

        	$fungsi = new FungsiClass();
        	if (!empty($arr_tag_peg)) {

            	$arr_tag_peg = $fungsi->getIdPegFromTag($arr_tag_peg);
            	$arr_id_peg = array_merge($arr_id_peg, $arr_tag_peg);
        	}

        	$arr_dis_lap = $this->selectAllLaporanDisposisi();
        	if (!empty($arr_dis_lap['arr_kode_dis_lap']) && count($arr_dis_lap['arr_kode_dis_lap']) > 0) {
        		$tmp_arr = $arr_dis_lap['arr_kode_dis_lap'];
        		for ($i=0; $i < count($tmp_arr); $i++) {
        			$this->kode_dis_lap = $tmp_arr[$i];
        			$arr_all_dis_lap_komen[] = $this->selectAllLaporanDisposisiKomen();
        		}
        		$arr_id_peg = array_merge($arr_id_peg, $arr_dis_lap['arr_id_peg']);
        	}

        	//var_dump($arr_all_dis_lap_komen);

        	if (!empty($arr_all_dis_lap_komen)) {
        		for ($i=0; $i < count($arr_all_dis_lap_komen); $i++) {
        			if (!empty($arr_all_dis_lap_komen[$i]['arr_id_peg'])) {
        				$arr_id_peg = array_merge($arr_id_peg, $arr_all_dis_lap_komen[$i]['arr_id_peg']);
        			}
        			if (!empty($arr_all_dis_lap_komen[$i]['arr_tag_peg'])) {
        				$arr_tag_peg = $fungsi->getIdPegFromTag($arr_all_dis_lap_komen[$i]['arr_tag_peg']);
        				$arr_id_peg = array_merge($arr_id_peg, $arr_tag_peg);
        			}
        		}
        	}

        	$all_id_peg = array_values($arr_id_peg);
        	if(!empty($all_id_peg)){
				return $fungsi->arrayUnik( $all_id_peg );
        	}
        	return '';
		}

		private function selectAllLaporanDisposisi()
		{
			if (empty($this->kode_disposur) || empty($this->id_user)) {
				return array("status" => "error");
			}

            $kode_disposur = mysqli_real_escape_string($this->connect, $this->kode_disposur);

			$query =
		    " SELECT id_pegawai, kode_disposur_laporan
		      FROM tb_disposur_laporan
		      WHERE kode_disposur = '$kode_disposur' AND aktif = '1'
		    ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
            	foreach ($arr as $kol) {
            		$arr_id_peg[] = $kol['id_pegawai'];
            		$arr_kode_dis_lap[] = $kol['kode_disposur_laporan'];
            	}
            	return array("arr_id_peg" => $arr_id_peg, "arr_kode_dis_lap" => $arr_kode_dis_lap);
            }

            return '';
		}

		private function selectAllLaporanDisposisiKomen()
		{
			if (empty($this->kode_dis_lap) || empty($this->id_user)) {
				return array("status" => "error");
			}

            $kode_dis_lap = mysqli_real_escape_string($this->connect, $this->kode_dis_lap);

			$query =
		    " SELECT id_pegawai, kode_disposur_komen, tag_pegawai
		      FROM tb_disposur_komen
		      WHERE kode_disposur_laporan = '$kode_dis_lap' AND aktif = '1'
		    ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
            	foreach ($arr as $kol) {
            		$arr_id_peg[] = $kol['id_pegawai'];
            		$arr_kode_dis_lap_komen[] = $kol['kode_disposur_komen'];
            		$arr_tag_peg[] = $kol['tag_pegawai'];
            	}
            	return array("arr_id_peg" => $arr_id_peg, "arr_kode_dis_lap_komen" => $arr_kode_dis_lap_komen, "arr_tag_peg" => $arr_tag_peg);
            }

            return '';
		}

        public function getKDisfromKDisLap($kode)
        {
            if (empty($kode) || empty($this->id_user)) {
                return array("status" => "error");
            }

            $kode = mysqli_real_escape_string($this->connect, $kode);

            $query =
            " SELECT kode_disposur
              FROM tb_disposur_laporan
              WHERE kode_disposur_laporan = '$kode'
              LIMIT 1
            ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $kode_disposur = $kol['kode_disposur'];
                }
                return $kode_disposur;
            }
            return '';
        }

        public function deleteLaporan()
        {
            if (empty($this->kode_dis_lap) || empty($this->id_user)) {
                return array("status" => "error");
            }

            $kode_dis_lap = mysqli_real_escape_string($this->connect, $this->kode_dis_lap);
            $id_user = mysqli_real_escape_string($this->connect, $this->id_user);

            $query =
            " UPDATE tb_disposur_laporan
              SET aktif = '0'
              WHERE kode_disposur_laporan = '$kode_dis_lap' AND id_pegawai = '$id_user'
            ";
            $sql = $this->crudTB($query);

            return array("status" => $sql);
        }

        public function deleteKomen()
        {
            if (empty($this->kode_dis_lap_komen) || empty($this->id_user)) {
                return array("status" => "error");
            }

            $kode_dis_lap_komen = mysqli_real_escape_string($this->connect, $this->kode_dis_lap_komen);
            $id_user = mysqli_real_escape_string($this->connect, $this->id_user);

            $query =
            " UPDATE tb_disposur_komen
              SET aktif = '0'
              WHERE kode_disposur_komen = '$kode_dis_lap_komen' AND id_pegawai = '$id_user'
            ";
            $sql = $this->crudTB($query);

            return array("status" => $sql);
        }

		function __construct(){
			$this->connect = parent::connectDB();
			$this->date_time = date("Y-m-d H:i:s");
			$this->kode_prefix = date("ymdHis");
		}

		function __destruct(){
			parent::closeDB();
			//echo "<br />destruk";
		}
	}
?>