<?php
	/**
	* Class untuk menu Hublang dan Rekening
	*/
	class HublangClass extends class_connectDB
	{
		private $date_time;
		private $kode_prefix;
		public $arr_input;
		public $id_user;
		public $kode_disposur;
		public $kode_dis_lap;
		public $kode_dis_lap_komen;

        public $start_limit;
        public $limit;
        public $periode;
        public $group_by;

        private $qgroup_by;
        private $from;
        private $select;
        private $sort;

        private $kwil;

		private $connect;

        public function selectPeriodeDRD(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $query = " SELECT periode, bulan FROM drd GROUP BY periode DESC ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "periode" => $kol['periode'],
                        "bln" => $kol['bulan']
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectRayon(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $query = " SELECT koderayon, namarayon FROM rayon ORDER BY namarayon ASC ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "kode" => $kol['koderayon'],
                        "rayon" => $kol['namarayon']
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectWilayah(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            if (!empty($this->kwil) || $this->kwil != 0) {
                $where = " WHERE kodewil = '$this->kwil'";
            }

            $query = " SELECT kodewil, wilayah FROM rayon $where GROUP BY wilayah ASC ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "kode" => $kol['kodewil'],
                        "wil" => $kol['wilayah']
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectGolongan(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $query = " SELECT kodegol, golongan FROM golongan GROUP BY kodegol ASC ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "kode" => $kol['kodegol'],
                        "gol" => $kol['golongan']
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectLoket(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $query = " SELECT kodeloket, loket FROM loket ORDER BY loket ASC ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "kode" => $kol['kodeloket'],
                        "loket" => $kol['loket']
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectBulanTransaksi(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $query = " SELECT periodebayar, bulanbayar FROM lapefektifitas GROUP BY periodebayar DESC ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "periode" => $kol['periodebayar'],
                        "bln_thn" => $kol['bulanbayar']
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectKasir(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $query = " SELECT nama FROM userakses ORDER BY nama ASC ";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "nama" => $kol['nama']
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectDRD(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

            $where = "";
            if (!empty($arr['periode']) || $arr['periode'] == "0") {
                $this->periode = $arr['periode'];
            }
            if (!empty($arr['no_samb']) || $arr['no_samb'] == "0") {
                $where .= "AND c.nosamb = '$arr[no_samb]' ";
            }
            if (!empty($arr['rayon']) || $arr['rayon'] == "0") {
                $where .= "AND c.koderayon = '$arr[rayon]' ";
            }
            if (!empty($arr['wilayah']) || $arr['wilayah'] == "0") {
                $where .= "AND c.kodewil = '$arr[wilayah]' ";
            }
            if (!empty($arr['golongan']) || $arr['golongan'] == "0") {
                $where .= "AND c.kodegol = '$arr[golongan]' ";
            }

            if (empty($this->limit)) {
                $this->setDefaultLimit();
            }


            $query = "  SELECT c.bulan, c.nosamb, c.nama, c.alamat, c.koderayon, c.kodegol, c.kodediameter, c.pakai,
                              c.biayapemakaian, c.administrasi+c.administrasilain as administrasi, periode,
                              c.retribusi+c.retribusilain as retribusi, c.pemeliharaan+c.pemeliharaanlain as pemeliharaan,
                              c.angsuran, c.rekair, c.rekair+c.angsuran as jumlah
                        FROM drd c
                        LEFT JOIN rayon r ON c.koderayon=r.koderayon
                        WHERE c.periode = '$this->periode' $where
                        ORDER BY c.nosamb ASC LIMIT $this->start_limit, $this->limit  ";
            $arr = $this->selectTB($query);

            //echo $query;

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "bln" => $kol['bulan'],
                        "no_samb" => $kol['nosamb'],
                        "nama" => $kol['nama'],
                        "alamat" => $kol['alamat'],
                        "krayon" => $kol['koderayon'],
                        "kgol" => $kol['kodegol'],
                        "kdiameter" => $kol['kodediameter'],
                        "pk" => $kol['pakai'],

                        "bya_pk" => $kol['biayapemakaian'],
                        "adm" => $kol['administrasi'],
                        "ret" => $kol['retribusi'],
                        "pelihara" => $kol['pemeliharaan'],
                        "angsur" => $kol['angsuran'],
                        "rek_air" => $kol['rekair'],
                        "jml" => $kol['jumlah']
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectRekapDRD(){
            if (empty($this->id_user) && empty($this->group_by) ) {
                return array("status" => "error");
            }

            $arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

            $where = "";
            if (!empty($arr['periode']) || $arr['periode'] == "0") {
                $this->periode = $arr['periode'];
            }
            if (!empty($arr['rayon']) || $arr['rayon'] == "0") {
                $where .= " AND c.koderayon = '$arr[rayon]' ";
            }
            if (!empty($arr['wilayah']) || $arr['wilayah'] == "0") {
                $where .= " AND c.kodewil = '$arr[wilayah]' ";
            }
            if (!empty($arr['golongan']) || $arr['golongan'] == "0") {
                $where .= " AND c.kodegol = '$arr[golongan]' ";
            }

            $this->setDefaultRekapDRD();

            $query =
                "SELECT c.kodegol, g.golongan, COUNT(c.kode) as lembar, SUM(c.pakai) as pakai,

                    r.namarayon, c.koderayon,
                    r.kodewil,r.wilayah,

                    SUM(c.biayapemakaian) as biayapemakaian,
                    SUM(c.administrasi)+SUm(c.administrasilain) as administrasi,
                    SUm(c.pemeliharaan)+SUm(c.pemeliharaanlain) as pemeliharaan,
                    SUM(c.retribusi)+SUM(c.retribusilain) as retribusi,
                    SUm(c.angsuran) as angsuran,
                    SUm(c.rekair)+SUm(c.angsuran) as jumlah
                FROM drd c LEFT JOIN golongan g ON c.kodegol=g.kodegol LEFT JOIN rayon r ON c.koderayon=r.koderayon
                WHERE c.periode = '$this->periode' $where
                GROUP BY $this->qgroup_by ASC";
            $arr = $this->selectTB($query);

            //echo $query;

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    if (!empty($kol['pakai']) && $kol['pakai'] > 0) {
                        $hargarata2air = $kol['biayapemakaian']/$kol['pakai'];
                    } else { $hargarata2air = 0; }

                    if (!empty($kol['lembar']) && $kol['lembar'] > 0) {
                        $pakairata2air = $kol['pakai']/$kol['lembar'];
                    } else { $pakairata2air = 0; }

                    if ($this->group_by == "golongan") {
                        $baris_info = $kol['kodegol'] ."-". $kol['golongan'];
                    }
                    else if ($this->group_by == "rayon") {
                        $baris_info = $kol['koderayon'] ."-". $kol['namarayon'];
                    }
                    else if ($this->group_by == "wilayah") {
                        $baris_info = $kol['kodewil'] ."-". $kol['wilayah'];
                    }


                    $data[] = array(
                        "baris_info" => $baris_info,

                        /*"kgol" => $kol['kodegol'],
                        "gol" => $kol['golongan'],

                        "krayon" => $kol['koderayon'],
                        "rayon" => $kol['namarayon'],*/


                        "lmbr" => $kol['lembar'],
                        "pk" => $kol['pakai'],
                        "bya_pk" => $kol['biayapemakaian'],
                        "adm" => $kol['administrasi'],
                        "pelihara" => $kol['pemeliharaan'],
                        "ret" => $kol['retribusi'],
                        "angsur" => $kol['angsuran'],
                        "jml" => $kol['jumlah'],
                        "hrg_air_rata2" => $hargarata2air,
                        "hrg_pk_air_rata2" => $pakairata2air
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectBandingDRD(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

            $where = "";
            if (!empty($arr['periode']) || $arr['periode'] == "0") {
                $this->periode = $arr['periode'];
            }
            if (!empty($arr['rayon']) || $arr['rayon'] == "0") {
                $where .= " AND c.koderayon = '$arr[rayon]' ";
            }
            if (!empty($arr['wilayah']) || $arr['wilayah'] == "0") {
                $where .= " AND r.kodewil = '$arr[wilayah]' ";
            }
            /*if (!empty($arr['golongan'])) {
                $where .= " AND c.kodegol = '$arr[golongan]' ";
            }*/

            $periode1 = $this->periode;
            $arrthn = substr($periode1, 0, 4);
            $arrbln = substr($periode1, 4, 2);
            $tglperiode2 = $arrthn."-".$arrbln."-01";
            $periode2 = date("Ym", strtotime("-1 month", strtotime($tglperiode2)));

            $query =
                "SELECT g.kodegol,
                    LEFT(g.golongan,20) AS golongan,
                    COALESCE(h1.lembar, 0) AS lembar,
                    COALESCE(h1.pakai, 0) AS pakai,
                    COALESCE(h1.biayapemakaian, 0) AS biayapemakaian,
                    COALESCE(h1.administrasi, 0) AS administrasi,
                    COALESCE(h1.pemeliharaan, 0) AS pemeliharaan,
                    COALESCE(h1.rekair, 0) AS rekair,
                    COALESCE(h2.lembar, 0) AS lembar2,
                    COALESCE(h2.pakai, 0) AS pakai2,
                    COALESCE(h2.biayapemakaian, 0) AS biayapemakaian2,
                    COALESCE(h2.administrasi, 0) AS administrasi2,
                    COALESCE(h2.pemeliharaan, 0) AS pemeliharaan2,
                    COALESCE(h2.rekair, 0) AS rekair2,
                    COALESCE(h1.rekair, 0) - COALESCE(h2.rekair, 0) AS naikturun
                FROM
                    (SELECT kodegol,golongan FROM golongan ORDER BY kodegol) g
                      LEFT JOIN
                        (SELECT
                          c.kodegol,
                          COUNT(c.kode) AS lembar,
                          SUM(c.pakai) AS pakai,
                          SUM(c.biayapemakaian) AS biayapemakaian,
                          SUM(c.administrasi) + SUM(c.administrasilain) AS administrasi,
                          SUM(c.pemeliharaan) + SUM(c.pemeliharaanlain) AS pemeliharaan,
                          SUM(c.retribusi) + SUM(c.retribusilain) AS retribusi,
                          SUM(c.rekair) AS rekair
                        FROM
                          drd c LEFT JOIN rayon r ON c.koderayon=r.koderayon
                        WHERE c.periode = $periode1 $where
                        GROUP BY c.kodegol) h1
                        ON g.kodegol = h1.kodegol
                      LEFT JOIN
                        (SELECT
                          c.kodegol,
                          COUNT(c.kode) AS lembar,
                          SUM(c.pakai) AS pakai,
                          SUM(c.biayapemakaian) AS biayapemakaian,
                          SUM(c.administrasi) + SUM(c.administrasilain) AS administrasi,
                          SUM(c.pemeliharaan) + SUM(c.pemeliharaanlain) AS pemeliharaan,
                          SUM(c.retribusi) + SUM(c.retribusilain) AS retribusi,
                          SUM(c.rekair) AS rekair
                        FROM
                          drd c LEFT JOIN rayon r ON c.koderayon=r.koderayon
                        WHERE c.periode = $periode2 $where
                        GROUP BY c.kodegol) h2
                        ON g.kodegol = h2.kodegol";
            $arr = $this->selectTB($query);

            //echo $query;

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "kgol" => $kol['kodegol'],
                        "gol" => $kol['golongan'],
                        "lmbr" => $kol['lembar'],
                        "pk" => $kol['pakai'],
                        "bya_pk" => $kol['biayapemakaian'],
                        "adm" => $kol['administrasi'],
                        "pelihara" => $kol['pemeliharaan'],
                        "ret" => $kol['retribusi'],
                        "rekair" => $kol['rekair'],
                        "naik_turun" => $kol['naikturun'],

                        "lmbr2" => $kol['lembar2'],
                        "pk2" => $kol['pakai2'],
                        "bya_pk2" => $kol['biayapemakaian2'],
                        "adm2" => $kol['administrasi2'],
                        "pelihara2" => $kol['pemeliharaan2'],
                        "ret2" => $kol['retribusi2'],
                        "rekair2" => $kol['rekair2'],
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectSaldo(){
            if (empty($this->id_user)) {
                return array("status" => "error");
            }

            $arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

            $where = "";
            if (!empty($arr['periode']) || $arr['periode'] == "0") {
                $this->periode = $arr['periode'];
            }
            if (!empty($arr['no_samb']) || $arr['no_samb'] == "0") {
                $where .= "AND c.nosamb = '$arr[no_samb]' ";
            }
            if (!empty($arr['rayon']) || $arr['rayon'] == "0") {
                $where .= "AND c.koderayon = '$arr[rayon]' ";
            }
            if (!empty($arr['wilayah']) || $arr['wilayah'] == "0") {
                $where .= "AND c.kodewil = '$arr[wilayah]' ";
            }
            if (!empty($arr['golongan']) || $arr['golongan'] == "0") {
                $where .= "AND c.kodegol = '$arr[golongan]' ";
            }

            if (empty($this->limit)) {
                $this->setDefaultLimit();
            }

            $query = "  SELECT c.nosamb, c.tglmulaidenda, c.tglmulaidenda2, c.trf_dendatunggakan, c.trf_dendatunggakan2, c.bulan,
                            LEFT(c.nama,15) as nama, c.alamat, c.pakai AS pakai, c.periode,
                            c.biayapemakaian AS biayapemakaian,
                            c.administrasi + c.administrasilain AS administrasi,
                            c.pemeliharaan + c.pemeliharaanlain AS pemeliharaan,
                            c.retribusi + c.retribusilain AS retribusi,
                            c.angsuran, c.rekair,
                            IF(c.trf_dendatunggakan2>0 AND CURRENT_DATE>=c.tglmulaidenda2,c.trf_dendatunggakan2,
                            IF(c.trf_dendatunggakan>0 AND CURRENT_DATE>=c.tglmulaidenda,c.trf_dendatunggakan,0))
                            AS denda,
                            IF(c.trf_dendatunggakan2>0 AND CURRENT_DATE>=c.tglmulaidenda2,c.trf_dendatunggakan2,
                            IF(c.trf_dendatunggakan>0 AND CURRENT_DATE>=c.tglmulaidenda,c.trf_dendatunggakan,0))
                            +
                            c.rekair + c.angsuran AS total
                        FROM drd c
                        LEFT JOIN rayon r ON c.koderayon=r.koderayon
                        WHERE c.flaglunas='0' and c.periode<='$this->periode' AND LEFT(c.periode,4)=LEFT('$this->periode',4) $where
                        ORDER BY c.nosamb,c.periode ASC LIMIT $this->start_limit, $this->limit";
            $arr = $this->selectTB($query);

            //echo $query;

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "bln" => $kol['bulan'],
                        "no_samb" => $kol['nosamb'],
                        "nama" => $kol['nama'],
                        "alamat" => $kol['alamat'],
                        "pk" => $kol['pakai'],
                        "denda" => $kol['denda'],
                        "periode" => $kol['periode'],

                        "bya_pk" => $kol['biayapemakaian'],
                        "adm" => $kol['administrasi'],
                        "ret" => $kol['retribusi'],
                        "pelihara" => $kol['pemeliharaan'],
                        "angsur" => $kol['angsuran'],
                        "rek_air" => $kol['rekair'],
                        "tot" => $kol['total']
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectRekapSaldo(){
            if (empty($this->id_user) || empty($this->group_by) ) {
                return array("status" => "error");
            }

            $arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

            $where = "";
            if (!empty($arr['periode']) || $arr['periode'] == "0") {
                $this->periode = $arr['periode'];
            }
            if (!empty($arr['rayon']) || $arr['rayon'] == "0") {
                $where .= " AND c.koderayon = '$arr[rayon]' ";
            }
            if (!empty($arr['wilayah']) || $arr['wilayah'] == "0") {
                $where .= " AND r.kodewil = '$arr[wilayah]' ";
            }
            if (!empty($arr['golongan']) || $arr['golongan'] == "0") {
                $where .= " AND c.kodegol = '$arr[golongan]' ";
            }
            //if (!empty($arr['periode'])) {
                //$where .= " AND c.kodegol = '$arr[golongan]' ";
            //}

            $this->setDefaultRekapSaldo();

            $query =
            "SELECT
                c.kodegol, LEFT(g.golongan,15) as golongan,
                c.koderayon, LEFT(r.namarayon,15) as namarayon,
                r.kodewil, r.wilayah,
                c.bulan,

                COUNT(c.kode) as lembar,
                SUM(c.pakai) AS pakai, SUM(c.biayapemakaian) AS biayapemakaian,
                SUM(c.administrasi) + SUM(c.administrasilain) AS administrasi,
                SUM(c.pemeliharaan) + SUM(c.pemeliharaanlain) AS pemeliharaan,
                SUM(c.retribusi) + SUM(c.retribusilain) AS retribusi,
                SUM(c.angsuran) as angsuran, SUM(c.rekair) as rekair,
                SUM(
                    IF(c.trf_dendatunggakan2>0 AND CURRENT_DATE>=c.tglmulaidenda2,c.trf_dendatunggakan2,
                    IF(c.trf_dendatunggakan>0 AND CURRENT_DATE>=c.tglmulaidenda,c.trf_dendatunggakan,0))
                )
                AS denda,
                SUM(
                    IF(c.trf_dendatunggakan2>0 AND CURRENT_DATE>=c.tglmulaidenda2,c.trf_dendatunggakan2,
                    IF(c.trf_dendatunggakan>0 AND CURRENT_DATE>=c.tglmulaidenda,c.trf_dendatunggakan,0))
                )
                +
                SUM(c.rekair) + SUM(c.angsuran) AS total
            FROM drd c
                LEFT JOIN rayon r ON c.koderayon=r.koderayon
                LEFT JOIN golongan g ON c.kodegol=g.kodegol
            WHERE c.flaglunas='0' and c.periode<='$this->periode' AND LEFT(c.periode,4)=LEFT('$this->periode',4) $where
            GROUP BY $this->qgroup_by ASC";

            $arr = $this->selectTB($query);

            //echo $query;

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    /*if (!empty($kol['pakai']) && $kol['pakai'] > 0) {
                        $hargarata2air = $kol['biayapemakaian']/$kol['pakai'];
                    } else { $hargarata2air = 0; }

                    if (!empty($kol['lembar']) && $kol['lembar'] > 0) {
                        $pakairata2air = $kol['pakai']/$kol['lembar'];
                    } else { $pakairata2air = 0; }*/

                    if ($this->group_by == "golongan") {
                        $baris_info = $kol['kodegol'] ."-". $kol['golongan'];
                    }
                    else if ($this->group_by == "rayon") {
                        $baris_info = $kol['koderayon'] ."-". $kol['namarayon'];
                    }
                    else if ($this->group_by == "wilayah") {
                        $baris_info = $kol['kodewil'] ."-". $kol['wilayah'];
                    }
                    else if ($this->group_by == "periode") {
                        $baris_info = $kol['bulan'];
                    }


                    $data[] = array(
                        "baris_info" => $baris_info,

                        "lmbr" => $kol['lembar'],
                        "bya_pk" => $kol['biayapemakaian'],
                        "adm" => $kol['administrasi'],
                        "pelihara" => $kol['pemeliharaan'],
                        "ret" => $kol['retribusi'],
                        "rekair" => $kol['rekair'],
                        "denda" => $kol['denda'],
                        "total" => $kol['total'],
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectRekapLPP(){
            if (empty($this->id_user) || empty($this->group_by) || empty($this->arr_input['tgl1']) || empty($this->arr_input['tgl2'])) {
                return array("status" => "error");
            }

            $arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

            $where = "";
            if (!empty($arr['periode'])) {
                $this->periode = $arr['periode'];
            }
            if (!empty($arr['rayon']) || $arr['rayon'] == "0") {
                $where .= " AND c.koderayon = '$arr[rayon]' ";
            }
            if (!empty($arr['wilayah']) || $arr['wilayah'] == "0") {
                $where .= " AND r.kodewil = '$arr[wilayah]' ";
            }
            if (!empty($arr['golongan']) || $arr['golongan'] == "0") {
                $where .= " AND c.kodegol = '$arr[golongan]' ";
            }
            if (!empty($arr['loket']) || $arr['loket'] == "0") {
                $where .= " AND c.loketbayar = '$arr[loket]' ";
            }
            if (!empty($arr['kasir']) || $arr['kasir'] == "0") {
                $where .= " AND c.kasir = '$arr[kasir]' ";
            }

            $this->setDefaultRekapLPP();



            $query =
            "SELECT
                $this->select
                COUNT(c.kode) AS lembar,
                SUM(c.pakai) AS pakai,
                SUM(c.biayapemakaian) AS biayapemakaian,
                SUM(c.administrasi)+SUM(c.administrasilain) AS administrasi,
                SUM(c.pemeliharaan)+SUM(c.pemeliharaanlain) AS pemeliharaan,
                SUM(c.retribusi)+SUM(c.retribusilain) AS retribusi,
                SUM(c.angsuran) AS angsuran,
                SUM(c.dendatunggakan) AS dendatunggakan,
                SUM(c.total) AS total
            FROM $this->from LEFT JOIN rayon r ON c.koderayon=r.koderayon
            WHERE c.flaglunas = '1'
            AND DATE(c.tglbayar)>= '$arr[tgl1]'
            AND DATE(c.tglbayar)<= '$arr[tgl2]'
            $where
            GROUP BY $this->qgroup_by $this->sort";
            $arr = $this->selectTB($query);

            //echo $query;

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    if ($this->group_by == "golongan") {
                        $baris_info = $kol['kodegol'] ."-". $kol['golongan'];
                    }
                    else if ($this->group_by == "rayon") {
                        $baris_info = $kol['koderayon'] ."-". $kol['namarayon'];
                    }
                    else if ($this->group_by == "wilayah") {
                        $baris_info = $kol['kodewil'] ."-". $kol['wilayah'];
                    }
                    else if ($this->group_by == "periode") {
                        $baris_info = $kol['bulan'];
                    }
                    else if ($this->group_by == "loket") {
                        $baris_info = $kol['loketbayar'] ."-". $kol['loket'];
                    }
                    else if ($this->group_by == "kasir") {
                        $baris_info = $kol['kasir'];
                    }



                    $data[] = array(
                        "baris_info" => $baris_info,

                        "lmbr" => $kol['lembar'],
                        "pk" => $kol['pakai'],
                        "bya_pk" => $kol['biayapemakaian'],
                        "adm" => $kol['administrasi'],
                        "pelihara" => $kol['pemeliharaan'],
                        "ret" => $kol['retribusi'],
                        "angsur" => $kol['angsuran'],
                        "denda" => $kol['dendatunggakan'],
                        "total" => $kol['total'],
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectRekapLPPNonAir(){
            if (empty($this->id_user) || empty($this->arr_input['tgl1']) || empty($this->arr_input['tgl2'])) {
                return array("status" => "error");
            }

            $arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

            $where = "";
            /*if (!empty($arr['periode'])) {
                $this->periode = $arr['periode'];
            }*/
            if (!empty($arr['rayon']) || $arr['rayon'] == "0") {
                $where .= " AND c.koderayon = '$arr[rayon]' ";
            }
            if (!empty($arr['wilayah']) || $arr['wilayah'] == "0") {
                $where .= " AND r.kodewil = '$arr[wilayah]' ";
            }
            if (!empty($arr['loket']) || $arr['loket'] == "0") {
                $where .= " AND c.loketbayar = '$arr[loket]' ";
            }
            if (!empty($arr['kasir']) || $arr['kasir'] == "0") {
                $where .= " AND c.kasir = '$arr[kasir]' ";
            }

            $query =
            "SELECT c.jenis, COUNT(c.urutan) as lembar, SUM(c.total) as total
            FROM nonair c LEFT JOIN pelanggan p ON c.nosamb=p.nosamb LEFT JOIN rayon r ON p.koderayon=r.koderayon
            WHERE c.flaglunas = '1'
                AND DATE(c.waktubayar)>= '$arr[tgl1]'
                AND DATE(c.waktubayar)<= '$arr[tgl2]'
                $where
            GROUP BY c.jenis ASC";
            $arr = $this->selectTB($query);

            //echo $query;

            if (count($arr) > 0) {
                foreach ($arr as $kol) {
                    $data[] = array(
                        "jns" => $kol['jenis'],
                        "lmbr" => $kol['lembar'],
                        "total" => $kol['total'],
                    );
                }
                return $data;
            }
            return '';
        }

        public function selectEfektifitasPenerimaan(){
            if (empty($this->id_user) || empty($this->arr_input['bln_thn'])) {
                return array("status" => "error");
            }

            $arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

            $where = "";
            if (!empty($arr['wilayah']) || $arr['wilayah'] == "0") {
                $where .= " AND c.kodewil = '$arr[wilayah]' ";
            }
            else {
                $where .= " AND c.kodewil='ALL' ";
                $wil = "ALL";
            }

            $query =
            "SELECT c.*, LEFT(g.golongan,20) AS golongan FROM lapefektifitas c
            LEFT JOIN golongan g ON c.kodegol=g.kodegol
            WHERE c.periodebayar = '$arr[bln_thn]' $where
            ORDER BY c.kodegol ASC";
            $arr = $this->selectTB($query);

            // echo $query;

            if (count($arr) > 0) {
                $i = 1;
                foreach ($arr as $kol) {
                    $data[] = array(
                        "pen_bln_ini" => $kol['penerimaanbulanini'],
                        "pend_bln_ini" => $kol['pendapatanbulanini'],
                        "krng_bln_ini" => $kol['kekuranganbulanini'],
                        "persen_pen_bln_ini" => $kol['persenpenerimaanbulanini'],
                        "kgol" => $kol['kodegol'],
                        "pen_bln_lalu" => $kol['penerimaanbulanlalu'],
                        "pend_bln_lalu" => $kol['pendapatanbulanlalu'],
                        "krng_bln_lalu" => $kol['kekuranganbulanlalu'],
                        "persen_pen_bln_lalu" => $kol['persenpenerimaanbulanlalu'],
                    );

                    if ($i == 1) {
                        if ($wil != "ALL") {
                            $this->kwil = $kol['kodewil'];
                            $arr_wil = $this->selectWilayah();
                            $wil = $arr_wil[0]['wil'];
                        }
                        setlocale (LC_TIME, 'id_ID');

                        $header = array(
                            "bln_byr" => $kol['bulanbayar'],
                            "kwil" => $kol['kodewil'],
                            "wil" => $wil,
                            "tgl_posting" => strftime( "(%H:%M) %d %B %Y", strtotime($kol['tanggalposting'])),
                            "bln_ini" => $kol['bulanini'],
                        );

                        $i++;
                    }

                }
                return array("data" => $data, "header" => $header);
            }
            return '';
        }

        public function selectRealisasiPenerimaan(){
            if (empty($this->id_user) || empty($this->arr_input['bln_thn'])) {
                return array("status" => "error");
            }

            $arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

            $where = "";
            if (!empty($arr['wilayah']) || $arr['wilayah'] == "0") {
                $where .= " AND c.kodewil = '$arr[wilayah]' ";
            }
            else {
                $where .= " AND c.kodewil='ALL' ";
            }

            $query =
            "SELECT c.*,LEFT(g.golongan,20) as golongan FROm laprealisasi c
            LEFT JOIN golongan g ON c.kodegol=g.kodegol
            WHERE c.periodebayar = '$arr[bln_thn]' $where
            ORDER BY c.kodegol ASC";
            $arr = $this->selectTB($query);

            //echo $query;

            if (count($arr) > 0) {
                $i = 1;
                foreach ($arr as $kol) {
                    $data[] = array(
                        "pen_sblm_bln_lalu" => $kol['penerimaansebelumbulanlalu'],
                        "pen_bln_lalu" => $kol['penerimaanbulanlalu'],
                        "pen_bln_ini" => $kol['penerimaanbulanini'],
                        "jum_pen" => $kol['jumlahpenerimaan'],
                        "kgol" => $kol['kodegol'],
                        "jum_piutang" => $kol['jumlahpiutang'],
                        "piutang_bln_ini" => $kol['piutangbulanini'],
                        "piutang_bln_lalu" => $kol['piutangbulanlalu'],
                        "piutang_sblm_bln_lalu" => $kol['piutangsebelumbulanlalu'],
                    );

                    if ($i == 1) {
                        if ($wil != "ALL") {
                            $this->kwil = $kol['kodewil'];
                            $arr_wil = $this->selectWilayah();
                            $wil = $arr_wil[0]['wil'];
                        }
                        setlocale (LC_TIME, 'id_ID');

                        $header = array(
                            "bln_byr" => $kol['bulanbayar'],
                            "kwil" => $kol['kodewil'],
                            "wil" => $wil,
                            "tgl_posting" => strftime( "(%H:%M) %d %B %Y", strtotime($kol['tanggalposting'])),
                            "bln_ini" => $kol['bulanini'],
                            "bln_lalu" => $kol['bulanlalu'],
                        );

                        $i++;
                    }
                }
                return array("data" => $data, "header" => $header);
            }
            return '';
        }



        private function setDefaultLimit()
        {
            $this->limit = 50;
            $this->start_limit = 0;
        }

        private function setDefaultRekapDRD()
        {
            // Golongan
            if ($this->group_by == "golongan") {
              $this->qgroup_by = "c.kodegol";
            }

            // Rayon
            else if ($this->group_by == "rayon") {
              $this->qgroup_by = "c.koderayon";
            }

            // Wilayah
            else if ($this->group_by == "wilayah") {
              $this->qgroup_by = "CAST(r.kodewil AS UNSIGNED)";
            }
        }

        private function setDefaultRekapSaldo()
        {
            // Golongan
            if ($this->group_by == "golongan") {
              $this->qgroup_by = "c.kodegol";
            }

            // Rayon
            else if ($this->group_by == "rayon") {
              $this->qgroup_by = "c.koderayon";
            }

            // Wilayah
            else if ($this->group_by == "wilayah") {
              $this->qgroup_by = "r.kodewil";
            }

            // Periode
            else if ($this->group_by == "periode") {
              $this->qgroup_by = "c.periode";
            }
        }

        private function setDefaultRekapLPP()
        {
            $from1 = "drd c LEFT JOIN golongan g ON c.kodegol=g.kodegol";
            $from2 = "drd c LEFT JOIN loket l ON c.loketbayar=l.kodeloket";
            // Golongan
            if ($this->group_by == "golongan") {
              $this->qgroup_by = "c.kodegol";
              $this->from = $from1;
              $this->select = "c.kodegol, g.golongan,";
            }

            // Rayon
            else if ($this->group_by == "rayon") {
              $this->qgroup_by = "c.koderayon";
              $this->from = $from1;
              $this->select = "c.koderayon, r.namarayon,";
            }

            // Wilayah
            else if ($this->group_by == "wilayah") {
              $this->qgroup_by = "r.kodewil";
              $this->from = $from2;
              $this->select = "r.kodewil, r.wilayah,";
            }

            // Loket
            else if ($this->group_by == "loket") {
              $this->qgroup_by = "c.loketbayar";
              $this->from = $from2;
              $this->select = "c.loketbayar, l.loket,";
            }

            // Kasir
            else if ($this->group_by == "kasir") {
              $this->qgroup_by = "c.kasir";
              $this->from = $from1;
              $this->select = "c.kasir,";
            }

            // Periode
            else if ($this->group_by == "periode") {
              $this->qgroup_by = "c.periode";
              $this->from = $from2;
              $this->select = "c.periode, c.bulan,";
              $this->sort = "DESC";
            }
        }



		function __construct(){
			$this->connect = parent::connectHublang();
			$this->date_time = date("Y-m-d H:i:s");
            $this->setDefaultLimit();
            $this->periode = /*"201608"*/date("Ym");
            $this->sort = "ASC";
		}

		function __destruct(){
			parent::closeDB();
		}
	}
?>