<?php
	/**
	* Class untuk modul jadwal
	*/
	class JadwalClass extends class_connectDB
	{
		private $date_time;
		private $kode_prefix;
		public $arr_input;
		public $start_limit;
		public $id_user;
		public $id_pegawai;

		public $limit;

		private $connect;

		public function selectJadwalMingguan($id_peg)
		{
			if (empty($this->id_user) && empty($id_peg)) {
				return array("status" => "error");
			}

			$id_peg = mysqli_real_escape_string($this->connect, $id_peg);

			$q = "  SELECT kode_jadwal, tglwaktu_mulai, tglwaktu_selesai, nama
					FROM tb_crm_jadwal
					WHERE aktif = '1' AND tglwaktu_mulai > DATE_SUB(NOW(), INTERVAL 1 WEEK)
					AND id_pegawai = '$id_peg'
					ORDER BY tglwaktu_mulai ASC ";
			$arr = $this->selectTB($q);

			if (count($arr) > 0) {
				foreach ($arr as $kol) {
					$data[] = array("kode" => $kol['kode_jadwal'], "tgl_w_m" => "$kol[tglwaktu_mulai]", "tgl_w_s" => "$kol[tglwaktu_selesai]", "nama" => $kol['nama']);
				}
				return $data;
			}
			return '';
		}

		public function selectJadwal()
		{
			if (empty($this->id_user)) {
				return array("status" => "error");
			}

			if (!empty($this->id_pegawai)) {
				$id_pegawai = mysqli_real_escape_string($this->connect, $this->id_peg);
				$where = " AND id_pegawai = '$id_pegawai'";
			}

			if (!empty($this->limit)) {
				$limit = " LIMIT ". mysqli_real_escape_string($this->connect, $this->limit);
			}

			$q = "  SELECT kode_jadwal, tglwaktu_mulai, tglwaktu_selesai, nama, deskripsi
					FROM tb_crm_jadwal
					WHERE aktif ='1' $where
					ORDER BY tglwaktu_mulai ASC
					$limit"; //WHERE tglwaktu_mulai > DATE_SUB(NOW(), INTERVAL 1 MONTH)
			$arr = $this->selectTB($q);

			if (count($arr) > 0) {
				foreach ($arr as $kol) {
					$data[] = array(
						"kode" => $kol['kode_jadwal'],
						"tgl_w_m" => "$kol[tglwaktu_mulai]",
						"tgl_w_s" => "$kol[tglwaktu_selesai]",
						"nama" => $kol['nama'],
						"des" => $kol['deskripsi']
					);
				}
				return $data;
			}
			return '';
		}

		function __construct(){
			$this->connect = parent::connectDB();
			$this->date_time = date("Y-m-d H:i:s");
			$this->kode_prefix = date("ymdHis");
		}

		function __destruct(){
			parent::closeDB();
			//echo "<br />destruk";
		}
	}
?>