<?php
	class PegawaiClass extends class_connectDB
	{
		private $date_time;
		private $kode_prefix;
		public $arr_input;
		public $start_limit;
		public $id_user;
		public $id_peg;
		public $arr_foto;
		public $dir_perusahaan;

		private $connect;

		public function selectPegawai($arr_id_peg){
			//$arr_id_peg = array_map('mysql_real_escape_string', $arr_id_peg);
			$arr_id_peg = array_map(array($this->connect, 'real_escape_string'), $this->arr_id_peg);

			if (count($arr_id_peg) > 0 && !empty($arr_id_peg)) {
				$id_pegawai = "";
				for ($i=0; $i < count($arr_id_peg); $i++) {
					$id_pegawai .= $arr_id_peg[$i] . ",";
				}
				$id_pegawai = rtrim($id_pegawai, ",");
			}
			else {
				return "";
			}

			$query = "SELECT id_pegawai, nama, nama_lengkap FROM tb_kepegawaian_pegawai WHERE id_pegawai IN ($id_pegawai)";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
            	foreach ($arr as $kol) {
            		$hasil[] = array( "id_pegawai" => $kol["id_pegawai"], "nama" => $kol["nama"], "nama_l" => $kol["nama_lengkap"]);
            	}
            	return $hasil;
            }
            return "";
		}

		public function selectAllPeg()
		{
			if (empty($this->id_user)) {
				return '';
			}
			$query = "SELECT pg.`id_pegawai`, pg.`nama`, pg.`nama_lengkap`, pg.`foto`, pg.`jabatan`, pg.`warna`
						FROM tb_kepegawaian_pegawai pg
						INNER JOIN tb_umum_user_pegawai usr
						ON pg.`id_pegawai` = usr.`id_pegawai`
						WHERE usr.`aktif` = '1' AND pg.`nama` <> 'Admin'
						GROUP BY id_pegawai";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
            	$i = 0;
            	foreach ($arr as $kol) {
            		$hasil["peg$kol[id_pegawai]"] = array( "id_peg" => $kol["id_pegawai"], "nama" => $kol["nama"], "nama_l" => $kol["nama_lengkap"],
            			"foto" => $kol["foto"], "jabatan" => $kol["jabatan"], "warna" => $kol["warna"] );
            	}
            	return $hasil;
            }
            return "";
		}

		public function selectAllPegAdmin()
		{
			/*if (empty($this->id_user)) {
				return '';
			}*/
			$query = "SELECT pg.`id_pegawai`, pg.`nama`, pg.`nama_lengkap`, pg.`foto`, pg.`jabatan`, pg.`warna`, pg.`alamat`, pg.`tgl_lahir`, pg.`no_telpon`
						FROM tb_kepegawaian_pegawai pg
						LEFT JOIN tb_umum_user_pegawai usr
						ON pg.`id_pegawai` = usr.`id_pegawai`
						WHERE usr.`aktif` = '1' AND pg.`nama` <> 'Admin'
						GROUP BY id_pegawai";
            $arr = $this->selectTB($query);

            if (count($arr) > 0) {
            	$i = 0;
            	foreach ($arr as $kol) {
            		$data[] = array(
            			"ipeg" => $kol['id_pegawai'],
            			"nama" => $kol['nama'],
            			"nama_l" => $kol['nama_lengkap'],
            			"fpeg" => $kol['foto'],
            			"jbtn" => $kol['jabatan'],
            			"warna" => $kol['warna'],
            			"alamat" => $kol['alamat'],
            			"tgl_lhr" => $kol['tgl_lahir'],
            			"tlpn" => $kol['no_telpon'],
            		);
            	}
            	return $data;
            }
            return "";
		}

		public function selectPegawaiFromCookie($id_user, $hash_data){
			if (empty($id_user) && empty($hash_data)) {
				return  array("status" => "error");
			}
			$id_user = mysqli_real_escape_string($this->connect, $id_user);
			$hash_data = mysqli_real_escape_string($this->connect, $hash_data);


			$query = "SELECT id_pegawai FROM tb_umum_user_pegawai WHERE pass_remember = '$hash_data' AND id_pegawai='$id_user' ";
            $arr = $this->selectTB($query);

            if (count($arr) == 1) {
            	$data = $this->selectPegawaiForSession($id_user);
            	return $data;
            }
            return  array("status" => "error");
		}

		public function selectPegawaiForSession($id_user)
		{
			$id_user = mysqli_real_escape_string($this->connect, $id_user);
			$query = "SELECT usr.username, usr.password, usr.kode_struktor_atasan, usr.kode_struktor_tingkatan,
						 usr.otoritas, usr.manipulasi, usr.tipe_pegawai,
						 pg.nama, pg.nama_lengkap, pg.foto, pg.jabatan,
						 pg.id_pegawai
						 FROM tb_umum_user_pegawai usr
						 INNER JOIN tb_kepegawaian_pegawai pg
						 ON usr.id_pegawai = pg.id_pegawai
						 WHERE pg.id_pegawai = '$id_user'
						 ";
            $arr = $this->selectTB($query);
            if (count($arr) == 1) {
            	foreach ($arr as $kol) {
	            	$data = array(
		            	"username" => $kol['username'],
		            	"password" => $kol['password'],
		            	"ksa" => $kol['kode_struktor_atasan'],
		            	"kst" => $kol['kode_struktor_tingkatan'],
		            	"oto" => $kol['otoritas'],
		            	"man" => $kol['manipulasi'],
		            	"tipe" => $kol['tipe_pegawai'],
		            	"nama" => $kol['nama'],
		            	"nama_l" => $kol['nama_lengkap'],
		            	"foto" => $kol['foto'],
		            	"jbtn" => $kol['jabatan'],
		            	"id_peg" => $kol['id_pegawai'],
		            	"status" => "oke",
		            	"isPenilai" => $this->isPenilai($id_user)
		            );
            	}
            	return $data;
            }
		}

		private function isPenilai($id_user)
		{
			//$id_user = mysqli_real_escape_string($this->connect, $this->$id_user);
			$query = "SELECT id_pegawai FROM tb_jobdes_penilai WHERE id_penilai = '$id_user' LIMIT 1 ";
            $arr = $this->selectTB($query);
            //echo $query;
            if (count($arr) == 1) {
            	return true;
            }
            return false;
		}

		public function selectDetailDataPegawai($id_pegawai)
		{
			if (empty($this->id_user)) {
				return array("status" => "error");
			}

			$id_pegawai = mysqli_real_escape_string($this->connect, $id_pegawai);
			$q = "SELECT pg.nama, pg.nama_lengkap, pg.alamat, DATE_FORMAT(pg.tgl_lahir,'%d %M %X') as tgl_lahir_det,
		    		pg.tgl_lahir, pg.no_telpon, pg.email, pg.foto, pg.aktif, pg.no_pegawai, pg.pangkat, pg.id_pendidikan_terakhir,
		    		pg.id_kecamatan, pg.id_kabupatenkota, pg.id_provinsi, pg.no_pegawai,
		        kc.kecamatan, kb.kabupatenkota, pv.provinsi,
		        sor.nama_struktor,
		        pd.pendidikan_terakhir,
		        uk.unit_kerja,
		        pg.id_pangkat, pk.pangkat

				FROM tb_kepegawaian_pegawai pg
				LEFT JOIN tb_umum_kecamatan kc ON pg.id_kecamatan = kc.id_kecamatan
				LEFT JOIN tb_umum_kabupatenkota kb ON pg.id_kabupatenkota = kb.id_kabupatenkota
				LEFT JOIN tb_umum_provinsi pv ON pg.id_provinsi = pv.id_provinsi
				LEFT JOIN tb_umum_struktor sor ON pg.kode_struktor_tingkatan = sor.kode_struktor
				LEFT JOIN tb_kepegawaian_unit_kerja uk ON pg.id_unit_kerja = uk.id_unit_kerja
				LEFT JOIN tb_kepegawaian_pendidikan_terakhir pd ON pg.id_pendidikan_terakhir = pd.id_pendidikan_terakhir
				LEFT JOIN tb_kepegawaian_pangkat pk ON pg.id_pangkat = pk.id_pangkat
				WHERE pg.id_pegawai = '$id_pegawai'";

			$arr = $this->selectTB($q);
			if (count($arr) > 0) {
				foreach ($arr as $kol) {
					$data = array(
						"nama" => "$kol[nama]",
						"nama_l" => "$kol[nama_lengkap]",
						"alamat" => "$kol[alamat]",
						"tgl_lhr_teks" => "$kol[tgl_lahir_det]",
						"tgl_lhr" => "$kol[tgl_lahir]",
						"tlpn" => "$kol[no_telpon]",
						"email" => "$kol[email]",
						"foto" => "$kol[foto]",
						"aktif" => "$kol[aktif]",
						"id_kc" => "$kol[id_kecamatan]",
						"kc" => "$kol[kecamatan]",
						"id_kb" => "$kol[id_kabupatenkota]",
						"kb" => "$kol[kabupatenkota]",
						"id_pv" => "$kol[id_provinsi]",
						"pv" => "$kol[provinsi]",
						"jbtn" => "$kol[nama_struktor]",
						"id_pddk" => "$kol[id_pendidikan_terakhir]",
						"pddk" => "$kol[pendidikan_terakhir]",
						"no_peg" => "$kol[no_pegawai]",
						"pangkat" => "$kol[pangkat]",
						"uk" => "$kol[unit_kerja]",
						"ipngkt" => "$kol[id_pangkat]",
						"pngkt" => "$kol[pangkat]",
					);
				}
				return $data;
			}
			return '';
		}

		public function resetHashSession($id_user)
		{
			if (empty($id_user)) {
				return array("status" => "error");
			}
			$id_user = mysqli_real_escape_string($this->connect, $id_user);
			$q = "UPDATE tb_umum_user_pegawai SET pass_remember='' WHERE id_pegawai='". $id_user ."' ";
			$sql = $this->crudTB($q);
			return array("status" => $sql);
		}

		public function updateDataPegawai()
		{
			/*if (empty($this->id_user) || empty($this->arr_input['nama_l']) || empty($this->arr_input['nama']) ||
				empty($this->arr_input['pddk']) || empty($this->arr_input['tgl_lhr']) ||
				empty($this->arr_input['alamat']) || empty($this->arr_input['no_tlp']) || empty($this->arr_input['email'])
				) {
				return array("status" => "error");
			}*/
			$id_user = mysqli_real_escape_string($this->connect, $this->id_user);
			$arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

			if (!empty($arr['foto_peg'])) {
				$foto_kueri = " foto = '$arr[nama_foto]', ";
			}

			$query =
			"UPDATE tb_kepegawaian_pegawai
			SET
			nama='$arr[nama]', nama_lengkap='$arr[nama_l]', alamat='$arr[alamat]',
			tgl_lahir='$arr[tgl_lhr]', no_telpon='$arr[no_tlp]', email='$arr[email]', $foto_kueri

			id_kecamatan='$arr[id_kc]',id_kabupatenkota='$arr[id_kb]', id_provinsi='$arr[id_pv]',
			no_pegawai = '$arr[no_peg]',
			id_pendidikan_terakhir='$arr[pddk]',
			id_pangkat='$arr[id_pangkat]',
			alat_input='1'
			WHERE id_pegawai = '$id_user'
			";
			// echo $query;
			$sql = $this->crudTB($query);
			return array("status" => $sql);
		}

		public function selectPegawaiPenilai()
		{
			if (empty($this->id_user)) {
				return array("status" => "error");
			}
			$id_user = mysqli_real_escape_string($this->connect, $this->id_user);
			$id_peg = mysqli_real_escape_string($this->connect, $this->id_peg);
			if (empty($id_peg)) {
				$id_peg = $id_user;
			}
			$q = " SELECT id_penilai FROM tb_jobdes_penilai WHERE id_pegawai = '$id_peg' ORDER BY id_jobdes_penilai DESC LIMIT 1 ";
			$arr = $this->selectTB($q);
			if (count($arr) == 1) {
				foreach ($arr as $kol) {
					$id_penilai = $kol['id_penilai'];
				}
				$arr = $this->selectDetailDataPegawai($id_penilai);
				return $arr;
			}
			return '';
		}

		public function selectPegawaiOpsi()
		{
			if (empty($this->id_user)) {
				return array("status" => "error");
			}
			$id_user = mysqli_real_escape_string($this->connect, $this->id_user);
			$q = " SELECT isShowIncome FROM tb_user_opsi WHERE id_pegawai = '$id_user' ";
			//echo $q;
			$arr = $this->selectTB($q);
			if (count($arr) == 1) {
				foreach ($arr as $kol) {
					$data['isShowIncome'] = $kol['isShowIncome'];
				}
				return $data;
			}
			return '';
		}

		public function selectPangkatPegawai(){
			$q = "SELECT id_pangkat, pangkat FROM `tb_kepegawaian_pangkat` ";
            $arr = $this->selectTB($q);

            if (count($arr) > 0) {
            	foreach ($arr as $kol) {
            		$data[] = array(
            			"ipngkt" => $kol['id_pangkat'],
            			"pngkt" => $kol['pangkat'],
            		);
            	}
            	return $data;
            }
            return '';
		}

		function __construct(){
			$this->connect = parent::connectDB();
			$this->date_time = date("Y-m-d H:i:s");
			$this->kode_prefix = date("ymdHis");
		}

		function __destruct(){
			parent::closeDB();
			//echo "<br />destruk";
		}
	}
?>