<?php
	/**
	* Class untuk modul Produk Hukum
	*/
	class ProdukHukumClass extends class_connectDB
	{
		private $date_time;
		private $kode_prefix;
		public $arr_input;
		public $start_limit;
		public $id_user;
		public $id_pegawai;

		public $where;

		private $connect;

		public function selectProdukHukum()
		{
			if (empty($this->id_user) && empty($id_peg)) {
				return array("status" => "error");
			}

			$q = "SELECT ph.kode_produk_hukum, ph.nomor, ph.perihal, ph.tahun, ph.id_kategori, ph.berkas, ph.tglw_create, ph.tglw_update,
						ph.status, ph.keterangan, kat.kategori
				  FROM tb_produk_hukum ph INNER JOIN tb_produk_hukum_kategori kat ON ph.id_kategori = kat.id_kategori
				  WHERE ph.aktif ='1' ";
			$arr = $this->selectTB($q);
			if(count($arr) > 0){
				foreach($arr as $kol) {
					$data[] = array(
						"kph" => $kol['kode_produk_hukum'],
						"nomor" => $kol['nomor'],
						"perihal" => $kol['perihal'],
						"tahun" => $kol['tahun'],
						"ikat" => $kol['id_kategori'],
						"berkas" => $kol['berkas'],
						"tglw_create" => $kol['tglw_create'],
						"tglw_update" => $kol['tglw_update'],
						"status" => $kol['status'],
						"ket" => $kol['keterangan'],
						"kat" => $kol['kategori']
					);

				}
				return $data;

			}
			return '';
		}

		public function deleteProdukHukum($id)
		{
			if (empty($this->id_user)) {
				return array("status" => "error");
			}
			$this->id_user = mysqli_real_escape_string($this->connect, $this->id_user);
			$id = mysqli_real_escape_string($this->connect, $id);
			$q = "UPDATE tb_produk_hukum SET id_pegawai = '$this->id_user', aktif = '0' WHERE kode_produk_hukum = '$id' ";
			$sql = $this->crudTB($q);
			return array("status" => $sql);
		}

		public function selectDetailProdukHukum($id)
		{
			if (empty($this->id_user) && empty($id_peg)) {
				return array("status" => "error");
			}

			$id = mysqli_real_escape_string($this->connect, $id);

			$q = "SELECT kode_produk_hukum, nomor, perihal, tahun, id_kategori, berkas, tglw_create, tglw_update,
						status, keterangan
				  FROM tb_produk_hukum
				  WHERE kode_produk_hukum = '$id' AND aktif ='1' ";
			$arr = $this->selectTB($q);
			if(count($arr) > 0){
				foreach($arr as $kol) {
					$data = array(
						"kph" => $kol['kode_produk_hukum'],
						"nomor" => $kol['nomor'],
						"perihal" => $kol['perihal'],
						"tahun" => $kol['tahun'],
						"ikat" => $kol['id_kategori'],
						"berkas" => $kol['berkas'],
						"tglw_create" => $kol['tglw_create'],
						"tglw_update" => $kol['tglw_update'],
						"status" => $kol['status'],
						"ket" => $kol['keterangan'],
					);

				}
				return $data;

			}
			return '';
		}

		public function insertProdukHukum()
		{
			if (empty($this->id_user)) {
				return array("status" => "error");
			}

			$arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);
			$this->id_user = mysqli_real_escape_string($this->connect, $this->id_user);

			if (!empty($arr['berkas'])) {
				$berkas = $this->kode_prefix . "_" . str_replace(" ", "_", $arr['berkas']);
			}

			$kode_produk_hukum = "MPH" . $this->kode_prefix;

			$q = "INSERT INTO tb_produk_hukum
				(kode_produk_hukum, nomor, perihal, tahun, id_kategori, berkas, tglw_create, tglw_update, status, keterangan, id_pegawai)
				VALUES ('$kode_produk_hukum', '$arr[nomor]', '$arr[perihal]', '$arr[tahun]', '$arr[id_kategori]', '$berkas', '$this->date_time', '$this->date_time', '$arr[status]', '$arr[keterangan]', '$this->id_user')";
			$sql = $this->crudTB($q);
			return array(
				"status" => $sql,
				"kph" => $kode_produk_hukum,
				"nomor" => $arr['nomor'],
				"perihal" => $arr['perihal'],
				"tahun" => $arr['tahun'],
				"id_kategori" => $arr['id_kategori'],
				"berkas" => "$berkas",
				"tglw_create" => "$this->date_time",
				"tglw_update" => "$this->date_time",
				"status2" => $arr['status'],
				"keterangan" => $arr['keterangan'],
			);
		}

		public function updateProdukHukum()
		{
			if (empty($this->id_user)) {
				return array("status" => "error");
			}

			$arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);
			$this->id_user = mysqli_real_escape_string($this->connect, $this->id_user);

			if (!empty($arr['berkas'])) {
				$berkas = $this->kode_prefix . "_" . str_replace(" ", "_", $arr['berkas']);
				$q_berkas = " berkas = '$berkas', ";
			}

			$kode_produk_hukum = $arr['kph'];

			$q = "UPDATE tb_produk_hukum SET nomor = '$arr[nomor]', perihal = '$arr[perihal]', tahun = '$arr[tahun]', id_kategori = '$arr[id_kategori]',
				  $q_berkas tglw_update = '$this->date_time', status = '$arr[status]', keterangan = '$arr[keterangan]', id_pegawai = '$this->id_user'
				  WHERE kode_produk_hukum = '$kode_produk_hukum' ";
			$sql = $this->crudTB($q);
			// echo $q;
			return array(
				"status" => $sql,
				"kph" => $kode_produk_hukum,
				"nomor" => $arr['nomor'],
				"perihal" => $arr['perihal'],
				"tahun" => $arr['tahun'],
				"id_kategori" => $arr['id_kategori'],
				"berkas" => "$berkas",
				"tglw_create" => "$this->date_time",
				"tglw_update" => "$this->date_time",
				"status2" => $arr['status'],
				"keterangan" => $arr['keterangan'],
			);
		}

		public function selectKategori()
		{
			$q = "  SELECT id_kategori, kategori
					FROM tb_produk_hukum_kategori
					WHERE aktif = '1' $this->where ";
			$arr = $this->selectTB($q);

			if (count($arr) > 0) {
				foreach ($arr as $kol) {
					$data[] = array("ikat" => $kol['id_kategori'], "kat" => $kol['kategori']);
				}
				return $data;
			}
			return '';
		}

		public function insertKategori()
		{
			$arr = array_map(array($this->connect, 'real_escape_string'), $this->arr_input);

			$q = "  INSERT INTO tb_produk_hukum_kategori (id_kategori, kategori, aktif)
					VALUES ('$arr[id]', '$arr[kat]', '1') ";
			$sql = $this->crudTB($q);
			if ($sql == "oke") {
				$this->where = " AND kategori = '$arr[kat]' ORDER BY id_kategori DESC LIMIT 1 ";
				return $this->selectKategori();
			}

			return '';
		}

		function __construct(){
			$this->connect = parent::connectDB();
			$this->date_time = date("Y-m-d H:i:s");
			$this->kode_prefix = date("ymdHis");
		}

		function __destruct(){
			parent::closeDB();
			//echo "<br />destruk";
		}
	}
?>