<?php
  session_start();
  require_once 'auth/config.php';

  if(empty($_SESSION['id_pegawai'])){
    header("Location: signin?link=http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
    exit();
  }

  $bulan_server = date("m");
  $tahun_server = date("Y");
  $id_pegawai = $_SESSION['id_pegawai'];

  function nama_bulan($nilai){
    switch ($nilai) {
        case 1:
            return "Januari";
            break;
        case 2:
            return "Februari";
            break;
        case 3:
            return "Maret";
            break;
        case 4:
            return "April";
            break;
        case 5:
            return "Mei";
            break;
        case 6:
            return "Juni";
            break;
        case 7:
            return "Juli";
            break;
        case 8:
            return "Agustus";
            break;
        case 9:
            return "September";
            break;
        case 10:
            return "Oktober";
            break;
        case 11:
            return "November";
            break;
        case 12:
            return "Desember";
            break;

        default:
            return "NO";
    }
  }

  include "./function/template.php";
  headbd();
  // header
  head();
  // menu
  aside('', '');

  // $db = new class_connectDB;
  // $con = $db->connectDB();


?>

<script src="./js/highcharts.js"></script>
<script src="./js/exporting.js"></script>
<script src="./jsku/index-grafik.js"></script>
<script src="./jsku/fungsi-global-lengkap.js"></script>
<script src="./jsku/jquery.number.min.js"></script>

<script type="text/javascript">
    $(document).ready(function(e) {

      setTimeout(function () {
        getDataByAjaxJson('event/get-data-bridge.php?samb_pel=true', function(res) {
          pertumbuhanPelanggan('kon_samb_pel', res);
        });

        getDataByAjaxJson('event/get-data-bridge.php?bm_blnan=true', function(res) {
          pembacaMeterBulanan('kon_bm_blnan', res);
        });

        getDataByAjaxJson('event/get-data-bridge.php?bm_thnan=true', function(res) {
          pembacaMeterTahunan('kon_bm_thnan', res);
        });

        <?php if ($_SESSION['opsi']['isShowIncome'] == "1"): ?>
        getDataByAjaxJson('event/get-data-bridge.php?pen_loket=true', function(res) {
          if (res != "") {
            $('#pen_bulan_ini').show();
            var arr = res.data;
            var wil = res.arr_k_wil;
            if (wil !== "" && wil !== null) {
              for (var i = 0; i < wil.length; i++) {
                var isi = ''+
                '<tr>'+
                  '<td>'+ arr['wil'+ wil[i] ].wil +'</td>'+
                  '<td class="text-right">Rp '+ $.number(arr['wil'+ wil[i] ].tot_air, 0,",", ".")  +'</td>'+
                  '<td class="text-right">Rp '+ $.number(arr['wil'+ wil[i] ].tot_non_air, 0,",", ".") +'</td>'+
                '</tr>';
                $('#kon_penerimaan').append(isi);
              }
            }
          }
        });
        <?php endif ?>

        getDataByAjaxJson('event/get-data-bridge.php?jum_pel=true', function(res) {
          $('#kon_jum_pel,#kon_jum_pel2').html($.number(res.pel, 0, ",", "."));
          $('#kon_jum_pel_npel').html(res.pel_aktif + '/' + res.pel_nonaktif);
        });

        getDataByAjaxJson('event/get-data-bridge.php?jum_peg=true', function(res) {
          $('#kon_peg_tetap').html(res.peg_tetap + '/' + res.jum_peg);
          $('#kon_peg_honor').html(res.peg_honor);
        });

      }, 3000);


    });
</script>

<div class="hbox hbox-auto-xs hbox-auto-sm">
    <div class="col">
        <div class="bg-light lter b-b wrapper-md">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <h1 class="m-n font-thin h3 text-black">Dashboard</h1>
                    <small class="text-muted">Manajemen Aktivitas Pegawai</small>
                </div>
            </div>
        </div>
        <div class="wrapper-md">
            <div class="row">
                <div class="col-md-5">
                    <div class="row row-sm text-center">
                        <div class="col-xs-6">
                            <div class="panel padder-v item">
                                <div class="h1 text-info font-thin h1" id="kon_jum_pel_npel">0</div>
                                <span class="text-muted text-xs">AKTIF/NON AKTIF</span>
                                <div class="top text-right w-full">
                                    <i class="fa fa-caret-down text-warning m-r-sm"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-6">
                            <a href class="block panel padder-v bg-primary item">
                                <span class="text-white font-thin h1 block" id="kon_jum_pel2">0</span>
                                <span class="text-muted text-xs">PELANGGAN</span>
                                <span class="bottom text-right w-full">
                                  <i class="fa fa-cloud-upload text-muted m-r-sm"></i>
                                </span>
                            </a>
                        </div>
                        <div class="col-xs-6">
                            <a href class="block panel padder-v bg-info item">
                                <span class="text-white font-thin h1 block" id="kon_peg_tetap">0</span>
                                <span class="text-muted text-xs">PEGAWAI TETAP/ JML. PEGAWAI</span>
                                <span class="top text-left">
                                  <i class="fa fa-caret-up text-warning m-l-sm"></i>
                                </span>
                            </a>
                        </div>
                        <div class="col-xs-6">
                            <div class="panel padder-v item">
                                <div class="font-thin h1" id="kon_peg_honor">0</div>
                                <span class="text-muted text-xs">PEGAWAI HONOR</span>
                                <div class="bottom text-left">
                                    <i class="fa fa-caret-up text-warning m-l-sm"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 m-b-md">
                            <div class="r bg-light dker item hbox no-border">
                                <div class="col dk padder-v r-r">
                                    <div class="text-primary-dk font-thin h1"><span id="kon_real_lr">Rp 0</span></div>
                                    <span class="text-muted text-xs">LABA, <span id="kon_persen_laba">0</span>% Dari Anggaran <span id="kon_anggaran_lr">0</span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-7" style="padding: 0px; margin: 0px;">
                  <div id="kon_samb_pel" style="min-width: 310px; max-width: 100%; height: 310px; margin: 0 auto"></div>
                </div>

            </div>


            <div class="panel hbox hbox-auto-xs no-border">
                <div class="col wrapper col-md-5 no-padder">
                  <div id="kon_bm_blnan" style="min-width: 310px; max-width: 100%; height: 400px; margin: 0 auto"></div>
                </div>
                <div class="col wrapper col-md-7" style="padding: 0px; margin: 0px;">
                    <div id="kon_bm_thnan" style="width: 100%; height: 400px; margin: 0 auto;"></div>
                </div>
            </div>

            <div class="panel wrapper">
                <div class="row">
                    <div class="col-md-6 b-r b-light no-border-xs" id="pen_bulan_ini" style="display: none;">
                      <a href class="text-muted pull-right text-lg"><i class="icon-graph"></i></a>
                      <h4 class="font-thin m-t-none m-b-md text-muted">Penerimaan Bulan ini</h4>
                      <table class="table table-striped">
                        <thead>
                          <tr>
                            <th style="width: 50%;">Unit / Cabang</th>
                            <th class="text-right" style="width: 25%;">Pen. Air</th>
                            <th class="text-right" style="width: 25%;">Pen. Non Air</th>
                          </tr>
                        </thead>
                        <tbody id="kon_penerimaan"></tbody>
                      </table>
                    </div>
                    <div class="col-md-6">
                      <a href class="text-muted pull-right text-lg"><i class="icon-layers"></i></a>
                      <h4 class="font-thin m-t-none m-b-md text-muted">Informasi Lain</h4>
                      <table class="table table-bordered">
                        <tr>
                          <td style="width: 30%;">Total Pelanggan</td>
                          <td style="width: 70%;" id="kon_jum_pel"></td>
                        </tr>
                        <tr>
                          <td style="width: 30%;">Saldo Bank</td>
                          <td style="width: 70%;">
                            <div id="kon_saldo_bank">0</div>
                            <div>Update tanggal <span id="kon_tgl_saldo">0</span></div>
                          </td>
                        </tr>
                      </table>
                    </div>
                </div>
            </div>
        </div>
    </div>




</div>

<?php

    footer();
    footbd();

    //$db->closeDB();
?>