<?php
  session_start();
  require_once 'auth/config.php';

  if (!empty($_SESSION['id_pegawai'])) {

    include "./function/template.php";
    include "./class/class_hublang.php";

    $hublang = new HublangClass();
    $hublang->id_user = $_SESSION['id_pegawai'];

    headbd();
    head();

    aside('hub-rek', 'drd');
?>

<script src="./plugin/sweetalert/dist/sweetalert.min.js"></script>
<link rel="stylesheet" type="text/css" href="./plugin/sweetalert/dist/sweetalert.css">
<link rel="stylesheet" type="text/css" href="./css/global.css">

<style type="text/css">
  /*tbody {
    display:block;
    height:500px;
    overflow:auto;
  }
  thead, tfoot, tbody tr {
      display:table;
      width:100%;
      table-layout:fixed;
  }
  thead {
      width: calc( 100% - 1em )
  }
  tfoot {
      width: calc( 100% - 1em )
  }*/
</style>

<div ng-controller="hub_ctrl">
  <div class="bg-light lter b-b wrapper-sm">
    <h1 class="m-n font-thin h3 text-black">BS PAY</h1>
    <small class="text-muted">DRD (Daftar Rekening Ditagih)</small>
  </div>
  <div class="wrapper-md kon-post-act">
     <div id="x">
        <div class="panel panel-default" style="min-height: 500px;">
          <!-- <div class="panel-heading">
            <span class="text-xs text-muted pull-right">
              <i class="fa fa-chevron-down" id="btndaftar" style="cursor:pointer;" onclick="showpanel('panellist', 'btndaftar')"></i> &nbsp;&nbsp;
            </span>
            <span class="h4">Daftar Lokasi Aktivitas</span>
          </div> -->
          <div id="panellist">

              <div class="row wrapper">
                <div class="col-sm-4 col-lg-7 kon-post-act margin-bottom-10">
                    <input type="text" placeholder="Filter" ng-model="search.$" ng-change="filter()" placeholder="Filter" class="form-control" />
                </div>
                <div class="col-sm-3 col-lg-2 kon-post-act margin-bottom-10">
                  <div class="input-group">
                    <select class="form-control" id="val_limit">
                      <option value="100">100</option>
                      <option value="200">200</option>
                      <option value="300">300</option>
                      <option value="400">400</option>
                      <option value="500">500</option>
                    </select>
                    <span class="input-group-btn">
                      <button type="button" class="btn btn-md btn-primary dis_filter" ng-click="loadData()" id="btn_lihat" ng-disabled="lht_lg == false">Lihat lagi</button>
                    </span>
                  </div>
                </div>
              </div>

              <div ng-if="toggle_load_data == true" class="loading" align="center">
                 <img src="./img/loading.gif" />
                 <div class="clearfix">&nbsp;</div>
              </div>

              <div class="table-responsive" ng-show="total_drd > 0">
                <!-- dalam bentuk tabel -->
                <div id="tabel1" style="overflow:auto; height: 500px;">
                <table class="table table-bordered table-striped b-t b-light table-hover table-fixed">
                  <thead>
                    <tr>
                      <th><a>No</a></th>
                      <th><a ng-click="sort_by('no_samb');">No. Samb</a></th>
                      <th><a ng-click="sort_by('nama');">Nama</a></th>
                      <th><a ng-click="sort_by('alamat');">Alamat</a></th>
                      <th><a ng-click="sort_by('krayon');">Rayon</a></th>
                      <th><a ng-click="sort_by('kgol');">Gol</a></th>
                      <th><a ng-click="sort_by('kdiameter');">Dia</a></th>
                      <th><a ng-click="sort_by('pk');">Pakai</a></th>
                      <th><a ng-click="sort_by('bya_pk');">Harga Air</a></th>
                      <th><a ng-click="sort_by('adm');">Adm</a></th>
                      <th><a ng-click="sort_by('pelihara');">Pem</a></th>
                      <th><a ng-click="sort_by('ret');">Ret</a></th>
                      <th><a ng-click="sort_by('jml');">Jumlah</a></th>
                    </tr>
                  </thead>
                  <tbody>
                    <!-- <tr>
                      <td></td>
                      <td><input type="text" ng-model="search.no_samb" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.nama" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.alamat" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.krayon" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.kgol" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.kdiameter" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.pk" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.bya_pk" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.adm" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.pelihara" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.ret" ng-change="filter()"></td>
                      <td><input type="text" ng-model="search.jml" ng-change="filter()"></td>
                    </tr> -->
                    <tr ng-repeat="arr in filtered_drd = (list_drd | filter:search | orderBy : predicate_drd :reverse) ">
                      <td>{{$index+1}}</td>
                      <td>{{arr.no_samb}}</td>
                      <td>{{arr.nama}}</td>
                      <td>{{arr.alamat}}</td>
                      <td>{{arr.krayon}}</td>
                      <td>{{arr.kgol}}</td>
                      <td>{{arr.kdiameter}}</td>
                      <td class="text-right">{{formatNomor(arr.pk)}}</td>
                      <td class="text-right">{{formatNomor(arr.bya_pk)}}</td>
                      <td class="text-right">{{formatNomor(arr.adm)}}</td>
                      <td class="text-right">{{formatNomor(arr.pelihara)}}</td>
                      <td class="text-right">{{formatNomor(arr.ret)}}</td>
                      <td class="text-right">{{formatNomor(arr.jml)}}</td>
                    </tr>
                  </tbody>
                  <tfoot>
                    <tr>
                      <td colspan="7" class="text-center"><b>TOTAL</b></td>
                      <td class="text-right">{{ list_drd | sumByKey : 'pk' }}</td>
                      <td class="text-right">{{ list_drd | sumByKey : 'bya_pk' }}</td>
                      <td class="text-right">{{ list_drd | sumByKey : 'adm' }}</td>
                      <td class="text-right">{{ list_drd | sumByKey : 'pelihara' }}</td>
                      <td class="text-right">{{ list_drd | sumByKey : 'ret' }}</td>
                      <td class="text-right">{{ list_drd | sumByKey : 'jml' }}</td>
                    </tr>
                  </tfoot>
                </table>
                </div>
              </div>

              <div class="table-responsive" ng-show="total_drd_rekap > 0">

                <div id="tabel2" style="overflow:auto; height: 500px;">
                <table class="table table-bordered table-striped b-t b-light table-hover table-fixed">
                  <thead>
                    <tr>
                      <th class="text-center"><a>No</a></th>
                      <th><a ng-click="sort_by('baris_info');">{{ tipe }}</a></th>
                      <th class="text-right"><a ng-click="sort_by('lmbr');">Lembar</a></th>
                      <th class="text-right"><a ng-click="sort_by('pk');">Pakai</a></th>
                      <th class="text-right"><a ng-click="sort_by('bya_pk');">Harga Air</a></th>
                      <th class="text-right"><a ng-click="sort_by('adm');">By. Adm</a></th>
                      <th class="text-right"><a ng-click="sort_by('pelihara');">By. Pem</a></th>
                      <th class="text-right"><a ng-click="sort_by('ret');">By. Ret</a></th>
                      <th class="text-right"><a ng-click="sort_by('jml');">Tagihan</a></th>
                      <th class="text-right"><a ng-click="sort_by('hrg_air_rata2');">Harga Rata-rata Air </a></th>
                      <th class="text-right"><a ng-click="sort_by('hrg_pk_air_rata2');">Rata-rata Pakai Air</a></th>

                    </tr>
                  </thead>
                  <tbody>
                    <tr ng-repeat="arr in filtered_drd_rekap = (list_drd_rekap | filter:search | orderBy : predicate_drd_rekap :reverse) ">
                      <td class="text-center">{{$index+1}}</td>
                      <td>{{arr.baris_info}}</td>
                      <td class="text-right">{{formatNomor(arr.lmbr)}}</td>
                      <td class="text-right">{{formatNomor(arr.pk)}} m<sup>3</sup></td>
                      <td class="text-right">{{formatNomor2(arr.bya_pk)}}</td>
                      <td class="text-right">{{formatNomor(arr.adm)}}</td>
                      <td class="text-right">{{formatNomor(arr.pelihara)}}</td>
                      <td class="text-right">{{formatNomor(arr.ret)}}</td>
                      <td class="text-right">{{formatNomor2(arr.jml)}}</td>
                      <td class="text-right">{{formatNomor2(arr.hrg_air_rata2)}}</td>
                      <td class="text-right">{{formatNomor(arr.hrg_pk_air_rata2)}} m<sup>3</sup></td>
                    </tr>
                  </tbody>
                  <tfoot>
                    <tr>
                      <td colspan="2" class="text-center"><b>TOTAL</b></td>
                      <td class="text-right">{{ list_drd_rekap | sumByKey : 'lmbr' }}</td>
                      <td class="text-right">{{ list_drd_rekap | sumByKey : 'pk' }} m<sup>3</sup></td>
                      <td class="text-right">{{ list_drd_rekap | sumByKeyFloat : 'bya_pk' }}</td>
                      <td class="text-right">{{ list_drd_rekap | sumByKey : 'adm' }}</td>
                      <td class="text-right">{{ list_drd_rekap | sumByKey : 'pelihara' }}</td>
                      <td class="text-right">{{ list_drd_rekap | sumByKey : 'ret' }}</td>
                      <td class="text-right">{{ list_drd_rekap | sumByKeyFloat : 'jml' }}</td>
                      <td class="text-right">{{ list_drd_rekap | sumByKeyFloat : 'hrg_air_rata2' }}</td>
                      <td class="text-right">{{ list_drd_rekap | sumByKeyFloat2Int : 'hrg_pk_air_rata2' }} m<sup>3</sup></td>
                    </tr>
                  </tfoot>
                </table>
                </div>
              </div>

              <div class="table-responsive" ng-show="total_drd_banding > 0">

                <div id="tabel3" style="overflow:auto; height: 500px;">
                <table class="table table-bordered table-striped b-t b-light table-hover table-fixed">
                  <thead>
                    <tr>
                      <th class="text-center"><a>No</a></th>
                      <th><a ng-click="sort_by('kgol');">Kode</a></th>
                      <th><a ng-click="sort_by('gol');">Golongan</a></th>
                      <th class="text-right"><a ng-click="sort_by('lmbr');">Lembar</a></th>
                      <th class="text-right"><a ng-click="sort_by('pk');">Pakai</a></th>
                      <th class="text-right"><a ng-click="sort_by('bya_pk');">Harga Air</a></th>
                      <th class="text-right"><a ng-click="sort_by('adm');">By. Adm</a></th>
                      <th class="text-right"><a ng-click="sort_by('pelihara');">By. Pem</a></th>
                      <th class="text-right"><a ng-click="sort_by('ret');">By. Ret</a></th>
                      <th class="text-right"><a ng-click="sort_by('rekair');">Rek. Air</a></th>
                      <th class="text-right"><a ng-click="sort_by('naik_turun');">Naik Turun</a></th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr ng-repeat-start="arr in filtered_drd_banding = (list_drd_banding | filter:search) ">
                      <td rowspan="2" class="text-center">{{$index+1}}</td>
                      <td rowspan="2">{{arr.kgol}}</td>
                      <td rowspan="2">{{arr.gol}}</td>
                      <td class="text-right">{{formatNomor(arr.lmbr)}}</td>
                      <td class="text-right">{{formatNomor(arr.pk)}} m<sup>3</sup></td>
                      <td class="text-right">{{formatNomor(arr.bya_pk)}}</td>
                      <td class="text-right">{{formatNomor(arr.adm)}}</td>
                      <td class="text-right">{{formatNomor(arr.pelihara)}}</td>
                      <td class="text-right">{{formatNomor(arr.ret)}}</td>
                      <td class="text-right">{{formatNomor(arr.rekair)}}</td>
                      <td class="text-right">{{formatNomor(arr.naik_turun)}}</td>
                    </tr>
                    <tr ng-repeat-end>
                      <td class="text-right">{{formatNomor(arr.lmbr2)}}</td>
                      <td class="text-right">{{formatNomor(arr.pk2)}} m<sup>3</sup></td>
                      <td class="text-right">{{formatNomor(arr.bya_pk2)}}</td>
                      <td class="text-right">{{formatNomor(arr.adm2)}}</td>
                      <td class="text-right">{{formatNomor(arr.pelihara2)}}</td>
                      <td class="text-right">{{formatNomor(arr.ret2)}}</td>
                      <td class="text-right">{{formatNomor(arr.rekair2)}}</td>
                      <td></td>
                    </tr>
                  </tbody>
                  <tfoot>
                    <tr>
                      <td colspan="3" class="text-right"><b>Bulan Ini</b></td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'lmbr' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'pk' }} m<sup>3</sup></td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'bya_pk' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'adm' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'pelihara' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'ret' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'rekair' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'naik_turun' }}</td>
                    </tr>
                    <tr>
                      <td colspan="3" class="text-right"><b>Bulan Lalu</b></td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'lmbr2' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'pk2' }} m<sup>3</sup></td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'bya_pk2' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'adm2' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'pelihara2' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'ret2' }}</td>
                      <td class="text-right">{{ list_drd_banding | sumByKey : 'rekair2' }}</td>
                      <td></td>
                    </tr>
                  </tfoot>
                </table>
                </div>
              </div>


            </div>
        </div>
      </div>

  </div>

  <!-- <div class="fab bg-primary" id="masterfab" ng-click="showformacc()"><span>+</span></div> -->

  <script type="text/javascript">
    var saklar=1;
    $(document).ready(function(e) {
      $('#menu_bspay,#menu_drd').addClass('active');
      ceklebarlayar();
      $("#panel-kanan2").click(function(){
          if(saklar==0){
          //if ($(".active")[0]){
              $("#panel-kanan2").removeClass("active");
              $("#panel-kanan1").removeClass("active");
              //alert("non aktif");
              saklar=1;
          } else {
              $("#panel-kanan2").addClass("active");
              $("#panel-kanan1").addClass("active");
              //alert("aktif");
              saklar=0;
          }
      });
      $('.saklar').attr('disabled', true).trigger("chosen:updated");
    });

    function aktifNonaktif(id, tipe){
      if( $('#'+id).prop('disabled') ) {
          $('#'+id).attr('disabled', false);
      }
      else {
          $('#'+id).val('');
          $('#'+id).attr('disabled', true);

          $("#"+id).change();
      }
      if (tipe == 'combo') {
          $('#'+id).trigger("chosen:updated");
      }
    }

    $( window ).resize(function() {
      ceklebarlayar();
    });

    function ceklebarlayar() {
      var lebar = $('.app').innerWidth();
      if (lebar <= 600){
        $(".click_mob").click();
      } else {
        $(".click_web").click();
      }
    }
  </script>

  <script type="text/javascript" src="jsku/jquery.number.min.js"></script>
  <script type="text/javascript" src="jsku/drd.js"></script>

  <!-- panel Kanan -->
  <div id="panel-kanan1" class="settings panel panel-default ng-scope" style="">
    <button target=".settings" id="panel-kanan2" ui-toggle-class="active" class="btn btn-default no-shadow pos-abt ng-scope">
      <i class="fa fa-search"></i>
    </button>
    <div class="panel-heading ng-scope">
      Pencarian
    </div>
    <div class="panel-body ng-scope">
    <form method="get" ng-submit="submitFilter()" id="form_filter" name="form_filter">
      <div class="m-b-sm">
        <select class="form-control" name="jenis" id="filter_jenis" ng-model="filter_jenis" ng-change="viewFilter()">
          <option value="">Pilih</option>
          <option value="drd">Detail DRD</option>
          <option value="drd_rekap_gol">Rekap DRD Golongan</option>
          <option value="drd_rekap_rayon">Rekap DRD Rayon</option>
          <option value="drd_rekap_wil">Rekap DRD Wilayah</option>
          <option value="drd_banding">Rekap Perbandingan Periode DRD</option>
        </select>
      </div>

      <div class="m-b-sm kon_filter" id="kon_pelanggan">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_no_samb', 'text');"><i></i> Pelanggan
        </label>
        <input type="text" class="form-control saklar" id="filter_no_samb" name="no_samb" />
      </div>

      <div class="m-b-sm kon_filter" id="kon_periode">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_periode', 'combo');"><i></i> Periode
        </label>
        <select ui-jq="chosen" class="form-control saklar" id="filter_periode" name="periode">
          <option value="">-</option>
          <?php
              $arr = $hublang->selectPeriodeDRD();
              for($i=0; $i < count($arr); $i++) {
                echo '<option value="'. $arr[$i]['periode'] .'" >'. $arr[$i]['bln'] .'</option>';
              }
          ?>
        </select>
      </div>

      <div class="m-b-sm kon_filter" id="kon_rayon">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_rayon', 'combo');"><i></i> Rayon
        </label>
        <select ui-jq="chosen" class="form-control saklar" id="filter_rayon" name="rayon">
          <?php
              $arr = $hublang->selectRayon();
              for($i=0; $i < count($arr); $i++) {
                echo '<option value="'. $arr[$i]['kode'] .'" >'. $arr[$i]['rayon'] .'</option>';
              }
          ?>
        </select>
      </div>

      <div class="m-b-sm kon_filter" id="kon_wilayah">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_wil', 'combo');"><i></i> Wilayah
        </label>
        <select ui-jq="chosen" class="form-control saklar" id="filter_wil" name="wilayah">
          <?php
              $arr = $hublang->selectWilayah();
              for($i=0; $i < count($arr); $i++) {
                echo '<option value="'. $arr[$i]['kode'] .'" >'. $arr[$i]['wil'] .'</option>';
              }
          ?>
        </select>
      </div>

      <div class="m-b-sm kon_filter" id="kon_golongan">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_gol', 'combo');"><i></i> Golongan
        </label>
        <select ui-jq="chosen" class="form-control saklar" id="filter_gol" name="golongan">
          <?php
              $arr = $hublang->selectGolongan();
              for($i=0; $i < count($arr); $i++) {
                echo '<option value="'. $arr[$i]['kode'] .'" >'. $arr[$i]['gol'] .'</option>';
              }
          ?>
        </select>
      </div>

      <div class="form-group">
        <button type="submit" class="btn btn-sm btn-primary dis_filter" ng-click="setZero()" ng-disabled="filter_jenis == '' ">Cari</button>
      </div>
    </form>


    </div>
  </div>

</div>
<?php
    //
    footer();
    footbd();
    //
  }
  else {
    echo '
    <script type="text/javascript">
      document.location.href = "./signin";
    </script>
    ';
  }
?>