<?php
	session_start();
	include '../auth/config.php';
	if (empty($_SESSION['id_pegawai'])) {
		echo json_encode("not_allowed");
		exit;
	}
	include_once "../function/connect.php";
	//
	$db = new class_connectDB;
	//
	$con = $db->settingDB();
	//
	if(isset($_GET['viewall'])){
		$query = "SELECT kode_produk, nama, harga, kode_produk_bsamon,
						 keterangan, nama_produk_kategori, 
						 REPLACE(detail_produk, ':', ' : ') AS detail_produk, foto
				  FROM tb_umum_produk
				  WHERE aktif='1' limit 0,5000";
		$select = $db->selectTB($query);
		
		if(count($select) > 0){
			foreach($select as $kolom){
				$data[] = array("kode_produk" => $kolom['kode_produk'], "nama" => $kolom['nama'], "harga" => $kolom['harga'], "kode_produk_bsamon" => $kolom['kode_produk_bsamon'], "keterangan" => strip_tags($kolom['keterangan']), "nama_produk_kategori" => $kolom['nama_produk_kategori'], "detail_produk" => $kolom['detail_produk'], "foto" => $kolom['foto']);
			}		
		} else{
			$data = "";
		}

		//# JSON-encode the response
		$json_response = json_encode($data);
		
		// # Return the response
		echo $json_response;
		//
	} else if(isset($_GET['auto_complete'])) {
		$kueriProduk = 
	    " SELECT nama, harga, produk_satuan, keterangan, kode_produk
	      FROM tb_umum_produk
	      WHERE aktif = '1' limit 0,300";
	    $selectProduk = $db->selectTB($kueriProduk);
	    $jumProduk = count($selectProduk);

	    if ($jumProduk >0){
	        foreach($selectProduk as $kolomProduk) { 
	          $data[] = array($kolomProduk['nama'] , (int) $kolomProduk['harga'] , $kolomProduk['produk_satuan'] , $kolomProduk['keterangan'] , $kolomProduk['kode_produk']);
	        }	        
	    } else{
	    	$data = "";
	    }

	    $json_response = json_encode($data);
		
		// # Return the response
		echo $json_response;
	} 

	else if(isset($_GET['data_produk_dari_penawaran'])) {
		$kueriPenawaranDetail = 
	    " SELECT nama_produk, harga_jual, satuan_produk, data_produk, kode_produk, jumlah_produk
	      FROM tb_penjualan_penawaran_detail INNER JOIN tb_penjualan_penawaran USING(kode_penawaran)
	      WHERE tb_penjualan_penawaran_detail.aktif = '1' AND tb_penjualan_penawaran.kode_salespipeline='" . mysqli_real_escape_string($con, $_GET['id']) . "' ";
	    $selectPenawaranDetail = $db->selectTB($kueriPenawaranDetail);
	    $jumPenawaranDetail = count($selectPenawaranDetail);

	    if ($jumProduk >0){
	        foreach ($selectPenawaranDetail as $kolomPenawaranDetail) {
				$a_nama_produk = trim(preg_replace('/\s+/', ' ', $kolomPenawaranDetail['nama_produk']));
				$a_harga_jual = ((int)$kolomPenawaranDetail['harga_jual']);
				$a_satuan_produk = trim(preg_replace('/\s+/', ' ', $kolomPenawaranDetail['satuan_produk']));
				$a_data_produk = trim(preg_replace('/\s+/', ' ', $kolomPenawaranDetail['data_produk']));

				$a_kode_produk = trim(preg_replace('/\s+/', ' ', $kolomPenawaranDetail['kode_produk']));
				$a_jumlah_produk = trim(preg_replace('/\s+/', ' ', $kolomPenawaranDetail['jumlah_produk']));

				$data[] = array($a_nama_produk, $a_harga_jual, $a_satuan_produk, $a_data_produk, $a_kode_produk, $a_jumlah_produk);
			}
	    } else{
	    	$data = "";
	    }

	    $json_response = json_encode($data);
		
		// # Return the response
		echo $json_response;
	}
	$db->closeDB();
?>