app.filter('startFrom', function() {
  return function(input, start) {
    if(input) {
      start = +start; //parse to int
      return input.slice(start);
    }
    return [];
  }
});
app.filter('unsafe', function($sce) {
  return function(val) {
  return $sce.trustAsHtml(val);
  };
});

app.filter('sumByKey', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
      sum += parseInt(data[i][key]);
    }

    return $.number(sum, 0, ',', '.' );
    //return sum;
  };
});

app.filter('sumByKeyFloat', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]) || 0;
    }

    return $.number(sum, 2, ',', '.' );
    //return sum;
  };
});

// var template = $("#pil").html();
app.controller('admin_ctrl', function ($scope, $http, $timeout, $log) {
  $scope.$log = $log;
  // $scope.toggle_load_data = false;

  $scope.defaultSelect = function() {
    $scope.isSelectPegawai = false;
    // $scope.isSelectRegistrasi = false;

    $scope.classSelectPegawai = '';
    // $scope.classRegistrasi = '';
  }

  $scope.setZero = function () {
    $scope.isOpenSelectPegawai = false;
    // $scope.isOpenRegistrasi = false;
  }
  $scope.setZero();

  $scope.getPegawai = function(tambahan) {
    if ($scope.isOpenPegawai == true) {
      return true;
    }
    $scope.isOpenPegawai = true;
    $scope.loading_peg = true;
    $http.get('event/get-data-bridge.php?getpegawai-daftar.php?peg_all=true'+ tambahan).success(function(res){
      $scope.loading_peg = false;
      if (res[0] !== null) {
        $scope.listPegawai = res;
        $scope.total_peg = res.length;
      }
      else {
        $scope.total_peg = 0;
      }
    });
  }

  // $scope.predicate_nptt = 'nik';
  // $scope.predicate_mutasi_peg = 'nik';
  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };
  $scope.filter = function(filtered) {
    $timeout(function() {
      $scope.filteredItems = $scope[filtered].length;
    }, 10);
  };
  $scope.sort_by = function(predicate) {
    $scope.predicate = predicate;
    $scope.reverse = !$scope.reverse;
  };

  $scope.formatNomor = function (nomor) {
    return $scope.result = $.number(nomor, 0, ',', '.' );
  }

  $scope.formatNomor2 = function (nomor) {
    return $scope.result = $.number(nomor, 2, ',', '.' );
  }

  $scope.formatTgl = function (tgl) {
    return $scope.result = tanggalKeHuruf(tgl);
  }

  $scope.togleView = function (val) {
    $scope.defaultSelect();
    $log.log(val);
    if (val == "peg_all") {
      $scope.isSelectPegawai = true;
      $scope.getPegawai("");
      $scope.isOpenPegawai = true;
      $scope.classPegawai = 'active';
    }
    else if (val == "registrasi") {
     /* $scope.isSelectRegistrasi = true;
      $scope.isOpenRegistrasi = true;
      $scope.classRegistrasi = 'active';*/
    }
  }
  $scope.togleView('peg_all'); // Inisialisasi

});