function deleteact(id) {
  swal({
    title: "PERINGATAN",
    text: "Apakah anda yakin menghapus aktifitas ini?",
    type: "warning",
    showCancelButton: true,
    confirmButtonColor: "#DD6B55",
    confirmButtonText: "Ya, Hapus aktivitas",
    cancelButtonText: "Batal",
    closeOnConfirm: false
  },
  function(){
    $.ajax({
      url: "manipulation/man-aktivitas.php",
      data: "action=delete&id="+id,
      cache: false,
      success: function(msg){
        
        if(msg=="oke"){
          swal({
            title: "Aktivitas terhapus",
            type: "success",
            showCancelButton: false,
            closeOnConfirm: true
          },
          function(){
            $('#'+id+'_a').remove();
          });
        } else if(msg=="error"){
          swal({
            title: "Terjadi kesalahan",
            type: "warning",
            showCancelButton: false,
            closeOnConfirm: true
          },
          function(){
            location.reload();
          });
        }

        resetForm();
      }
    });

  });
}

function lihatlagi(awal, akhir) {
  url = "./event/getaktivitas.php?awal="+awal+"&akhir="+akhir+"&tipe=json&filterTl=true&kodePeg="+id_pegawai_login;
  $('#btnLihatLagi').html('<img src="img/loading-small.gif" />');
  getDataByAjaxJson(url, function(response){
    if(response == "data_akhir"){
      var btn_lihat_lagi = '<div class="btn btn-sm btn-default btn-rounded">Akhir</div>';
      $('#btnLihatLagi').html(btn_lihat_lagi);
    } else if(response == "data_kosong"){
      $('#isi_timeline').html('<div class="text-center h3">Anda belum membuat aktivitas</div>');
    } else if(response!=""){
      for (var p = 0; p < response.length; p++) {
        var b_aktivitas = templateAktivitas(response[p].kode_aktivitas, response[p].foto_pegawai, response[p].nama_pegawai, response[p].kegiatan, response[p].kode_customer, response[p].foto_aktivitas, response[p].tgl_waktu, response[p].isi_aktivitas, response[p].nama_customer, response[p].id_pegawai, response[p].id_kegiatandr, response[p].tag_pegawai, response[p].file_dokumen, response[p].tipe_pegawai);
        var b_komentar = "";
        $('#container_load_TL').append(b_aktivitas);
        if(response[p].komentar !== null){
          for (var q = 0; q < response[p].komentar.length; q++) {
            b_komentar = templateKomentar(response[p].komentar[q].kode_aktivitas_komen, response[p].komentar[q].foto_pegawai, response[p].komentar[q].tgl_waktu, response[p].komentar[q].nama_pegawai, response[p].komentar[q].komentar, response[p].komentar[q].id_pegawai, response[p].komentar[q].tag_pegawai);
            $('#' + response[p].kode_aktivitas + '_komentar').append(b_komentar);        
          }
        }                    
      }
      awal += 10;
      var btn_lihat_lagi = '<div class="btn btn-sm btn-default btn-rounded" onclick="lihatlagi(' + awal + ',10)">Lihat lagi</div>';
      $('#btnLihatLagi').html(btn_lihat_lagi);
      $(".group1").colorbox({rel:'group1'});
      
    }
  });
}


$(document).ready(function(e) {
  timeline_ajax();

  getDataByAjaxJson("event/getpegawai.php?show=tag_pegawai", function(response){
    if(response!=""){
      for (var p = 0; p < response.length; p++) {
        $('#tag_pegawai').append('<option value="'+ response[p].id_pegawai + '|' + response[p].nama_pegawai +'">'+ response[p].nama_pegawai +'</option>');          
      };
    }
  });
  
});

function getDataByAjaxJson(url, callback){
  var status = "true";
  $.ajax({
    url: url,
    type: "GET",
    cache: false,
    dataType: 'json',
    beforeSend: function(data) {
    },
    success: function(msg){
       status = callback(msg);
    },
    error: function(){
      getDataByAjaxJson(url, callback);
    }
  });
  return status;
}

function templateAktivitas(kode_aktivitas, foto_pegawai, nama_pegawai, kegiatan, kode_customer, foto_aktivitas, tgl_waktu, isi_aktivitas, nama_customer, id_pegawai, id_kegiatandr, tag_pegawai, file_berkas, tipe_pegawai){
  if(tag_pegawai != ""){
    tag_pegawai = "<div class='text-muted' style='margin-top:5px;'>" + tagPegawai(tag_pegawai) + "</div>";
  }
  if(file_berkas != ""){
    file_berkas = "<div class='text-muted' style='margin-top:5px;'>" + fileBerkas(file_berkas) + "</div>";
  }
  var template = "";

  template += '<li class="tl-item" id="'+ kode_aktivitas +'_a">';
  template += '<div class="tl-wrap b-primary">';
  template += '<span class="tl-date">';
  template += '<a href="#" class="thumb pull-right m-l m-t-xs avatar">';
  template += '<img src="'+ folder_foto + foto_pegawai +'" alt="...">';
  template += '<div class="text-center">'+ nama_pegawai +'</div>';
  template += '</a>';
  template += '</span>';
  template += '<div class="tl-content panel padder b-a block">';
  template += '<span class="arrow left pull-up"></span>';
  template += '<div class="text-lt m-b-sm">';
  template += '<span class="pull-right">';
  if(id_pegawai_login == id_pegawai){
    /*alert(tipe_pegawai);
    alert(id_kegiatandr);*/
    if(tipe_pegawai != 99 && id_kegiatandr != 0){
      template += '<button class="btn btn-xs btn-success" onclick="editact(\''+ kode_aktivitas +'\')" style="width:25px"><i class="fa fa-edit icon"></i></button>&nbsp;';
    }
    template += '<button class="btn btn-xs btn-danger" onclick="deleteact(\''+ kode_aktivitas +'\')" style="width:25px"><i class="fa fa-trash-o icon"></i></button>';
  }
  template += '</span>';
  template += '<b>' + kegiatan + '</b> di ';
  if(id_kegiatandr != 0){
    template += '<a href="./accounts-detail?id=' + kode_customer + '&nama_customer=' + nama_customer +'">' + nama_customer + '</a>';
  } else {
    template += nama_customer;
  }
  template += '</div>';
  template += '<div class="panel-body pull-in b-t b-light">';
  template += '<div class="clear">';
  template += '<article class="media">';
  template += '<div class="pull-left m-r">';
  //jika ada foto
  if(foto_aktivitas != ""){
    template += '<a class="group1" href="'+ folder_foto_aktivitas + foto_aktivitas +'">';
    template += '<img style="margin-right: 10px; margin-top: 10px;" src="'+ folder_foto_aktivitas + "thumbs/" + foto_aktivitas +'" alt="" height="100" class="b b-a wrapper-xs bg-white pull-left"/>';
    template += '</a>';
  }
  //end jika ada foto

  template += '</div>';
  template += '<div class="pull-right text-center text-muted" style="margin-top:10px">';
  //var tgl_waktu_string = tgl_waktu.toString();
  var tgl = tgl_waktu.substring(0, 10);
  var waktu = tgl_waktu.substring(11,16);
  var tmp_tgl_waktu = tgl.split('-');
  template += '<strong class="h4">'+ tmp_tgl_waktu[2] +'</strong><br>';
  template += '<small class="label label-primary">'+ month[parseInt(tmp_tgl_waktu[1]) - 1] + ' ' + tmp_tgl_waktu[0] +'</small><br />';
  template += '<small>'+ waktu +'</small>';
  template += '</div>';
  template += '<div class="media-body">';
  template += '<div>'+ isi_aktivitas +'</div>';
  template += '</div>';
  template += '</article>';
  template += '</div>';

  template += tag_pegawai;
  template += file_berkas;

  template += '<div style="padding-top: 5px;"><a onclick="showkomentar(\''+ kode_aktivitas +'\')" class="btn btn-xs btn-info"><i class="fa fa-comment-o icon"></i>  Komentar</a></div>';
  template += '<div class="panel panel-default m-t-md m-b-n-sm pos-rlt" style="display:none;" id="'+ kode_aktivitas +'">';
  template += '<span class="arrow top pull-left"></span>';
  template += '<form>';
  template += '<textarea class="form-control no-border" rows="3" placeholder="Komentar..." id="'+ kode_aktivitas +'_isi" style="resize:vertical;"></textarea>';
  template += '</form>';
  template += '<div class="panel-footer bg-light lter">';

  template += '<div class="input-group"> <select name="tag_komen[]" id="tag_komen'+ kode_aktivitas +'" class="form-control" ui-jq="chosen" data-placeholder="Diteruskan ke:" multiple></select>';

  template += '<span class="input-group-btn"><button class="btn btn-info btn-md" onclick="sendkomentar(\''+ kode_aktivitas +'\')">Kirim</button></div></span>';
  template += '<div class="nav nav-pills nav-sm"></div>';
  template += '</div>';
  template += '</div>';
  template += '</div>';
  template += '</div>';
  template += '<div id="'+ kode_aktivitas +'_komentar"></div>';
  template += '</li>';  

  return template;
}

function templateKomentar(kode_aktivitas_komen, foto_pegawai, tgl_waktu, nama_pegawai, komentar, id_pegawai, tag_pegawai){
  var tag_pegawai_komen = '';
  if(tag_pegawai != ""){
    tag_pegawai_komen = '<br />' + tagPegawai(tag_pegawai);
  }
  var tgl = tgl_waktu.substring(0, 10);
  var waktu = tgl_waktu.substring(11,16);
  var tmp_tgl_waktu = tgl.split('-');
  var template = "";
  template += '<div class="clearfix">&nbsp;</div>';
  template += '<div id="' + kode_aktivitas_komen + '">';
  template += '<div class="pull-left thumb-sm avatar">';
  template += '<img src="'+ folder_foto + foto_pegawai +'" alt="...">';
  template += '</div>';
  template += '<div class="m-l-xxl bg-white b-a">';
  template += '<div class="panel-heading pos-rlt">';
  template += '<span class="arrow left pull-up"></span>';
  template += '<span class="text-muted m-l-sm pull-right">' + tmp_tgl_waktu[2] + ' ' +  month[parseInt(tmp_tgl_waktu[1])-1] + ' ' + tmp_tgl_waktu[0] + ' (' + waktu + ')';
  //hapus komentar
  if(id_pegawai_login == id_pegawai){
    template += '<a onclick="delKomen(\''+ kode_aktivitas_komen + '\')"><i class="fa fa-trash-o icon text-danger"></i></a>';
  }// end hapus komentar
  template += '</span>';
  template += '<b>'+ nama_pegawai +'</b><br />' + komentar + tag_pegawai_komen;
  template += '</div>';
  template += '</div>';
  template += '</div>';

  return template;
}

function tagPegawai(tag_pegawai){
  var isi = tag_pegawai.split(", ");
  var isi2;
  var string_return = "<i class='fa fa-users icon text-muted'></i>  ";
  for (var i = 0; i < isi.length; i++) {
    isi2 = isi[i].split("|");
    string_return += '<a href="./employee-detail?id='+ parseInt(isi2[0].substring(1, isi2[0].length)) +'" target="_blank" class="text-muted">'+ isi2[1] +'</a>';
    if(i < (isi.length - 1)){
      string_return += ", ";
    }
  }
  return string_return;
}

function fileBerkas(file_berkas){
  var string_return = '<i class="fa fa-file icon"></i>  <a href="./googledoc.php?file='+ encodeURIComponent(file_berkas) +'" class="text-muted" target="_blank">'+ file_berkas.substring(12, (file_berkas.length)) +'</a>';
  return string_return;
}

function refreshTimeline(){
  $('#isi_timeline').html('');
  timeline_ajax();
}

function timelineAwal(url){
  $('#isi_timeline').html('<div class="text-center"><img src="img/loading.gif" alt="..."/><div>');
  getDataByAjaxJson(url, function(response){
    $('#isi_timeline').html('');
    if(response!=""){
      if(response == "data_kosong"){
        $('#isi_timeline').html("<div class='text-center'>Data aktivitas tidak ada</div>");
      } else{
        var btn_now = "";
        //if($('#isi_timeline').html() == ""){          
          btn_now += '<ul class="timeline">';
          btn_now += '<li class="tl-header">';
          btn_now += '<div class="btn btn-default" onclick="refreshTimeline()">Sekarang</div>';
          btn_now += '</li>';
          btn_now += '<div id="tambah_timeline"></div>';
          $('#isi_timeline').append(btn_now);
        //}

        for (var p = 0; p < response.length; p++) {
          var b_aktivitas = templateAktivitas(response[p].kode_aktivitas, response[p].foto_pegawai, response[p].nama_pegawai, response[p].kegiatan, response[p].kode_customer, response[p].foto_aktivitas, response[p].tgl_waktu, response[p].isi_aktivitas, response[p].nama_customer, response[p].id_pegawai, response[p].id_kegiatandr, response[p].tag_pegawai, response[p].file_dokumen, response[p].tipe_pegawai);
          var b_komentar = "";
          $('#isi_timeline').append(b_aktivitas);

          if(response[p].komentar !== null){
            for (var q = 0; q < response[p].komentar.length; q++) {
              b_komentar = templateKomentar(response[p].komentar[q].kode_aktivitas_komen, response[p].komentar[q].foto_pegawai, response[p].komentar[q].tgl_waktu, response[p].komentar[q].nama_pegawai, response[p].komentar[q].komentar, response[p].komentar[q].id_pegawai, response[p].komentar[q].tag_pegawai);
              $('#' + response[p].kode_aktivitas + '_komentar').append(b_komentar);
            }
          }                    
        }
        
        //if(btn_now != ""){
          var btn_lihat_lagi = "";
          btn_lihat_lagi += '<div id="container_load_TL"></div>';
          btn_lihat_lagi += '<li class="tl-header" id="btnLihatLagi">';
          btn_lihat_lagi += '<div class="btn btn-sm btn-default btn-rounded" onclick="lihatlagi(10,10)">Lihat lagi</div>';
          btn_lihat_lagi += '</li>';
          btn_lihat_lagi += '</ul>';
          $('#isi_timeline').append(btn_lihat_lagi);
          //awal += 10;
        //}
        $(".group1").colorbox({rel:'group1'});
      }
      
      
    }
  });
}
//======================================================

function showkomentar(id){    
  if ($('#'+id).is(':visible')) {
    $('#'+id).hide();
  } else{
    $('#'+id).show();
    $('#'+id+'_isi').focus();
  }

  if($('#tag_pegawai').html() != ""){
    $("#tag_komen"+id).html($('#tag_pegawai').html());
    $("#tag_komen"+id).trigger("chosen:updated");
    $("#tag_komen"+id).chosen();      
  }
}

function sendkomentar(id){
  if($('#'+id+'_isi').val()!=""){
    var tag_komen = "";
    if($("#tag_komen"+id).val()){
      tag_komen = encodeURIComponent($("#tag_komen"+id).val().join("[#]"));
    }
    $('.pull-right').prop('disabled', true);
    var comment = $('#'+id+'_isi').val();
    comment = encodeURIComponent(comment);
    if(comment!=""){
      $.ajax({
          type: "GET",
          url: "manipulation/man-aktivitas.php",
          data: "action=comment&id="+id+"&comment="+comment+"&tag_komen="+tag_komen,
          success: function(msg){
              $('#'+id+'_komentar').append(msg);
              showkomentar(id);
              $('#'+id+'_isi').val("");
              $('.pull-right').prop('disabled', false);
          },
          error: function(){
              /*alert("Komentar gagal dimasukkan");
              document.location.href = window.location.href;*/
              sendkomentar(id);
          }
      });
    }
  }
}

function delKomen(id_komen){
  swal({
    title: "PERINGATAN",
    text: "Apakah anda yakin menghapus komentar?",
    type: "warning",
    showCancelButton: true,
    confirmButtonColor: "#DD6B55",
    confirmButtonText: "Ya",
    cancelButtonText: "Batal",
    closeOnConfirm: false
  },
  function(){
    $.ajax({
      type: "GET",
      url: "manipulation/man-aktivitas.php",
      data: "del_komen=true&id_komen="+id_komen,
      success: function(msg){
        //alert(msg);
        if(msg=="oke"){            
          swal({
            title: "Aksi Sukses",
            type: "success",
            showCancelButton: false,
            closeOnConfirm: true
          },
          function(){
            $('#'+id_komen).remove();
          });
        }
      },
      error: function(){
          delKomen(id_komen);
      }
    });
   
  });    
}