app.filter('startFrom', function() {
  return function(input, start) {
    if(input) {
      start = +start; //parse to int
      return input.slice(start);
    }
    return [];
  }
});
app.filter('unsafe', function($sce) {
  return function(val) {
  return $sce.trustAsHtml(val);
  };
});

app.filter('sumByKey', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
      sum += parseInt(data[i][key]);
    }

    return $.number(sum, 0, ',', '.' );
    //return sum;
  };
});

app.filter('sumByKeyFloat', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]) || 0;
    }

    return $.number(sum, 2, ',', '.' );
    //return sum;
  };
});

// var template = $("#pil").html();
app.controller('bsbs_ctrl', function ($scope, $http, $timeout, $log) {
  $scope.$log = $log;
  $scope.toggle_load_data = false;

  $scope.defaultSelect = function() {
    $scope.isSelectSambungan = false;
    $scope.isSelectPiutang = false;
    $scope.isSelectPenerimaan = false;

    $scope.classSambungan = '';
    $scope.classPiutang = '';
    $scope.classPenerimaan = '';
  }

  $scope.setZero = function () {
    $scope.isOpenSambungan = false;
    $scope.isOpenPiutang = false;
    $scope.isOpenPenerimaan = false;
  }
  $scope.setZero();

  $scope.predicate_piutang = 'kgol';
  $scope.predicate_penerimaan = 'wil';

  $scope.getSambungan = function(tambahan) {
    if ($scope.isOpenSambungan == true) {
      return true;
    }
    $scope.isOpenSambungan = true;
    $scope.loading_sambungan = true;
    $http.get('event/get-data-bridge.php?samb_pel=true'+ tambahan).success(function(res){
      $scope.loading_sambungan = false;
      $log.log(JSON.stringify(res));
      if (res != "\"\"" ) {
        $('#l_kon_samb_pel').hide();
        pertumbuhanPelanggan('kon_samb_pel', res);
      }
      else {
        $('#l_kon_samb_pel').html('<h2 class="text-center">Koneksi ke server PDAM gagal</h2>');
      }
    });
  }
  // $scope.getSambungan("");

  $scope.getPiutang = function(tambahan) {
    if ($scope.isOpenPiutang == true) {
      return true;
    }
    $scope.isOpenPiutang = true;
    $scope.loading_piutang = true;
    $http.get('event/get-data-bridge.php?piutang=true'+ tambahan).success(function(res){
      // $log.log(res);
      $scope.loading_piutang = false;
      if (res != "\"\"") {
        $scope.list_piutang = res;
        $scope.filtered_piutang = $scope.list_piutang.length;
        $scope.total_piutang = $scope.list_piutang.length;
      }
      else {
        $scope.filtered_piutang = 0;
        $scope.total_piutang = 0;
      }
    });
  }
  // $scope.getPiutang("");

  $scope.getPenerimaan = function(tambahan) {
    if ($scope.isOpenPenerimaan == true) {
      return true;
    }
    $scope.isOpenPenerimaan = true;
    $scope.loading_penerimaan = true;
    $http.get('event/get-data-bridge.php?pen_loket=true'+ tambahan).success(function(res){
      $scope.loading_penerimaan = false;
      // $log.log(JSON.stringify(res));
      if (res != "\"\"") {
        var arr = res.data;
        var wil = res.arr_k_wil;
        var new_wil = [];
        if (wil !== "" && wil !== null) {
          for (var i = 0; i < wil.length; i++) {
            new_wil[i] = {
              wil: arr['wil'+ wil[i] ].wil,
              tot_air: parseFloat(arr['wil'+ wil[i] ].tot_air),
              tot_non_air: parseFloat(arr['wil'+ wil[i] ].tot_non_air)
            };
          }
        }

        $scope.loading_penerimaan = false;
        $scope.list_penerimaan = new_wil;
        $scope.filtered_penerimaan = $scope.list_penerimaan.length;
        $scope.total_penerimaan = $scope.list_penerimaan.length;
      }
      else {
        $scope.filtered_penerimaan = 0;
        $scope.total_penerimaan = 0;
      }

    });
  }
  //$scope.getPenerimaan("");

  // $scope.predicate_nptt = 'nik';
  // $scope.predicate_mutasi_peg = 'nik';
  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };
  $scope.filter = function(filtered) {
    $timeout(function() {
      $scope.filteredItems = $scope[filtered].length;
    }, 10);
  };
  $scope.sort_by = function(predicate) {
    $scope.predicate = predicate;
    $scope.reverse = !$scope.reverse;
  };

  $scope.formatNomor = function (nomor) {
    return $scope.result = $.number(nomor, 0, ',', '.' );
  }

  $scope.formatNomor2 = function (nomor) {
    return $scope.result = $.number(nomor, 2, ',', '.' );
  }

  $scope.formatTgl = function (tgl) {
    return $scope.result = tanggalKeHuruf(tgl);
  }

  $scope.togleView = function (val) {
    $scope.defaultSelect();
    $log.log(val);
    if (val == "sambungan") {
      $scope.isSelectSambungan = true;
      $scope.getSambungan("");
      $scope.isOpenSambungan = true;
      $scope.classSambungan = 'active';
    }
    else if (val == "piutang") {
      $scope.isSelectPiutang = true;
      // $scope.getPiutang("");
      $scope.isOpenPiutang = true;
      $scope.classPiutang = 'active';
    }
    else if (val == "penerimaan") {
      $scope.isSelectPenerimaan = true;
      $scope.getPenerimaan("");
      $scope.isOpenPenerimaan = true;
      $scope.classPenerimaan = 'active';
    }
  }
  $scope.togleView('sambungan'); // Inisialisasi grafik sambungan

  $scope.submitPiutang = function () {
    var data = $('#form_piutang').serialize();
    // $log.log(data);
    $scope.grupPiutang = $('#grup').val();
    $scope.isOpenPiutang = false;
    $scope.getPiutang("&" + data);
    $('#modal_all').modal('hide');
  }

  $scope.submitSambungan = function () {
    var thn = $('#thn_sambungan').val();
    $scope.isOpenSambungan = false;
    $scope.getSambungan("&thn=" + thn);
  }

  $scope.submitPenerimaan = function () {
    var bln_pen = $('#bln_pen').val();
    var thn_pen = $('#thn_pen').val();
    $scope.isOpenPenerimaan = false;
    $scope.getPenerimaan("&bln="+ bln_pen +"&thn=" + thn_pen);
  }

});