app.filter('startFrom', function() {
  return function(input, start) {
    if(input) {
      start = +start; //parse to int
      return input.slice(start);
    }
    return [];
  }
});
app.filter('unsafe', function($sce) {
  return function(val) {
  return $sce.trustAsHtml(val);
  };
});

app.filter('sumByKey', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
      sum += parseInt(data[i][key]);
    }

    return $.number(sum, 0, ',', '.' );
    //return sum;
  };
});

app.filter('sumByKeyFloat', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]) || 0;
    }

    return $.number(sum, 2, ',', '.' );
    //return sum;
  };
});

// var template = $("#pil").html();
app.controller('bshl_ctrl', function ($scope, $http, $timeout, $log) {
  $scope.$log = $log;
  // $scope.toggle_load_data = false;

  $scope.defaultSelect = function() {
    $scope.isSelectGrafikRegistrasi = false;
    $scope.isSelectRegistrasi = false;

    $scope.classGrafikRegistrasi = '';
    $scope.classRegistrasi = '';
  }

  $scope.setZero = function () {
    $scope.isOpenGrafikRegistrasi = false;
    $scope.isOpenRegistrasi = false;
  }
  $scope.setZero();

  $scope.getGrafikRegistrasi = function(tambahan) {
    if ($scope.isOpenSambungan == true) {
      return true;
    }
    $scope.isOpenSambungan = true;
    $scope.loading_g_reg = true;
    $http.get('event/get-data-bridge.php?grafik_registrasi=true'+ tambahan).success(function(res){
      $scope.loading_g_reg = false;
      if (res != "\"\"" ) {
        $('#l_kon_g_reg').hide();
        registrasiPelanggan('kon_g_reg', res);
      }
      else {
        $('#l_kon_g_reg').html('<h2 class="text-center">Koneksi ke server PDAM gagal</h2>');
      }
    });
  }

  $scope.getRegistrasi = function(tambahan) {
    if ($scope.isOpenRegistrasi == true) {
      return true;
    }
    $scope.isOpenRegistrasi = true;
    $scope.loading_registrasi = true;
    $http.get('event/get-data-bridge.php?registrasi=true'+ tambahan).success(function(res){
      // $log.log(res);
      $scope.loading_registrasi = false;
      if (res != "\"\"") {
        $scope.list_registrasi = res;
        $scope.filtered_registrasi = $scope.list_registrasi.length;
        $scope.total_registrasi = $scope.list_registrasi.length;
      }
      else {
        $scope.filtered_registrasi = 0;
        $scope.total_registrasi = 0;
      }
    });
  }

  // $scope.predicate_nptt = 'nik';
  // $scope.predicate_mutasi_peg = 'nik';
  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };
  $scope.filter = function(filtered) {
    $timeout(function() {
      $scope.filteredItems = $scope[filtered].length;
    }, 10);
  };
  $scope.sort_by = function(predicate) {
    $scope.predicate = predicate;
    $scope.reverse = !$scope.reverse;
  };

  $scope.formatNomor = function (nomor) {
    return $scope.result = $.number(nomor, 0, ',', '.' );
  }

  $scope.formatNomor2 = function (nomor) {
    return $scope.result = $.number(nomor, 2, ',', '.' );
  }

  $scope.formatTgl = function (tgl) {
    return $scope.result = tanggalKeHuruf(tgl);
  }

  $scope.togleView = function (val) {
    $scope.defaultSelect();
    $log.log(val);
    if (val == "grafik_registrasi") {
      $scope.isSelectGrafikRegistrasi = true;
      $scope.getGrafikRegistrasi("");
      $scope.isOpenGrafikRegistrasi = true;
      $scope.classGrafikRegistrasi = 'active';
    }
    else if (val == "registrasi") {
      $scope.isSelectRegistrasi = true;
      $scope.isOpenRegistrasi = true;
      $scope.classRegistrasi = 'active';
    }
  }
  $scope.togleView('grafik_registrasi'); // Inisialisasi grafik registrasi

  $scope.submitGrafikRegistrasi = function () {
    var thn = $('#thn_g_reg').val();
    $scope.isOpenGrafikRegistrasi = false;
    $scope.getGrafikRegistrasi("&thn=" + thn);
  }

});