app.filter('startFrom', function() {
  return function(input, start) {
    if(input) {
      start = +start; //parse to int
      return input.slice(start);
    }
    return [];
  }
});
app.filter('unsafe', function($sce) {
  return function(val) {
  return $sce.trustAsHtml(val);
  };
});

app.controller('hr_ctrl', function ($scope, $http, $timeout, $log) {
  // $scope.loading = true;
  $scope.$log = $log;
  $scope.toggle_load_data = false;

  $scope.defaultSelect = function() {
    $scope.isSelectNBNP = false;
    $scope.isSelectNPTT = false;
    $scope.isSelectMutasiPeg = false;

    $scope.classNBNP = '';
    $scope.classNPTT = '';
    $scope.classMutasiPeg = '';
  }

  $scope.setZero = function () {
    $scope.isOpenNBNP = false;
    $scope.isOpenNPTT = false;
    $scope.isOpenMutasiPeg = false;
  }
  $scope.setZero();
  // $scope.isOpenNBNP = true;

  $scope.getNBNP = function(tambahan) {
    if ($scope.isOpenNBNP == true) {
      return true;
    }
    $scope.isOpenNBNP = true;
    $scope.loading_nbnp = true;
    $log.log('event/get-data-bridge.php?hr=true&jenis=nbnp'+ tambahan);
    $http.get('event/get-data-bridge.php?hr=true&jenis=nbnp'+ tambahan).success(function(res){
    // $http.get('tes/tes1.php?hr=true&nbnp=true'+ tambahan).success(function(res){
      // $log.log(res);
      $scope.loading_nbnp = false;
      if (res != "\"\"") {
        $scope.list_nbnp = res;
        $scope.filtered_nbnp = $scope.list_nbnp.length;
        $scope.total_nbnp = $scope.list_nbnp.length;
      }
      else {
        $scope.filtered_nbnp = 0;
        $scope.total_nbnp = 0;
      }
    });
  }
  // $scope.getNBNP("");

  $scope.getNPTT = function(tambahan) {
    if ($scope.isOpenNPTT == true) {
      return true;
    }
    $scope.isOpenNPTT = true;
    $scope.loading_nptt = true;
    $http.get('event/get-data-bridge.php?hr=true&jenis=nptt'+ tambahan).success(function(res){
    // $http.get('tes/tes1.php?hr=true&nptt=true'+ tambahan).success(function(res){
      // $log.log(res);
      $scope.loading_nptt = false;
      if (res != "\"\"") {
        $scope.list_nptt = res;
        $scope.filtered_nptt = $scope.list_nptt.length;
        $scope.total_nptt = $scope.list_nptt.length;
      }
      else {
        $scope.filtered_nptt = 0;
        $scope.total_nptt = 0;
      }
    });
  }
  // $scope.getNPTT("");

  $scope.getMutasiPegawai = function(tambahan) {
    if ($scope.isOpenMutasiPeg == true) {
      return true;
    }
    $scope.isOpenMutasiPeg = true;
    $scope.loading_mutasi_peg = true;
    $http.get('event/get-data-bridge.php?hr=true&jenis=mutasi_peg'+ tambahan).success(function(res){
    // $http.get('tes/tes1.php?hr=true&mutasi_peg=true'+ tambahan).success(function(res){
      // $log.log(res);
      $scope.loading_mutasi_peg = false;
      if (res != "\"\"") {
        $scope.list_mutasi_peg = res;
        $scope.filtered_mutasi_peg = $scope.list_mutasi_peg.length;
        $scope.total_mutasi_peg = $scope.list_mutasi_peg.length;
      }
      else {
        $scope.filtered_mutasi_peg = 0;
        $scope.total_mutasi_peg = 0;
      }
    });
  }
  //$scope.getMutasiPegawai("");

  $scope.predicate_nbnp = 'nik';
  $scope.predicate_nptt = 'nik';
  $scope.predicate_mutasi_peg = 'nik';
  //$scope.predicate_banding = 'no_samb';
  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };
  $scope.filter = function(filtered) {
    $timeout(function() {
      $scope.filteredItems = $scope[filtered].length;
    }, 10);
  };
  $scope.sort_by = function(predicate) {
    $scope.predicate = predicate;
    $scope.reverse = !$scope.reverse;
  };

  $scope.showviewacc = function(tipe) {
    if (tipe == 'tabel') {
      $("#viewtabel").show();
      $("#viewlist").hide();
      $(".click_web").addClass("active");
      $(".click_mob").removeClass("active");
    } else if (tipe == 'list') {
      $("#viewtabel").hide();
      $("#viewlist").show();
      $(".click_mob").addClass("active");
      $(".click_web").removeClass("active");
    }
  };

  $scope.formatNomor = function (nomor) {
    return $scope.result = $.number(nomor, 0, ',', '.' );
  }

  $scope.formatNomor2 = function (nomor) {
    return $scope.result = $.number(nomor, 2, ',', '.' );
  }

  $scope.formatTgl = function (tgl) {
    return $scope.result = tanggalKeHuruf(tgl);
  }

  $scope.togleViewTable = function (val) {
    $scope.defaultSelect();
    $log.log(val);
    if (val == "NBNP") {
      $scope.isSelectNBNP = true;
      $scope.getNBNP("");
      $scope.isOpenNBNP = true;
      $scope.classNBNP = 'active';
    }
    else if (val == "NPTT") {
      $scope.isSelectNPTT = true;
      $scope.getNPTT("");
      $scope.isOpenNPTT = true;
      $scope.classNPTT = 'active';
    }
    else if (val == "MutasiPeg") {
      $scope.isSelectMutasiPeg = true;
      $scope.getMutasiPegawai("");
      $scope.isOpenMutasiPeg = true;
      $scope.classMutasiPeg = 'active';
    }
  }
  $scope.togleViewTable('NBNP'); // Inisialisasi NBNP

  $scope.submitNBNP = function () {
    var thn = $('#thn_nbnp').val();
    $scope.isOpenNBNP = false;
    $scope.getNBNP("&thn=" + thn);
  }

  $scope.submitNPTT = function () {
    var thn = $('#thn_nptt').val();
    $scope.isOpenNPTT = false;
    $scope.getNPTT("&thn=" + thn);
  }

  $scope.submitMutasiPegawai = function () {
    var thn = $('#thn_mutasi_peg').val();
    $scope.isOpenMutasiPeg = false;
    $scope.getMutasiPegawai("&thn=" + thn);
  }


});