app.filter('startFrom', function() {
  return function(input, start) {
    if(input) {
      start = +start; //parse to int
      return input.slice(start);
    }
    return [];
  }
});
app.filter('unsafe', function($sce) {
  return function(val) {
  return $sce.trustAsHtml(val);
  };
});
app.filter('sumByKey', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
      sum += parseInt(data[i][key]);
    }

    return $.number(sum, 0, ',', '.' );
    //return sum;
  };
});

app.filter('sumByKeyFloat', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]);
    }

    return $.number(sum, 2, ',', '.' );
    //return sum;
  };
});
app.filter('sumByKeyFloat2Int', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }
    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]);
    }
    return $.number(sum, 0, ',', '.' );
  };
});
app.controller('hub_ctrl', function ($scope, $http, $timeout, $log) {
  $scope.loading = true;
  $scope.$log = $log;
  //$scope.total_drd = 0;
  $scope.toggle_load_data = false;
  /*$scope.limit = 500;
  $scope.start_limit = 0;*/

  $scope.defaultLimit = function() {
    $scope.limit = 100;
    $scope.start_limit = 0;
  }


  $scope.setZero = function (){
    $scope.lht_lg = false;

    $scope.list_drd = [];
    $scope.filtered_drd = 0;
    $scope.total_drd = 0;

    $scope.list_drd_rekap = [];
    $scope.filtered_drd_rekap = 0;
    $scope.total_drd_rekap = 0;

    $scope.list_drd_banding = [];
    $scope.filtered_drd_banding = 0;
    $scope.total_drd_banding = 0;

    $scope.defaultLimit();
  }
  $scope.setZero();

  $scope.mergeArray = function(arr_tujuan, arr) {
    if (arr.length > 0) {
      for (var i = 0; i < arr.length; i++) {
        arr_tujuan.push(arr[i]);
      }
    }
    return arr_tujuan;
  }

  $scope.getDRD = function(tambahan) {
    $('#btn_lihat').prop('disabled', true);
    $scope.toggle_load_data = true;
    $http.get('event/gethublang.php?'+ tambahan + "&start_limit="+ $scope.start_limit + "&limit="+ $scope.limit).success(function(res){
      $scope.toggle_load_data = false;
      $('#btn_lihat').prop('disabled', false);
      if (res != "") {
        $scope.lht_lg = true;

        if ($scope.total_drd > 0) {
          //angular.extend($scope.list_drd, res);
          $scope.list_drd = $scope.mergeArray($scope.list_drd, res)
          $scope.filtered_drd += res.length;
          $scope.total_drd += res.length;
        }
        else {
          $scope.loading = false;
          $scope.list_drd = res;
          $scope.filtered_drd = $scope.list_drd.length;
          $scope.total_drd = $scope.list_drd.length;
        }
        $scope.start_limit = $scope.total_drd;
      }
    });
  }

  $scope.getRekapDRD = function(tambahan) {
    $('#btn_lihat .dis_filter').prop('disabled', true);
    $scope.toggle_load_data = true;
    $http.get('event/gethublang.php?'+ tambahan).success(function(res){
      $('#btn_lihat .dis_filter').prop('disabled', false);
      $scope.toggle_load_data = false;
      /*$log.log('event/gethublang.php?'+ tambahan);
      $log.log(res);*/
      if (res != "") {
        $scope.loading_rekap = false;
        $scope.list_drd_rekap = res;
        $scope.filtered_drd_rekap = $scope.list_drd_rekap.length;
        $scope.total_drd_rekap = $scope.list_drd_rekap.length;
      }
    });
  }

  $scope.getBandingDRD = function(tambahan) {
    $scope.toggle_load_data = true;
    $http.get('event/gethublang.php?'+ tambahan).success(function(res){
      $scope.toggle_load_data = false;
      $log.log('event/gethublang.php?'+ tambahan);
      $log.log(res);
      if (res != "") {
        $scope.loading_banding = false;
        $scope.list_drd_banding = res;
        $scope.filtered_drd_banding = $scope.list_drd_banding.length;
        $scope.total_drd_banding = $scope.list_drd_banding.length;
      }
    });
  }

  $scope.submitFilter = function () {
    $scope.jenis = $('#filter_jenis').val();
    $scope.link_data = $('#form_filter').serialize();
    //$scope.limit = 40;
    /*if ($scope.toggle_load_data == false) {
      $scope.total_drd = 0;
      $scope.total_drd_rekap = 0;
    }*/

    if ($scope.jenis == "drd") {
      $scope.getDRD("drd=true&"+ $scope.link_data);
    }
    else if ($scope.jenis == "drd_rekap_gol") {
      $scope.tipe = "Golongan";
      $scope.getRekapDRD("drd_rekap=true&"+ $scope.link_data + "&jenis=rekap_drd&group_by=golongan");
    }
    else if ($scope.jenis == "drd_rekap_rayon") {
      $scope.tipe = "Rayon";
      $scope.getRekapDRD("drd_rekap=true&"+ $scope.link_data + "&jenis=rekap_drd&group_by=rayon");
    }
    else if ($scope.jenis == "drd_rekap_wil") {
      $scope.tipe = "Wilayah";
      $scope.getRekapDRD("drd_rekap=true&"+ $scope.link_data + "&jenis=rekap_drd&group_by=wilayah");
    }
    else if ($scope.jenis == "drd_banding") {
      $scope.tipe = "";
      $scope.getBandingDRD("drd_banding=true&"+ $scope.link_data);
    }
    return false;
  }

  $scope.loadData = function(){
    //$scope.toggle_load_data = true;
    $scope.limit = parseInt( $('#val_limit').val() );
    $scope.submitFilter();
    //$scope.toggle_load_data = false;
  }

  //$scope.getDRD("");

  $scope.predicate_drd = 'no_samb';
  //$scope.predicate_banding = 'no_samb';
  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };
  $scope.filter = function() {
    $timeout(function() {
      $scope.filteredItems = $scope.filtered_drd.length;
    }, 10);
  };
  $scope.sort_by = function(predicate) {
    $scope.predicate = predicate;
    $scope.reverse = !$scope.reverse;
  };

  $scope.showviewacc = function(tipe) {
    if (tipe == 'tabel') {
      $("#viewtabel").show();
      $("#viewlist").hide();
      $(".click_web").addClass("active");
      $(".click_mob").removeClass("active");
    } else if (tipe == 'list') {
      $("#viewtabel").hide();
      $("#viewlist").show();
      $(".click_mob").addClass("active");
      $(".click_web").removeClass("active");
    }
  };

  $scope.formatNomor = function (nomor) {
    return $scope.result = $.number(nomor, 0, ',', '.' );
  }

  $scope.formatNomor2 = function (nomor) {
    return $scope.result = $.number(nomor, 2, ',', '.' );
  }

  $scope.filter_jenis = "";

  $scope.viewFilter = function(){
    $('.kon_filter').hide();
    var val = $('#filter_jenis').val();
    $log.log(val);
    if (val == "drd") {
      $('.kon_filter').show();
    }
    else if (val == "drd_rekap_gol") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
    else if (val == "drd_rekap_rayon") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
    else if (val == "drd_rekap_wil") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
    else if (val == "drd_banding") {
      $('#kon_periode,#kon_rayon,#kon_wilayah').show();
    }
  }


});