function pertumbuhanPelanggan(kon, arr){
    if (arr == "") {
        return "error";
    }

    // console.log(JSON.stringify(arr));

    var sambungan_baru = arr.samb_baru.arr_jum;
    var sudah_pasang = arr.sdh_pasang.arr_jum;

    $('#'+kon).highcharts({
        chart: {
            type: 'line'
        },
        title: {
            text: 'Pertumbuhan Pelanggan Tahun '+ arr.tahun
        },
        subtitle: {
            text: 'Source: BSBS SIM iBIMA'
        },
        xAxis: {
            categories: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Ags', 'Sep', 'Okt', 'Nov', 'Des']
        },
        yAxis: {
            title: {
                text: 'Pelanggan'
            }
        },
        tooltip: {
            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                '<td style="padding:0"><b>{point.y:.0f} pelanggan</b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        plotOptions: {
            line: {
                dataLabels: {
                    enabled: true
                }
            }
        },
        series: [{
            name: 'Sambung Baru',
            data: sambungan_baru
        },{
            name: 'Sudah Pasang',
            data: sudah_pasang
        }]
    });
}

function pembacaMeterBulanan(kon, arr){
    if (arr == "") {
        return "error";
    }

    var arr_peg = new Array();
    var arr_sdh_baca = new Array();
    var arr_blm_baca = new Array();
    var arr_target_baca = new Array();
    for (var i = 0; i < arr.data.length; i++) {
        arr_peg[i] = arr.data[i].nama_peg;
        arr_sdh_baca[i] = arr.data[i].sdh_baca;
        arr_blm_baca[i] = arr.data[i].blm_baca;
        arr_target_baca[i] = arr.data[i].sdh_baca + arr.data[i].blm_baca;
    }

    // console.log(JSON.stringify(arr_peg));
    // console.log(JSON.stringify(arr_sdh_baca));

    $('#'+ kon).highcharts({
        chart: {
            type: 'bar'
        },
        title: {
            text: 'Pembacaan Meter Bulan '+ namaBulan( parseInt(arr.bulan) ) + ' ' + arr.tahun
        },
        subtitle: {
            text: 'Source: BSRMS - SIM iBIMA '
        },
        xAxis: {
            categories: arr_peg,
            title: {
                text: null
            }
        },
        yAxis: {
            min: 0,
            title: {
                text: 'Pelanggan',
                align: 'high'
            },
            labels: {
                overflow: 'justify'
            }
        },
        tooltip: {
            valueSuffix: ' pelanggan'
        },
        plotOptions: {
            bar: {
                dataLabels: {
                    enabled: true
                }
            }
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'top',
            x: -30,
            y: 80,
            floating: true,
            borderWidth: 1,
            backgroundColor: ((Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'),
            shadow: true
        },
        credits: {
            enabled: false
        },
        series: [{
            name: 'Target Baca',
            data: arr_target_baca
        }, {
            name: 'Sudah Baca',
            data: arr_sdh_baca
        }, {
            name: 'Belum Baca',
            data: arr_blm_baca
        }]
    });
}

function registrasiPelanggan(kon, arr){
    if (arr == "") {
        return "error";
    }

    var arr_reg = arr.data;

    $('#'+kon).highcharts({
        chart: {
            type: 'line'
        },
        title: {
            text: 'Registrasi Pasang Baru Tahun '+ arr.tahun
        },
        subtitle: {
            text: 'Source: BSHL SIM iBIMA'
        },
        xAxis: {
            categories: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Ags', 'Sep', 'Okt', 'Nov', 'Des']
        },
        yAxis: {
            title: {
                text: 'Pelanggan'
            }
        },
        tooltip: {
            headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                '<td style="padding:0"><b>{point.y:.0f} pelanggan</b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true
        },
        plotOptions: {
            line: {
                dataLabels: {
                    enabled: true
                }
            }
        },
        series: [{
            name: 'Registrasi',
            data: arr_reg
        }]
    });
}

function pembacaMeterTahunan(kon, arr){
    if (arr == "") {
        return "error";
    }

    $('#'+ kon).highcharts({
        colors: ["#2b908f", "#90ee7e", "#f45b5b", "#7798BF", "#aaeeee", "#ff0066", "#eeaaee", "#55BF3B", "#DF5353", "#7798BF", "#aaeeee"],
        legendBackgroundColor: 'rgba(0, 0, 0, 0.5)',
        background2: '#505053',
        dataLabelsColor: '#B0B0B3',
        textColor: '#C0C0C0',
        contrastTextColor: '#F0F0F3',
        maskColor: 'rgba(255,255,255,0.3)',
        chart: {
            type: 'column',
            backgroundColor: {
                linearGradient: { x1: 0, y1: 0, x2: 1, y2: 1 },
                stops: [
                    [0, '#2a2a2b'],
                    [1, '#3e3e40']
                ]
            },
            style: {
                fontFamily: "'Unica One', sans-serif"
            },
            plotBorderColor: '#606063'
        },
        title: {
            text: 'Data Bacameter Tahun ' + arr.tahun,
            style: {
                color: '#E0E0E3',
                textTransform: 'uppercase',
                fontSize: '20px'
            }
        },
        subtitle: {
            text: 'Source : BSMRS - SIM iBIMA',
            style: {
                color: '#E0E0E3',
                textTransform: 'uppercase'
            }
        },
        xAxis: {
            categories: [
                'Jan',
                'Feb',
                'Mar',
                'Apr',
                'May',
                'Jun',
                'Jul',
                'Aug',
                'Sep',
                'Oct',
                'Nov',
                'Dec'
            ],
            crosshair: true,
            labels: {
                style: {
                    color: '#E0E0E3'
                }
            },
        },
        yAxis: {
            min: 0,
            title: {
                text: 'Pelanggan'
            },
            labels: {
                style: {
                    color: '#E0E0E3'
                }
            }
        },
        tooltip: {
            /*headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                '<td style="padding:0"><b>{point.y:.1f} mm</b></td></tr>',
            footerFormat: '</table>',
            shared: true,
            useHTML: true,*/
            shared: true,
            backgroundColor: 'rgba(0, 0, 0, 0.85)',
            style: {
                color: '#F0F0F0'
            }
        },
        plotOptions: {
            column: {
                pointPadding: 0.2,
                borderWidth: 0
            }
        },
        legend: {
            layout: 'vertical',
            align: 'left',
            x: 80,
            verticalAlign: 'top',
            y: 55,
            floating: true,
            backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || 'rgba(0, 0, 0, 0.85)',
            itemStyle: {
                color: '#E0E0E3'
            },
            itemHoverStyle: {
                color: '#E7Df08'
            },
            itemHiddenStyle: {
                color: '#606063'
            }
        },
        series: [{
            name: 'Target Baca',
            data: arr.data.trgt_baca

        }, {
            name: 'Sudah Baca',
            data: arr.data.sdh_baca

        }, {
            name: 'Dengan Kelainan',
            data: arr.data.jum_kelainan

        }]
    });

    // $('#'+ kon).highcharts({
    //     legendBackgroundColor: 'rgba(0, 0, 0, 0.5)',
    //     background2: '#505053',
    //     dataLabelsColor: '#B0B0B3',
    //     textColor: '#C0C0C0',
    //     contrastTextColor: '#F0F0F3',
    //     maskColor: 'rgba(255,255,255,0.3)',
    //     colors: ["#2b908f", "#90ee7e", "#f45b5b", "#7798BF", "#aaeeee", "#ff0066", "#eeaaee",
    //     "#55BF3B", "#DF5353", "#7798BF", "#aaeeee"],
    //     chart: {
    //         zoomType: 'xy',
    //         backgroundColor: {
    //             linearGradient: { x1: 0, y1: 0, x2: 1, y2: 1 },
    //             stops: [
    //                 [0, '#2a2a2b'],
    //                 [1, '#3e3e40']
    //             ]
    //         },
    //         style: {
    //             fontFamily: "'Unica One', sans-serif"
    //         },
    //         plotBorderColor: '#606063'
    //     },
    //     title: {
    //         text: 'Data Bacameter Per Tahun',
    //         style: {
    //             color: '#E0E0E3',
    //             textTransform: 'uppercase',
    //             fontSize: '20px'
    //         }
    //     },
    //     subtitle: {
    //         text: 'Source : BSMRS - SIM iBIMA',
    //         style: {
    //             color: '#E0E0E3',
    //             textTransform: 'uppercase'
    //         }
    //     },
    //     xAxis: [{
    //         categories: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun',
    //             'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'],
    //         crosshair: true,
    //         gridLineColor: '#707073',
    //         labels: {
    //             style: {
    //                 color: '#E0E0E3'
    //             }
    //         },
    //         lineColor: '#707073',
    //         minorGridLineColor: '#505053',
    //         tickColor: '#707073',
    //         title: {
    //             style: {
    //                 color: '#A0A0A3'

    //             }
    //         }
    //     }],
    //     yAxis: [{ // Primary yAxis
    //         opposite: true,
    //         gridLineColor: '#707073',
    //         labels: {
    //             style: {
    //                 color: '#FFFFFF'
    //             }
    //         },
    //         lineColor: '#707073',
    //         minorGridLineColor: '#505053',
    //         tickColor: '#707073',
    //         tickWidth: 1,
    //         title: {
    //             text: 'Kelainan',
    //             style: {
    //                 color: '#FFFFFF'
    //             }
    //         },
    //         min: 0

    //     }, { // Secondary yAxis
    //         gridLineWidth: 0,
    //         title: {
    //             text: 'Target Baca',
    //             style: {
    //                 color: '#FFFFFF'
    //             }
    //         },
    //         labels: {
    //             format: '{value}',
    //             style: {
    //                 color: '#FFFFFF'
    //             }
    //         },
    //         min: 0

    //     }, { // Tertiary yAxis
    //         gridLineWidth: 0,
    //         title: {
    //             text: 'Sudah Baca',
    //             style: {
    //                 color: Highcharts.getOptions().colors[1]
    //             }
    //         },
    //         labels: {
    //             format: '',
    //             style: {
    //                 color: Highcharts.getOptions().colors[1]
    //             }
    //         },
    //         opposite: true,
    //         min: 0
    //     }],
    //     tooltip: {
    //         shared: true,
    //         backgroundColor: 'rgba(0, 0, 0, 0.85)',
    //         style: {
    //             color: '#F0F0F0'
    //         }
    //     },
    //     legend: {
    //         layout: 'vertical',
    //         align: 'left',
    //         x: 80,
    //         verticalAlign: 'top',
    //         y: 55,
    //         floating: true,
    //         backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || 'rgba(0, 0, 0, 0.85)',
    //         itemStyle: {
    //             color: '#E0E0E3'
    //         },
    //         itemHoverStyle: {
    //             color: '#E7Df08'
    //         },
    //         itemHiddenStyle: {
    //             color: '#606063'
    //         }
    //     },
    //     series: [{
    //         name: 'Target Baca',
    //         type: 'column',
    //         yAxis: 1,
    //         data: arr.data.trgt_baca/*,
    //         tooltip: {
    //             valueSuffix: ''
    //         }*/

    //     }, {
    //         name: 'Sudah Baca',
    //         type: 'spline',
    //         yAxis: 2,
    //         data: arr.data.sdh_baca,
    //         marker: {
    //             enabled: false
    //         },
    //         dashStyle: 'shortdot'/*,
    //         tooltip: {
    //             valueSuffix: ' mb'
    //         }*/

    //     }, {
    //         name: 'Dengan Kelainan',
    //         type: 'spline',
    //         data: arr.data.jum_kelainan/*,
    //         tooltip: {
    //             valueSuffix: ' °C'
    //         }*/
    //     }]
    // });
}

Highcharts.createElement('link', {
    href: 'https://fonts.googleapis.com/css?family=Unica+One',
    rel: 'stylesheet',
    type: 'text/css'
}, null, document.getElementsByTagName('head')[0]);

/*Highcharts.theme = {
    colors: ["#2b908f", "#90ee7e", "#f45b5b", "#7798BF", "#aaeeee", "#ff0066", "#eeaaee",
        "#55BF3B", "#DF5353", "#7798BF", "#aaeeee"],
    chart: {
        backgroundColor: {
            linearGradient: { x1: 0, y1: 0, x2: 1, y2: 1 },
            stops: [
                [0, '#2a2a2b'],
                [1, '#3e3e40']
            ]
        },
        style: {
            fontFamily: "'Unica One', sans-serif"
        },
        plotBorderColor: '#606063'
    },
    title: {
        style: {
            color: '#E0E0E3',
            textTransform: 'uppercase',
            fontSize: '20px'
        }
    },
    subtitle: {
        style: {
            color: '#E0E0E3',
            textTransform: 'uppercase'
        }
    },
    xAxis: {
        gridLineColor: '#707073',
        labels: {
            style: {
                color: '#E0E0E3'
            }
        },
        lineColor: '#707073',
        minorGridLineColor: '#505053',
        tickColor: '#707073',
        title: {
            style: {
                color: '#A0A0A3'

            }
        }
    },
    yAxis: {
        gridLineColor: '#707073',
        labels: {
            style: {
                color: '#E0E0E3'
            }
        },
        lineColor: '#707073',
        minorGridLineColor: '#505053',
        tickColor: '#707073',
        tickWidth: 1,
        title: {
            style: {
                color: '#A0A0A3'
            }
        }
    },
    tooltip: {
        backgroundColor: 'rgba(0, 0, 0, 0.85)',
        style: {
            color: '#F0F0F0'
        }
    },
    plotOptions: {
        series: {
            dataLabels: {
                color: '#B0B0B3'
            },
            marker: {
                lineColor: '#333'
            }
        },
        boxplot: {
            fillColor: '#505053'
        },
        candlestick: {
            lineColor: 'white'
        },
        errorbar: {
            color: 'white'
        }
    },
    legend: {
        itemStyle: {
            color: '#E0E0E3'
        },
        itemHoverStyle: {
            color: '#FFF'
        },
        itemHiddenStyle: {
            color: '#606063'
        }
    },
    credits: {
        style: {
            color: '#666'
        }
    },
    labels: {
        style: {
            color: '#707073'
        }
    },

    drilldown: {
        activeAxisLabelStyle: {
            color: '#F0F0F3'
        },
        activeDataLabelStyle: {
            color: '#F0F0F3'
        }
    },

    navigation: {
        buttonOptions: {
            symbolStroke: '#DDDDDD',
            theme: {
                fill: '#505053'
            }
        }
    },

    // scroll charts
    rangeSelector: {
        buttonTheme: {
            fill: '#505053',
            stroke: '#000000',
            style: {
                color: '#CCC'
            },
            states: {
                hover: {
                    fill: '#707073',
                    stroke: '#000000',
                    style: {
                        color: 'white'
                    }
                },
                select: {
                    fill: '#000003',
                    stroke: '#000000',
                    style: {
                        color: 'white'
                    }
                }
            }
        },
        inputBoxBorderColor: '#505053',
        inputStyle: {
            backgroundColor: '#333',
            color: 'silver'
        },
        labelStyle: {
            color: 'silver'
        }
    },

    navigator: {
        handles: {
            backgroundColor: '#666',
            borderColor: '#AAA'
        },
        outlineColor: '#CCC',
        maskFill: 'rgba(255,255,255,0.1)',
        series: {
            color: '#7798BF',
            lineColor: '#A6C7ED'
        },
        xAxis: {
            gridLineColor: '#505053'
        }
    },

    scrollbar: {
        barBackgroundColor: '#808083',
        barBorderColor: '#808083',
        buttonArrowColor: '#CCC',
        buttonBackgroundColor: '#606063',
        buttonBorderColor: '#606063',
        rifleColor: '#FFF',
        trackBackgroundColor: '#404043',
        trackBorderColor: '#404043'
    },

    // special colors for some of the
    legendBackgroundColor: 'rgba(0, 0, 0, 0.5)',
    background2: '#505053',
    dataLabelsColor: '#B0B0B3',
    textColor: '#C0C0C0',
    contrastTextColor: '#F0F0F3',
    maskColor: 'rgba(255,255,255,0.3)'
};*/

// Apply the theme
//Highcharts.setOptions(Highcharts.theme);