// JavaScript Document
var scope = angular.element($("#tabelKontrol")).scope();

var saklar=1;
$(document).ready(function(e) {
	$('#modal_input').on('hidden.bs.modal', function () {
		$('.hide_jdp').hide();
	  	$('#form_jobdes_pegawai').resetForm();
	});
	ceklebarlayar();
	$("#panel-kanan2").click(function(){
		if(saklar==0){
			$("#panel-kanan2").removeClass("active");
			$("#panel-kanan1").removeClass("active");
			saklar=1;
		} else {
			$("#panel-kanan2").addClass("active");
			$("#panel-kanan1").addClass("active");
			saklar=0;
		}
	});

	$('.saklar').attr('disabled', true).trigger("chosen:updated");

	getDataByAjaxJson("event/getpegawai.php?show=tag_pegawai", function(res){
      if(res!=""){
		global_arr_pegawai = res;
		for (var p = 0; p < res.length; p++) {
          $('#filter_pegawai, #filter_pegawai2').append('<option value="'+ res[p].id_pegawai + '">'+ res[p].nama_pegawai +' - ' + res[p].jabatan +'</option>');
		};
		$("#filter_pegawai, #filter_pegawai2").trigger("chosen:updated");
      }
    });

    $('.nomor').mask('000.000.000.000.000', {reverse: true});
    $('.nomor_bulan').mask('00', {reverse: true});
    $('.ak').mask('00,00', {'translation': {0: {pattern: /[0-9,]/}}});
});

$( window ).resize(function() {
    ceklebarlayar();
});

function ceklebarlayar() {
    var lebar = $('.app').innerWidth();
    if (lebar <= 600){
        $("#tmpllist,.click_mob").click();
    } else {
        $("#tmpltable,.click_web").click();
    }
}

app.filter('startFrom', function() {
	return function(input, start) {
		if(input) {
			start = +start; //parse to int
			return input.slice(start);
		}
		return [];
	}
});

app.filter('unsafe', function($sce) {
	return function(val) {
		return $sce.trustAsHtml(val);
	};
});

/*app.filter('getById', function() {
  return function(input, id) {
    var i=0, len=input.length;
    for (; i<len; i++) {
      if (+input[i].id == +id) {
        return input[i];
      }
    }
    return null;
  }
});*/

app.directive('compile', ['$compile', function ($compile) {
  return function(scope, element, attrs) {
    scope.$watch(
      function(scope) {
        return scope.$eval(attrs.compile);
      },
      function(value) {
        element.html(value);
        $compile(element.contents())(scope);
      }
   )};
}]);



app.controller('tabelKontrol', function ($scope, $http, $timeout, $log) {
	//$('#page-loader').show();
	$scope.$log = $log;
	$scope.loading = true;

	$scope.loadDataPegawai = function () {
		$scope.loading = true;
		$http.get('event/getjobdes_oop.php?semua_jobdesku=true').success(function(data){
			$scope.loading = false;
			$scope.currentPage = 1; //current page
			$scope.entryLimit = 10; //max no of items to display in a page
			if (data != "\"\"") {
				//$('#page-loader').hide();
				$scope.list = data;
				$scope.filteredItems = $scope.list.length; //Initially for no filter
				$scope.totalItems = $scope.list.length;
			}
			else {
				$scope.totalItems = 0;
				$scope.list = [];
			}
		});

	}

	$scope.loadDataPegawai();

	$scope.loadDataPegawaiBawahan = function () {
		$http.get('event/getjobdes_oop.php?jobdes_peg_bawahan=true').success(function(data){
			if (data != "\"\"") {
				$scope.listJDP = data;
				$scope.currentPageJDP = 1; //current page
				$scope.entryLimitJDP = 10; //max no of items to display in a page
				$scope.filteredItemsJDP = $scope.listJDP.length; //Initially for no filter
				$scope.totalItemsJDP = $scope.listJDP.length;

				$scope.listJDP2 = data;
				$scope.currentPageJDP2 = 1;
				$scope.entryLimitJDP2 = 20;
				$scope.filteredItemsJDP2 = $scope.listJDP2.length;
				$scope.totalItemsJDP2 = $scope.listJDP2.length;
			}
		});
	}

	$scope.loadDataPegawaiBawahan();

	$scope.formatNomor = function (nomor) {
		return $scope.result = $.number(nomor, 0, ',', '.' );
	}

	$scope.buatDetail = function (arr, tipe) {
		var template = '';
		var value;
		for (var i = 0; i < arr.length; i++) {
			if (i >0) {
				template += '<div class="line line-dashed b-b line-md"></div>';
			}
			if (tipe == "nomor") {
				value = "Rp " + $.number(arr[i], 0, ',', '.' );
			}
			else if (tipe == "bulan"){
				value = arr[i] + " bulan";
			}
			else {
				value = arr[i];
			}
			template += value;
		}
		return template;
	}
	$scope.buatDetailListView = function (arr, id_peg, arr2) {
		var template = '';
		for (var i = 0; i < arr.length; i++) {
			if (i >0) {
				template += '<div class="line line-dashed b-b line-md"></div>';
			}
			template +=  arr[i];
			template += '<div><b>Kuantitas:</b> '+ arr2.ktts[i] + ' ' + arr2.sat[i] +'</div>';
            template += '<div><b>Kualitas:</b> '+ arr2.kua[i] +'</div>';
            template += '<div><b>Waktu:</b> '+ arr2.waktu[i] +' bln</div>';
            template += '<div><b>Biaya:</b> Rp '+ $.number(arr2.biaya[i], 0, ',', '.' ) +'</div>';
            template += '<a href="#" class="link-web" onclick="showPenilaian(\''+ id_peg +'\', \''+ arr2.kode[i] +'\')"><i class="glyphicon glyphicon-list-alt"></i> Penilaian</a>';
		}
		return template;
	}
	$scope.buatDetailKuantitas = function (arr1, arr2) {
		var template = '';
		for (var i = 0; i < arr1.length; i++) {
			if (i >0) {
				template += '<div class="line line-dashed b-b line-md"></div>';
			}
			template += arr1[i] + ' ' + arr2[i];
		}
		return template;
	}
	$scope.buatDetailLink = function (id_peg, arr_jd) {
		var template = '';
		for (var i = 0; i < arr_jd.length; i++) {
			if (i >0) {
				template += '<div class="line line-dashed b-b line-md"></div>';
			}
			template += '<a href="#" class="link-web" onclick="showPenilaian(\''+ id_peg +'\', \''+ arr_jd[i] +'\')"><i class="glyphicon glyphicon-list-alt"></i> Penilaian</a>';
		}
		return template;
	}

	$scope.submitJDPeg = function () {
		var input = {
			biasa: ["kuantitas", "satuan", "kualitas", "biaya", "target", "ak"],
			pilihan_biasa: ["jobdes_text"]
		}
		var form_option = {
	      url: 'manipulation/man-jobdes-oop.php',
	      dataType: 'json',
	      /*resetForm: true,*/
	      beforeSubmit: function (formData, jqForm, options) {
	        var isNoError = false;
	        isNoError = tandaErrorInputBiasa(input.biasa);
	        if ($('#t1').hasClass('active')) {
	        	isNoError = forceIsFalse(isNoError, tandaErrorInputBiasa(input.pilihan_biasa));
	        }
	        else {
	        	$('#jobdes_text').val('');
	        }

	        //alert(JSON.stringify(global_form_option));
	        //alert(isNoError);

	        if (isNoError == true) {
	          $('#form_jobdes_pegawai :input').prop('disabled', true);
	        }
	        return isNoError;
	      },
	      success: function(res, statusText, xhr, $form){
			$('.info_jdp').hide();
			$log.log(JSON.stringify(res));
			//$('#konsole').append(JSON.stringify(res));
	      	if (res.aksi == "update" && res.status == "oke") {
	      		/*var indeks = $scope.getIndexOfArray($scope.list, 'kode_jdp', res.kode_jdp);
	      		var tmp_data = $scope.list[indeks];*/

	      		//$('#konsole').append("indeks: "+ indeks + "<br />");

	      		$scope.tmp_data.kode_jdp = res.kode_jdp;
	      		$scope.tmp_data.kode = res.kode;
	      		$scope.tmp_data.job = res.job;
	      		$scope.tmp_data.trgt_kerja = res.trgt_kerja;
	      		$scope.tmp_data.kua = res.kua;
	      		$scope.tmp_data.biaya = res.biaya;
	      		$scope.tmp_data.ktts = res.ktts;
	      		$scope.tmp_data.sat = res.sat;
	      		$scope.tmp_data.ak = res.ak;

	      		//$('#konsole').append(JSON.stringify(tmp_data) + "<br />");


	      		//$scope.list[indeks] = tmp_data;
	      		$scope.list.push($scope.tmp_data);
	      		$scope.filteredItems = $scope.list.length;
				$scope.totalItems = $scope.list.length;

	      		//$('#konsole').append(JSON.stringify($scope.list) + "<br />");
	      		//$scope.$apply();
	      		$('#form_jobdes_pegawai').resetForm();
	      	}
	      	// jika skp yang dimasukan sudah ada di pegawai
	      	else if (res.status == "sama"){
	      		$('#save').val('update_jobdes_pegawai_from_pegawai');
	      		$('#info_jdp_konfim_update').show();
	      		$('#id_jdp').val(res.kode_jdp);
	      		$('#tv_jdp').html( $('input[name=radioName]:checked', '#form_jobdes_pegawai').html() );
	      	}
	      	else if (res.status == "oke") {
	      		//alert("oke");
	      		$scope.loadDataPegawai();

				$('#info_jdp_sukses').show();
				$('#form_jobdes_pegawai').resetForm();
	      	}
	        else{
	      		defaultSwalError();
				$('#info_jdp_gagal').show();
	        }
	        $('#form_jobdes_pegawai :input').prop('disabled', false);
	      }
	    };

		$('#form_jobdes_pegawai').ajaxSubmit(form_option);
	}

	$scope.getIndexOfArray = function (arr, obj, find) {
		for(var i = 0; i < arr.length; i++){
			var tmp_arr = arr[i];
			if (tmp_arr[obj] == find) {
				var indexnya = i;
				break;
			}
		}
		return indexnya;
	}

	$scope.submitPenilai = function () {
		if ( $('#penilai').val() == "" ) {
			defaultSwalError();
			return false;
		}
		var data = $('#form_penilai').serialize();
		//$log.log("manipulation/man-jobdes-oop.php?save_penilai=true&"+ data);
		$http.get("manipulation/man-jobdes-oop.php?save_penilai=true&"+ data).then(function (res) {
			if (res.data.status == "oke") {
				defaultSwalSuccess();
			}
			else {
				defaultSwalError();
			}
		});
	}

	$scope.accJDPeg = function (id, kode, peg, arr_tag, arr_index) {
		var status = 0;
		$('#wait'+ id + "," +'#wait_l'+ id).removeClass().addClass('fa fa-refresh fa-spin').show();
		setTimeout(function () {
			if ($('#'+ arr_tag.t + id).is(':checked')) {
				status = 1;
			}
			$http.get('manipulation/man-jobdes-oop.php?set_acc_pegawai=true&id='+ kode + '&status=' + status + '&peg=' + peg).success(function(res) {
				$log.log(res);
				if (res.status == "error") {
					defaultSwalError();
					if (status == 1) {
						$('#'+ arr_tag.t + id).attr("checked", false);
					}
					else {
						$('#'+ arr_tag.t + id).attr("checked", true);
					}
					$('#wait'+ id + "," +'#wait_l'+ id).removeClass('fa-refresh fa-spin').addClass('fa-times text-danger');
				}
				else if (res.status == "oke"){
					$('#wait'+ id + "," +'#wait_l'+ id).removeClass('fa-refresh fa-spin').addClass('fa-check text-success');
					$scope.listJDP2[arr_index.p].isAccPen[arr_index.c] = status;
					//$scope.apply();
				}

				setTimeout(function () {
					$('#wait'+ id + "," +'#wait_l'+ id).fadeOut();
				}, 2000);

			});
		}, 2000);
	}




	$http.get('event/getjobdes_oop.php?jobdes_master=true').success(function(data){
		$scope.dataJDM = data;
/*		$scope.currentPage = 1; //current page
		$scope.entryLimit = 10; //max no of items to display in a page*/
		$scope.filteredItemsJDM = $scope.dataJDM.length; //Initially for no filter
		$scope.totalItemsJDM = $scope.dataJDM.length;
	});

	$scope.predicate = 'kode';
	$scope.predicateJDP = 'tglw_create';
	$scope.predicateJDP2 = 'tglw_create';
	$scope.predicateJDM = 'job';
	$scope.last_kode = '';


	$scope.setPage = function(pageNo) {
		$scope.currentPage = pageNo;
	};

	$scope.filter = function() {
		$timeout(function() {
			$scope.filteredItems = $scope.filtered.length;
		}, 10);
	};

	$scope.sort_by = function(predicate) {
		$scope.predicate = predicate;
		$scope.reverse = !$scope.reverse;
	};

	$scope.clickRowJDM = function (kode) {
		$('#jdm'+ kode).click();
	};

	$scope.ifThisChecked = function (this_tag, another_tag) {
		$log.log( this_tag + "|" + another_tag );
		if ( $('#'+ this_tag).is(':checked') ) {
			$('#'+ another_tag).attr('checked', true);
			//$log.log($('#'+ another_tag).attr('checked', true));
			//return true;
		}
		//return false;
		else {
			$('#'+ another_tag).attr('checked', false);
			$log.log(false);
		}
	};

	$scope.showviewacc = function(tipe) {
		if (tipe == 'tabel') {
			$("#viewtabel").show();
			$("#viewlist").hide();
			$("#tmpltable").addClass("active");
            $("#tmpllist").removeClass("active");
		} else if (tipe == 'list') {
			$("#viewtabel").hide();
			$("#viewlist").show();
			$("#tmpllist").addClass("active");
            $("#tmpltable").removeClass("active");
		} else if (tipe == 'tabelJDP') {
			$("#viewtabelJDP").show();
			$("#viewlistJDP").hide();
			$("#tmpltableJDP").addClass("active");
            $("#tmpllistJDP").removeClass("active");
		} else if (tipe == 'listJDP') {
			$("#viewtabelJDP").hide();
			$("#viewlistJDP").show();
			$("#tmpllistJDP").addClass("active");
            $("#tmpltableJDP").removeClass("active");
		} else if (tipe == 'tabelJDP2') {
			$("#viewtabelJDP2").show();
			$("#viewlistJDP2").hide();
			$("#tmpltableJDP2").addClass("active");
            $("#tmpllistJDP2").removeClass("active");
		} else if (tipe == 'listJDP2') {
			$("#viewtabelJDP2").hide();
			$("#viewlistJDP2").show();
			$("#tmpllistJDP2").addClass("active");
            $("#tmpltableJDP2").removeClass("active");
		}
	};

	$scope.selectTableRow = function(kode) {
		if (kode) {
			showPenilaian(false, kode);
			//if ($scope.last_kode != kode) {
				/*$('#loading_modal').show();
				$scope.last_kode = kode;
				getDataByAjaxJson('event/getjobdes_oop.php?jobdes_aktivitas=true&kode_jd='+kode, function(res){
					createTableInModal(res);
					$('#loading_modal').hide();
				});*/
			//}
			//$('#modal_detail').modal('show');
		}
	};
});


function aktifNonaktif(id, tipe){
	if( $('#'+id).prop('disabled') ) {
		$('#'+id).attr('disabled', false);
	}
	else {
		$('#'+id).val('');
		$('#'+id).attr('disabled', true);

		$("#"+id).change();
	}
	if (tipe == 'combo') {
		$('#'+id).trigger("chosen:updated");
	}
}

function createTableInModal(arr) {
	$('.isi_modal').hide();
	$('#isi_modal').show();
	$('#isi_tabel_modal').html('');
	if (arr == "") {
		$('#isi_tabel_modal').html('<tr><td colspan="4">Tidak ada data</td></tr>');
	}
	else {
		for (var i = 0; i < arr.length; i++) {
			var tmp_tglw = tglWkt2Arr(arr[i].tglw_create);
			var template = ''+
				'<tr style="cursor:pointer;" title="Klik untuk melihat aktivitas" onclick="'+ linkAktivitas({kode: arr[i].kode, jenis:'jobdes'}) +'">'+
				'<td>'+ tmp_tglw.tgl + ' ' + tmp_tglw.bulan + ' ' + tmp_tglw.thn +'</td>'+
	            '<td>'+ $.number(arr[i].ktts, 0, ',', '.' ) +' '+ arr[i].sat +'</td>'+
	            '<td>'+ arr[i].kua +'</td>'+
	            '<td>Rp '+ $.number(arr[i].biaya, 0, ',', '.' ) +'</td>'+
	            '</tr>';
	        $('#isi_tabel_modal').append(template);
		}
	}
	$('#isi_modal').show();
}

function linkAktivitas(arr) {
	if (arr != "" && arr != null) {
		var link = "location.href='activity?jenis=";
		if (arr.jenis == "aktivitas") {
			link += "aktivitas";
		}
		else if (arr.jenis == "jobdes") {
			link += "jobdes";
		}
		link += "&kode="+ arr.kode;
		return link + "'";
	}
	//return true;
}

var jd_ktts = 0;
var jd_sat = '';
var jd_kua = 0;
var jd_biaya = 0;

var setuju_ktts = 0;
var setuju_kua = 0;
var setuju_biaya = 0;

var global_jum_jd_ak = 0;
var global_jum_jd_ak_setuju = 0;

//var global_show_jobdesku = false;
function showPenilaian(id_peg, kode_jd) {
	$('#modal_detail').modal('show');
	$('#isi_tabel_modal2').html('');
	$('.isi_modal').hide();
	$('#isi_modal2').show();
	/*alert('event/getjobdes_oop.php?show_penilaian_jd_peg=true&id_peg='+
		encodeURIComponent(id_peg) + '&kode_jd='+ encodeURIComponent(kode_jd));*/
	$('.def_f_setujui').html('-');

	jd_ktts = 0;
	jd_kua = 0;
	jd_biaya = 0;

	$('#id_peg_penilaian').val(id_peg);
	getDataByAjaxJson( 'event/getjobdes_oop.php?show_jobdes_peg_by_id=true&id_peg='+
	encodeURIComponent(id_peg) + '&kode_jd='+ encodeURIComponent(kode_jd), function(res) {
		if (res != "" && res != null) {
			$('#trgt_ktts').html( $.number(res[0].ktts, 0, ',', '.' ) + ' ' + res[0].sat );
			$('#trgt_kua').html( $.number(res[0].kua, 0, ',', '.' ) );
			$('#trgt_biaya').html("Rp " + $.number(res[0].biaya, 0, ',', '.' ) );
			$('#info_jobdes').html(res[0].job);

			jd_ktts = parseInt(res[0].ktts);
			jd_sat = res[0].sat;
			jd_kua = parseInt(res[0].kua);
			jd_biaya = parseInt(res[0].biaya);
		}
	});
	getDataByAjaxJson( 'event/getjobdes_oop.php?show_penilaian_jd_peg=true&id_peg='+
	encodeURIComponent(id_peg) + '&kode_jd='+ encodeURIComponent(kode_jd), function(res) {

		if (res != "" && res != null ) {

			var real_ktts = 0;
			var real_kua = 0;
			var real_biaya = 0;

			setuju_ktts = 0;
			setuju_kua = 0;
			setuju_biaya = 0;

			for (var i = 0; i < res.length; i++) {
				var tmp_tglw = tglWkt2Arr(res[i].tglw_create);
				var onclick = 'onclick="'+ linkAktivitas({kode: res[i].kode, jenis:'jobdes'}) +'"';
				var template = ''+
					'<tr title="Klik untuk melihat aktivitas">'+
					'<td style="cursor:pointer" '+ onclick +'>'+ tmp_tglw.tgl + ' ' + tmp_tglw.bulan + ' ' + tmp_tglw.thn +'</td>'+
		            '<td style="cursor:pointer" '+ onclick +'>'+ $.number(res[i].ktts, 0, ',', '.' ) +' '+ res[i].sat +'</td>'+
		            '<td style="cursor:pointer" '+ onclick +'>'+ res[i].kua +'</td>'+
		            '<td style="cursor:pointer" '+ onclick +'>Rp '+ $.number(res[i].biaya, 0, ',', '.' ) +'</td>'+
		            '<td><input type="hidden" value="'+ res[i].kode +'" name="arr_kode_ak[]" /> ';
		            if (id_peg != false) {
		            	template += btnDisetujui({kode: res[i].kode, isDisetujui:res[i].isDisetujui, ktts: parseInt(res[i].ktts), kua:parseInt(res[i].kua), biaya: parseInt(res[i].biaya)});
		            }
		        template += ''+
		            '</td>'+
		            '</tr>';
		        $('#isi_tabel_modal2').append(template);
		        //alert(real_ktts + " + " + res[i].ktts);
		        real_ktts += parseInt(res[i].ktts);
				real_kua += parseInt(res[i].kua);
				real_biaya += parseInt(res[i].biaya);

				if (res[i].isDisetujui == "1") {
					setuju_ktts+= parseInt(res[i].ktts);
					setuju_kua += parseInt(res[i].kua);
					setuju_biaya += parseInt(res[i].biaya);
					global_jum_jd_ak_setuju++;
				}
			}
			//alert(setuju_kua);
			$('#real_ktts').html($.number(real_ktts, 0, ',', '.' ));
			$('#real_kua').html($.number(real_kua, 0, ',', '.' ));
			$('#real_biaya').html('Rp ' + $.number(real_biaya, 0, ',', '.' ));

			var tmp_kua_hsl_bgi = 0;
			if (global_jum_jd_ak_setuju > 0) {
				tmp_kua_hsl_bgi = setuju_kua/global_jum_jd_ak_setuju;
			}

			//Jumlah job des disetujui
			global_jum_jd_ak = global_jum_jd_ak_setuju;
			$('#setuju_ktts').html(setuju_ktts);
			$('#setuju_kua').html( setuju_kua + "/" + global_jum_jd_ak_setuju +"= "+ $.number(tmp_kua_hsl_bgi, 2, ',', '.' ) );
			$('#setuju_biaya').html('Rp ' + $.number(setuju_biaya, 0, ',', '.' ));

			//Sisa job des => target - yang disetujui
			var sisa_ktts = jd_ktts - setuju_ktts;
			if (sisa_ktts < 0) { sisa_ktts = 0; }
			$('#sisa_ktts').html(sisa_ktts + " " + jd_sat);

			var sisa_kua = jd_kua - tmp_kua_hsl_bgi;
			if (sisa_kua < 0) { sisa_kua = 0; }
			$('#sisa_kua').html( $.number(sisa_kua, 2, ',', '.' ) );

			var sisa_biaya = jd_biaya - setuju_biaya;
			if (sisa_biaya < 0) { sisa_biaya = 0; }
			$('#sisa_biaya').html('Rp ' + $.number(sisa_biaya, 0, ',', '.' ));



			$('#isi_last_info').show();
		}
		else {
			$('#isi_tabel_modal2').html('<tr><td colspan="5">Belum ada KTJ dibuat</td></tr>');
			$('#isi_last_info').hide();
		}
	});

	if (id_peg == false) {
		$('#form_peniaian_jd .modal-footer').hide();
	}
	else {
		$('#form_peniaian_jd .modal-footer').show();
	}
}

function btnDisetujui(arr) {
	//Default disetujui
	var inp_tolak = "";
	var inp_setuju = "";
	//end

	//console.log(arr);

	if (arr.isDisetujui == 0 || arr.isDisetujui == null) {
		inp_tolak = "checked";
	}
	else if (arr.isDisetujui == 1) {
		inp_setuju = "checked";
	}



	return 	'<label class="f15"><input type=radio name="nilai'+ arr.kode +'" value="0" onclick="hitunganJD({ktts: '+ arr.ktts +', kua: '+ arr.kua +', biaya: '+ arr.biaya +', flag: \'min\'})" '+ inp_tolak +' /> Tolak</label> &nbsp;&nbsp;&nbsp;&nbsp;<label class="f15"><input type=radio name="nilai'+ arr.kode +'" value="1" onclick="hitunganJD({ktts: '+ arr.ktts +', kua: '+ arr.kua +', biaya: '+ arr.biaya +', flag: \'plus\'})" '+ inp_setuju +' /> Setujui<label>'+
	'<input type="hidden" value="nilai'+ arr.kode +'" name="arr_disetujui[]" />';
}

function hitunganJD(arr) {
	if (arr.flag == "min") {
		global_jum_jd_ak_setuju = global_jum_jd_ak_setuju - 1;
		setuju_ktts = setuju_ktts - arr.ktts;
		setuju_kua = setuju_kua - arr.kua;
		setuju_biaya = setuju_biaya - arr.biaya;
	} else {
		global_jum_jd_ak_setuju++;
		setuju_ktts += arr.ktts;
		setuju_kua = setuju_kua + arr.kua;
		setuju_biaya += arr.biaya;
	}

	var tmp_kua_hsl_bgi = 0;
	if (global_jum_jd_ak_setuju > 0) {
		tmp_kua_hsl_bgi = setuju_kua/global_jum_jd_ak_setuju;
	}

	//Jumlah job des disetujui
	global_jum_jd_ak = global_jum_jd_ak_setuju;
	$('#setuju_ktts').html(setuju_ktts);
	$('#setuju_kua').html( setuju_kua + "/" + global_jum_jd_ak_setuju +"= "+ $.number(tmp_kua_hsl_bgi, 2, ',', '.' ) );
	$('#setuju_biaya').html('Rp ' + $.number(setuju_biaya, 0, ',', '.' ));

	//Sisa job des => target - yang disetujui
	var sisa_ktts = jd_ktts - setuju_ktts;
	if (sisa_ktts < 0) { sisa_ktts = 0; }
	$('#sisa_ktts').html(sisa_ktts + " " + jd_sat);

	var sisa_kua = jd_kua - tmp_kua_hsl_bgi;
	if (sisa_kua < 0) { sisa_kua = 0; }
	$('#sisa_kua').html( $.number(sisa_kua, 2, ',', '.' ) );

	var sisa_biaya = jd_biaya - setuju_biaya;
	if (sisa_biaya < 0) { sisa_biaya = 0; }
	$('#sisa_biaya').html('Rp ' + $.number(sisa_biaya, 0, ',', '.' ));

	/*$('#sisa_ktts').html(jd_ktts - setuju_ktts);
	$('#sisa_kua').html( $.number(jd_kua - tmp_kua_hsl_bgi, 2, ',', '.' ) );
	$('#sisa_biaya').html('Rp ' + $.number(jd_biaya - setuju_biaya, 0, ',', '.' ));*/
}

function showFormById(id){
	$('.hide_jdp').hide();
	if (id == '1') {
		$('#kon_error_jobdes_text').show();
		$('#t1').addClass('active');
		$('#t2').removeClass('active');
	}
	else if (id == '2'){
		$('#kon_error_jobdes').show();
		$('#t2').addClass('active');
		$('#t1').removeClass('active');
	}
}