app.filter('startFrom', function() {
  return function(input, start) {
    if(input) {
      start = +start; //parse to int
      return input.slice(start);
    }
    return [];
  }
});
app.filter('unsafe', function($sce) {
  return function(val) {
  return $sce.trustAsHtml(val);
  };
});
app.filter('sumByKey', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
      sum += parseInt(data[i][key]);
    }

    return $.number(sum, 0, ',', '.' );
    //return sum;
  };
});

app.filter('sumByKeyFloat', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]);
    }

    return $.number(sum, 2, ',', '.' );
    //return sum;
  };
});

app.controller('hub_ctrl', function ($scope, $http, $timeout, $log) {
  $scope.loading = true;
  $scope.filter_jenis = "";
  $scope.$log = $log;
  //$scope.total_drd = 0;
  $scope.toggle_load_data = false;
  /*$scope.limit = 500;
  $scope.start_limit = 0;*/

  $scope.defaultLimit = function() {
    $scope.limit = 100;
    $scope.start_limit = 0;
  }


  $scope.setZero = function (){
    //$scope.lht_lg = false;

    $scope.list_tagih = [];
    $scope.filtered_tagih = 0;
    $scope.total_tagih = 0;

    $scope.list_terima = [];
    $scope.filtered_terima = 0;
    $scope.total_terima = 0;
  }
  $scope.setZero();

  $scope.mergeArray = function(arr_tujuan, arr) {
    if (arr.length > 0) {
      for (var i = 0; i < arr.length; i++) {
        arr_tujuan.push(arr[i]);
      }
    }
    return arr_tujuan;
  }

  $scope.getTagih = function(tambahan) {
    $('#btn_lihat').prop('disabled', true);
    $scope.toggle_load_data = true;
    $http.get('event/gethublang.php?'+ tambahan).success(function(res){
      $('#btn_lihat').prop('disabled', false);
      $log.log('event/gethublang.php?'+ tambahan);
      $scope.toggle_load_data = false;
      if (res != "") {
        $scope.loading = false;
        $scope.list_tagih = res.data;
        $scope.filtered_tagih = $scope.list_tagih.length;
        $scope.total_tagih = $scope.list_tagih.length;

        $scope.tagih_bln_byr = res.header.bln_byr;
        $scope.tagih_wil = res.header.wil;
        $scope.tagih_tgl_posting = res.header.tgl_posting;
        $scope.tagih_bln_ini = res.header.bln_ini;
      }
    });
  }

  $scope.getTerima = function(tambahan) {
    $('#btn_lihat').prop('disabled', true);
    $scope.toggle_load_data = true;
    $http.get('event/gethublang.php?'+ tambahan).success(function(res){
      $('#btn_lihat').prop('disabled', false);
      $log.log('event/gethublang.php?'+ tambahan);
      $scope.toggle_load_data = false;
      if (res != "") {
        $scope.loading = false;
        $scope.list_terima = res.data;
        $scope.filtered_terima = $scope.list_terima.length;
        $scope.total_terima = $scope.list_terima.length;

        $scope.terima_bln_byr = res.header.bln_byr;
        $scope.terima_wil = res.header.wil;
        $scope.terima_tgl_posting = res.header.tgl_posting;
        $scope.terima_bln_ini = res.header.bln_ini;
        $scope.terima_bln_lalu = res.header.bln_lalu;
      }
    });
  }

  $scope.submitFilter = function () {
    $scope.jenis = $('#filter_jenis').val();
    $scope.link_data = $('#form_filter').serialize();

    if ($scope.jenis == "efektif_tagih") {
      $scope.getTagih("efektivitas_penagihan=true&"+ $scope.link_data);
    }
    else if ($scope.jenis == "real_pen") {
      $scope.getTerima("realisasi_penerimaan=true&"+ $scope.link_data);
    }

    return false;
  }

  $scope.loadData = function(){
    $scope.limit = parseInt( $('#val_limit').val() );
    $scope.submitFilter();
  }

  $scope.predicate_lpp_rekap = 'baris_info';
  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };
  $scope.filter = function() {
    $timeout(function() {
      $scope.filteredItems = $scope.filtered_drd.length;
    }, 10);
  };
  $scope.sort_by = function(predicate) {
    $scope.predicate = predicate;
    $scope.reverse = !$scope.reverse;
  };

  $scope.showviewacc = function(tipe) {
    if (tipe == 'tabel') {
      $("#viewtabel").show();
      $("#viewlist").hide();
      $(".click_web").addClass("active");
      $(".click_mob").removeClass("active");
    } else if (tipe == 'list') {
      $("#viewtabel").hide();
      $("#viewlist").show();
      $(".click_mob").addClass("active");
      $(".click_web").removeClass("active");
    }
  };

  $scope.formatNomor = function (nomor) {
    return $scope.result = $.number(nomor, 0, ',', '.' );
  }

  $scope.formatNomor2 = function (nomor) {
    return $scope.result = $.number(nomor, 2, ',', '.' );
  }

  $scope.presentase = function (arr, arr_key1, arr_key2) {
    if (typeof (arr) === 'undefined' || typeof (arr_key1) === 'undefined' || typeof (arr_key2) === 'undefined') {
        return 0;
    }

    var jum1 = 0;
    var jum2 = 0;
    for (var i = 0; i < arr.length; i++) {
      jum1 += parseInt(arr[i][arr_key1]);
      jum2 += parseInt(arr[i][arr_key2]);
    }

    return $scope.formatNomor((jum1/jum2)*100);
  }




});