app.filter('startFrom', function() {
  return function(input, start) {
    if(input) {
      start = +start; //parse to int
      return input.slice(start);
    }
    return [];
  }
});
app.filter('unsafe', function($sce) {
  return function(val) {
  return $sce.trustAsHtml(val);
  };
});
app.filter('sumByKey', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
      sum += parseInt(data[i][key]);
    }

    return $.number(sum, 0, ',', '.' );
    //return sum;
  };
});

app.filter('sumByKeyFloat', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]);
    }

    return $.number(sum, 2, ',', '.' );
    //return sum;
  };
});
app.filter('sumByKeyFloat2Int', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }
    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]);
    }
    return $.number(sum, 0, ',', '.' );
  };
});
app.controller('hub_ctrl', function ($scope, $http, $timeout, $log) {
  $scope.loading = true;
  $scope.$log = $log;
  //$scope.total_drd = 0;
  $scope.toggle_load_data = false;
  /*$scope.limit = 500;
  $scope.start_limit = 0;*/

  $scope.defaultLimit = function() {
    $scope.limit = 100;
    $scope.start_limit = 0;
  }


  $scope.setZero = function (){
    //$scope.lht_lg = false;

    $scope.list_lpp_rekap = [];
    $scope.filtered_lpp_rekap = 0;
    $scope.total_lpp_rekap = 0;

    $scope.list_lpp_rekap_jenis = [];
    $scope.filtered_lpp_rekap_jenis = 0;
    $scope.total_lpp_rekap_jenis = 0;

    $scope.showAngsur = true;

    $scope.defaultLimit();
  }
  $scope.setZero();

  $scope.mergeArray = function(arr_tujuan, arr) {
    if (arr.length > 0) {
      for (var i = 0; i < arr.length; i++) {
        arr_tujuan.push(arr[i]);
      }
    }
    return arr_tujuan;
  }

  $scope.getRekapLPP = function(tambahan) {
    $('#btn_lihat .dis_filter').prop('disabled', true);
    $scope.toggle_load_data = true;
    $http.get('event/gethublang.php?'+ tambahan).success(function(res){
      $('#btn_lihat .dis_filter').prop('disabled', false);
      $scope.toggle_load_data = false;
      $log.log('event/gethublang.php?'+ tambahan);
      $log.log(res);
      if (res != "") {
        $scope.loading_rekap = false;
        $scope.list_lpp_rekap = res;
        $scope.filtered_lpp_rekap = $scope.list_lpp_rekap.length;
        $scope.total_lpp_rekap = $scope.list_lpp_rekap.length;
      }
    });
  }

  $scope.getRekapLPPJenis = function(tambahan) {
    $('#btn_lihat').prop('disabled', true);
    $scope.toggle_load_data = true;
    $http.get('event/gethublang.php?'+ tambahan).success(function(res){
      $('#btn_lihat').prop('disabled', false);
      $scope.toggle_load_data = false;
      $log.log('event/gethublang.php?'+ tambahan);
      $log.log(res);
      if (res != "") {
        $scope.loading_rekap = false;
        $scope.list_lpp_rekap_jenis = res;
        $scope.filtered_lpp_rekap_jenis = $scope.list_lpp_rekap_jenis.length;
        $scope.total_lpp_rekap_jenis = $scope.list_lpp_rekap_jenis.length;
      }
    });
  }

  $scope.submitFilter = function () {
    $scope.jenis = $('#filter_jenis').val();
    $scope.link_data = $('#form_filter').serialize();

    if ($scope.jenis == "lpp_rekap_gol") {
      $scope.tipe = "Golongan";
      $scope.getRekapLPP("lpp_rekap=true&"+ $scope.link_data + "&jenis=rekap_lpp&group_by=golongan");
    }
    else if ($scope.jenis == "lpp_rekap_rayon") {
      $scope.tipe = "Rayon";
      $scope.getRekapLPP("lpp_rekap=true&"+ $scope.link_data + "&jenis=rekap_lpp&group_by=rayon");
    }
    else if ($scope.jenis == "lpp_rekap_wil") {
      $scope.tipe = "Wilayah";
      $scope.getRekapLPP("lpp_rekap=true&"+ $scope.link_data + "&jenis=rekap_lpp&group_by=wilayah");
    }
    else if ($scope.jenis == "lpp_rekap_loket") {
      $scope.tipe = "Loket";
      $scope.getRekapLPP("lpp_rekap=true&"+ $scope.link_data + "&jenis=rekap_lpp&group_by=loket");
    }
    else if ($scope.jenis == "lpp_rekap_kasir") {
      $scope.tipe = "Kasir";
      $scope.showAngsur = false;
      $scope.getRekapLPP("lpp_rekap=true&"+ $scope.link_data + "&jenis=rekap_lpp&group_by=kasir");
    }
    else if ($scope.jenis == "lpp_rekap_periode_drd") {
      $scope.tipe = "Periode";
      $scope.showAngsur = false;
      $scope.getRekapLPP("lpp_rekap=true&"+ $scope.link_data + "&jenis=rekap_lpp&group_by=periode");
    }
    else if ($scope.jenis == "lpp_rekap_non_air") {
      $scope.getRekapLPPJenis("lpp_rekap_jenis=true&"+ $scope.link_data);
    }

    return false;
  }

  $scope.loadData = function(){
    $scope.limit = parseInt( $('#val_limit').val() );
    $scope.submitFilter();
  }

  $scope.predicate_lpp_rekap = 'baris_info';
  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };
  $scope.filter = function() {
    $timeout(function() {
      $scope.filteredItems = $scope.filtered_drd.length;
    }, 10);
  };
  $scope.sort_by = function(predicate) {
    $scope.predicate = predicate;
    $scope.reverse = !$scope.reverse;
  };

  $scope.showviewacc = function(tipe) {
    if (tipe == 'tabel') {
      $("#viewtabel").show();
      $("#viewlist").hide();
      $(".click_web").addClass("active");
      $(".click_mob").removeClass("active");
    } else if (tipe == 'list') {
      $("#viewtabel").hide();
      $("#viewlist").show();
      $(".click_mob").addClass("active");
      $(".click_web").removeClass("active");
    }
  };

  $scope.formatNomor = function (nomor) {
    return $scope.result = $.number(nomor, 0, ',', '.' );
  }

  $scope.formatNomor2 = function (nomor) {
    return $scope.result = $.number(nomor, 2, ',', '.' );
  }

  $scope.filter_jenis = "";

  $scope.viewFilter = function(){
    /*$('.kon_filter').hide();
    var val = $('#filter_jenis').val();
    if (val == "drd_rekap_gol") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
    else if (val == "drd_rekap_rayon") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
    else if (val == "drd_rekap_wil") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
    else if (val == "drd_banding") {
      $('#kon_periode,#kon_rayon,#kon_wilayah').show();
    }*/
  }


});

$(document).ready(function(){
  $('#filter_tgl1,#filter_tgl2').mask('00-00-0000');
});