app.filter('startFrom', function() {
	return function(input, start) {
		if(input) {
			start = +start; //parse to int
			return input.slice(start);
		}
		return [];
	}
});

app.filter('unsafe', function($sce) {
	return function(val) {
		return $sce.trustAsHtml(val);
	};
});

app.controller('customersCrtl', function ($scope, $http, $timeout) {
	$scope.loading = true;
	$http.get('event/getpegawai-daftar.php?peg=true').success(function(data){
		$scope.loading = false;
		$scope.list = data;
		$scope.currentPage = 1; //current page
		$scope.entryLimit = 12; //max no of items to display in a page
		$scope.filteredItems = $scope.list.length; //Initially for no filter
		$scope.totalItems = $scope.list.length;
	});

	$scope.predicate = 'nama';

	$scope.setPage = function(pageNo) {
		$scope.currentPage = pageNo;
	};

	$scope.filter = function() {
		$timeout(function() {
			$scope.filteredItems = $scope.filtered.length;
		}, 10);
	};

	$scope.sort_by = function(predicate) {
		$scope.predicate = predicate;
		$scope.reverse = !$scope.reverse;
	};

	$scope.linkFotoPeg = function(val) {
		if (val == "default.png") {
			return "img/person/default.png";
		}
		return global_folder + val;
	};

	$scope.showCardReveal = function(ipeg) {
		$('#det_card'+ ipeg).slideToggle('slow');
	};

	$scope.addPegawai = function(){
		window.location.href = "./employee-new";
	}
});