app.filter('startFrom', function() {
  return function(input, start) {
    if(input) {
      start = +start; //parse to int
      return input.slice(start);
    }
    return [];
  }
});
app.filter('unsafe', function($sce) {
  return function(val) {
  return $sce.trustAsHtml(val);
  };
});
app.filter('sumByKey', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    //var x = "";
    for (var i = data.length - 1; i >= 0; i--) {
      sum += parseInt(data[i][key]);
      //x += data[i][key] + ", ";
    }
    //console.log(x);

    return $.number(sum, 0, ',', '.' );
    //return sum;
  };
});

app.filter('sumByKeyFloat', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }

    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]);
    }

    return $.number(sum, 2, ',', '.' );
    //return sum;
  };
});
app.filter('sumByKeyFloat2Int', function() {
  return function (data, key) {
    if (typeof (data) === 'undefined' || typeof (key) === 'undefined') {
        return 0;
    }
    var sum = 0;
    for (var i = data.length - 1; i >= 0; i--) {
        sum += parseFloat(data[i][key]);
    }
    return $.number(sum, 0, ',', '.' );
  };
});
app.controller('hub_ctrl', function ($scope, $http, $timeout, $log) {
  $scope.loading = true;
  $scope.$log = $log;
  //$scope.total_drd = 0;
  $scope.toggle_load_data = false;
  /*$scope.limit = 500;
  $scope.start_limit = 0;*/

  $scope.defaultLimit = function() {
    $scope.limit = 100;
    $scope.start_limit = 0;
  }


  $scope.setZero = function (){
    $scope.lht_lg = false;

    $scope.list_saldo = [];
    $scope.filtered_saldo = 0;
    $scope.total_saldo = 0;

    $scope.list_saldo_rekap = [];
    $scope.filtered_saldo_rekap = 0;
    $scope.total_saldo_rekap = 0;

    $scope.defaultLimit();
  }
  $scope.setZero();

  $scope.mergeArray = function(arr_tujuan, arr) {
    if (arr.length > 0) {
      for (var i = 0; i < arr.length; i++) {
        arr_tujuan.push(arr[i]);
      }
    }
    return arr_tujuan;
  }

  $scope.getSaldo = function(tambahan) {
    $('#btn_lihat').prop('disabled', true);
    $scope.toggle_load_data = true;
    $http.get('event/gethublang.php?'+ tambahan + "&start_limit="+ $scope.start_limit + "&limit="+ $scope.limit).success(function(res){
      $('#btn_lihat').prop('disabled', false);
      $scope.toggle_load_data = false;
      if (res != "") {
        $scope.lht_lg = true;

        if ($scope.total_saldo > 0) {
          $scope.list_saldo = $scope.mergeArray($scope.list_saldo, res)
          $scope.filtered_saldo += res.length;
          $scope.total_saldo += res.length;
        }
        else {
          $scope.loading = false;
          $scope.list_saldo = res;
          $scope.filtered_saldo = $scope.list_saldo.length;
          $scope.total_saldo = $scope.list_saldo.length;
        }
        $scope.start_limit = $scope.total_saldo;
      }
    });
  }

  $scope.getRekapSaldo = function(tambahan) {
    $('#btn_lihat').prop('disabled', true);
    $scope.toggle_load_data = true;
    $http.get('event/gethublang.php?'+ tambahan).success(function(res){
      //$('#btn_lihat').prop('disabled', false);
      $scope.toggle_load_data = false;
      $log.log('event/gethublang.php?'+ tambahan);
      $log.log(res);
      if (res != "") {
        $scope.loading_rekap = false;
        $scope.list_saldo_rekap = res;
        $scope.filtered_saldo_rekap = $scope.list_saldo_rekap.length;
        $scope.total_saldo_rekap = $scope.list_saldo_rekap.length;
      }
    });
  }

  $scope.submitFilter = function () {
    $scope.jenis = $('#filter_jenis').val();
    $scope.link_data = $('#form_filter').serialize();

    if ($scope.jenis == "saldo") {
      $scope.getSaldo("saldo=true&"+ $scope.link_data);
    }
    else if ($scope.jenis == "saldo_rekap_golongan") {
      $scope.tipe = "Golongan";
      $scope.getRekapSaldo("saldo_rekap=true&"+ $scope.link_data + "&jenis=rekap_saldo&group_by=golongan");
    }
    else if ($scope.jenis == "saldo_rekap_rayon") {
      $scope.tipe = "Rayon";
      $scope.getRekapSaldo("saldo_rekap=true&"+ $scope.link_data + "&jenis=rekap_saldo&group_by=rayon");
    }
    else if ($scope.jenis == "saldo_rekap_wilayah") {
      $scope.tipe = "Wilayah";
      $scope.getRekapSaldo("saldo_rekap=true&"+ $scope.link_data + "&jenis=rekap_saldo&group_by=wilayah");
    }
    else if ($scope.jenis == "saldo_rekap_periode") {
      $scope.tipe = "Periode";
      $scope.getRekapSaldo("saldo_rekap=true&"+ $scope.link_data + "&jenis=rekap_periode&group_by=periode");
    }

    return false;
  }

  $scope.loadData = function(){
    $scope.limit = parseInt( $('#val_limit').val() );
    $scope.submitFilter();
  }

  $scope.predicate_saldo = 'no_samb';
  $scope.predicate_rekap = 'periode';

  $scope.setPage = function(pageNo) {
    $scope.currentPage = pageNo;
  };
  $scope.filter = function() {
    $timeout(function() {
      $scope.filteredItems = $scope.filtered_saldo.length;
    }, 10);
  };
  $scope.sort_by = function(predicate) {
    $scope.predicate = predicate;
    $scope.reverse = !$scope.reverse;
  };

  $scope.showviewacc = function(tipe) {
    if (tipe == 'tabel') {
      $("#viewtabel").show();
      $("#viewlist").hide();
      $(".click_web").addClass("active");
      $(".click_mob").removeClass("active");
    } else if (tipe == 'list') {
      $("#viewtabel").hide();
      $("#viewlist").show();
      $(".click_mob").addClass("active");
      $(".click_web").removeClass("active");
    }
  };

  $scope.formatNomor = function (nomor) {
    return $scope.result = $.number(nomor, 0, ',', '.' );
  }

  $scope.formatNomor2 = function (nomor) {
    return $scope.result = $.number(nomor, 2, ',', '.' );
  }

  $scope.filter_jenis = "";

  $scope.viewFilter = function(){
    $('.kon_filter').hide();
    var val = $('#filter_jenis').val();
    $log.log(val);
    if (val == "saldo") {
      $('.kon_filter').show();
    }
    else if (val == "saldo_rekap_golongan") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
    else if (val == "saldo_rekap_rayon") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
    else if (val == "saldo_rekap_wilayah") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
    else if (val == "saldo_rekap_periode") {
      $('#kon_periode,#kon_rayon,#kon_wilayah,#kon_golongan').show();
    }
  }


});