<?php
  session_start();
  include "function/connect.php";
  include "class/class_perusahaan.php";
  include "data/config_app.php";

  if (isset($_GET['logout'])) {
    //reset hash session login
    if (!empty($_SESSION['id_pegawai'])) {

      include "class/class_pegawai.php";
      $global_peg = new PegawaiClass();
      $global_peg->resetHashSession($_SESSION['id_pegawai']);
    }
    //end reset hash session login

    session_destroy();
    require_once 'auth/data.php';
    unset($_COOKIE[$cookie_name]);
    setcookie($cookie_name, null, -1, '/');
  }
  else {
    require_once 'auth/config.php';
    if (!empty($_SESSION['id_pegawai'])) {
      header("Location: dashboard");
      //header("Location: tes/cek_cookie.php");
      exit;
    }
  }

  $link = "";
  if (!empty($_GET['link'])) {
    $link = $_GET['link'];
  }

  $cls_com = new PerusahaanClass();
  $perusahaan = $cls_com->selectPerusahaanMAP();

 ?>
<!DOCTYPE html>
<html lang="en" class="">
<head>
  <meta charset="utf-8" />
  <title>Login <?=$global_app['app_name']; ?></title>
  <meta name="description" content="manajemen aktivitas pegawai, manajemen pegawai, bimasakti manajemen pegawai, e-performance" />
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
  <link rel="stylesheet" href="./css/animate.css" type="text/css" />
  <link rel="stylesheet" href="./css/font-awesome.min.css" type="text/css" />
  <link rel="stylesheet" href="./css/simple-line-icons.css" type="text/css" />
  <link rel="stylesheet" href="./css/bootstrap.css" type="text/css" />

  <link rel="stylesheet" href="./css/font.css" type="text/css" />
  <link rel="stylesheet" href="./css/app.css" type="text/css" />
  <link rel="shortcut icon" href="./img/logo/<?=$global_app['app_logo_small']; ?>">

</head>
<body>
<div class="app app-header-fixed ">

  <div class="container w-xxl w-auto-xs">
    <div class="wrapper block m-t text-center" style="margin-bottom: 20px;">
      <img class="img-responsive" src="img/logo/<?=$perusahaan['foto_logo']; ?>" style="width: 50%; display: block; margin-left: auto; margin-right: auto;">
      <h3 class="thin"><?=strtoupper($perusahaan['nama_per']); ?></h3>
    </div>
    <div class="m-b-lg">
      <form name="formlogin" id="formlogin" class="form-validation" action="" method="post">
        <div class="list-group list-group-sm" style="margin-bottom: 0px;">
          <div class="list-group-item" id="input1">
            <input type="text" id="nmuser" name="nmuser" placeholder="Username" class="form-control no-border" onChange="javascript:this.value=this.value.toLowerCase();" required>
          </div>
          <div class="list-group-item" id="input2">
             <input type="password" id="nmpass" name="nmpass" placeholder="Password" class="form-control no-border" ng-model="user.password">
          </div>
        </div>
        <input name="login" id="login" value="login" type="hidden" />
        <div class="checkbox">
          <label class="i-checks">
            <input type="checkbox" name="remember" value="1"><i></i> Tetap masuk
          </label>
        </div>
        <button type="submit" class="btn btn-lg btn-primary btn-block" ng-click="login()" ng-disabled='form.$invalid' id="btn_submit">Masuk <i class="fa fa-refresh fa-spin" style="display: none;" id="imgloading"></i></button>
      </form>
    </div>
      <p class="text-center">
        <span class="text-muted"><?=$global_app['app_full_name'] . " " . $global_app['app_version']; ?><br />
         &copy; <?=$global_app['cr_year']; ?></span>
      </p>
  </div>

</div>

<script src="./js/jquery.min.js"></script>
<script src="./js/bootstrap.js"></script>
<script src="./js/ui-load.js"></script>
<script src="./js/ui-jp.config.js"></script>
<script src="./js/ui-jp.js"></script>
<script src="./js/ui-nav.js"></script>
<script src="./js/ui-toggle.js"></script>
<!-- <script src="./js/ui-client.js"></script> -->

<script type="text/javascript">
var link = "<?=$link; ?>";
$(document).ready(function(e) {
  $("#formlogin").submit(function(e) {
    var error = 0;
    if($('#nmuser').val() == "") { $('#input1').addClass('has-error'); $('#nmuser').focus(); error++; } else { $('#input1').removeClass('has-error'); }
    if($('#nmpass').val() == "") { $('#input2').addClass('has-error'); $('#nmpass').focus(); error++; } else { $('#input2').removeClass('has-error'); }

    if(error > 0){
      return false;
    } else {
        e.preventDefault();
        url = "./manipulation/man-login.php";

        var post_data = $(this).serialize();
        var form_action = $(this).attr("action");
        var form_method = $(this).attr("method");
        $.ajax( {
          type :form_method,
          url :url,
          cache :false,
          data :post_data,
          beforeSend: function(data) {
            $('#imgloading').show();
            $('#btn_submit').prop('disabled', true);
          },
          success : function(data) {
            if (data == "oke") {
              if (link != "") {
                document.location.href = link;
              }
              else {
                document.location.href = "./activity";
              }
            } else if (data == "erroruser") {
              alert("Maaf, username atau password salah.");
              $('#nmuser').val('');
              $('#nmpass').val('');
              $('#btn_submit').prop('disabled', false);
              $('#imgloading').hide();
            } else {
              alert("Terjadi Kesalahan");
              alert(data);
              location.reload(true);
            }
          },
          error : function(data) {
            alert("Maaf, proses login error.");
            window.location = "./signin";
          }
        });
      }
  });
});
</script>

</body>
</html>
