<?php
  session_start();
  require_once 'auth/config.php';

  if (!empty($_SESSION['id_pegawai'])) {

    include "./function/template.php";
    include "./class/class_hublang.php";

    $hublang = new HublangClass();
    $hublang->id_user = $_SESSION['id_pegawai'];

    headbd();
    head();

    aside('hub-rek', 'lpp');
?>

<script src="./plugin/sweetalert/dist/sweetalert.min.js"></script>
<link rel="stylesheet" type="text/css" href="./plugin/sweetalert/dist/sweetalert.css">
<link rel="stylesheet" type="text/css" href="./css/global.css">

<style type="text/css">
  /*tbody {
    display:block;
    height:500px;
    overflow:auto;
  }
  thead, tfoot, tbody tr {
      display:table;
      width:100%;
      table-layout:fixed;
  }
  thead {
      width: calc( 100% - 1em )
  }
  tfoot {
      width: calc( 100% - 1em )
  }*/
</style>

<div ng-controller="hub_ctrl">
  <div class="bg-light lter b-b wrapper-sm">
    <h1 class="m-n font-thin h3 text-black">BS PAY</h1>
    <small class="text-muted">LPP (Laporan Penerimaan Penagihan)</small>
  </div>
  <div class="wrapper-md kon-post-act">
     <div id="x">
        <div class="panel panel-default" style="min-height: 500px;">
          <div id="panellist">

              <div class="row wrapper">
                <div class="col-sm-4 col-lg-7 kon-post-act margin-bottom-10">
                    <input type="text" placeholder="Filter" ng-model="search.$" ng-change="filter()" placeholder="Filter" class="form-control" />
                </div>
              </div>

              <div ng-if="toggle_load_data == true" class="loading" align="center">
                 <img src="./img/loading.gif" />
                 <div class="clearfix">&nbsp;</div>
              </div>

              <div class="table-responsive" ng-show="total_lpp_rekap > 0">

                <div id="tabel2" style="overflow:auto; height: 500px;">
                <table class="table table-bordered table-striped b-t b-light table-hover table-fixed">
                  <thead>
                    <tr>
                      <th class="text-center"><a>No</a></th>
                      <th><a ng-click="sort_by('baris_info');">{{ tipe }}</a></th>
                      <th class="text-right"><a ng-click="sort_by('lmbr');">Lembar</a></th>
                      <!-- <th class="text-right"><a ng-click="sort_by('pk');">Pakai</a></th> -->
                      <th class="text-right"><a ng-click="sort_by('bya_pk');">Harga Air</a></th>
                      <th class="text-right"><a ng-click="sort_by('adm');">By. Adm</a></th>
                      <th class="text-right"><a ng-click="sort_by('pelihara');">By. Pem</a></th>
                      <th class="text-right"><a ng-click="sort_by('ret');">By. Ret</a></th>
                      <th class="text-right" ng-if="showAngsur == true"><a ng-click="sort_by('angsur');">Angsuran</a></th>
                      <th class="text-right"><a ng-click="sort_by('denda');">Denda</a></th>
                      <th class="text-right"><a ng-click="sort_by('total');">Total</a></th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr ng-repeat="arr in filtered_lpp_rekap = (list_lpp_rekap | filter:search | orderBy : predicate_lpp_rekap :reverse) ">
                      <td class="text-center">{{$index+1}}</td>
                      <td>{{arr.baris_info}}</td>
                      <td class="text-right">{{formatNomor(arr.lmbr)}}</td>
                      <!-- <td class="text-right">{{formatNomor(arr.pk)}} m<sup>3</sup></td> -->
                      <td class="text-right">{{formatNomor2(arr.bya_pk)}}</td>
                      <td class="text-right">{{formatNomor(arr.adm)}}</td>
                      <td class="text-right">{{formatNomor(arr.pelihara)}}</td>
                      <td class="text-right">{{formatNomor(arr.ret)}}</td>
                      <td class="text-right" ng-if="showAngsur == true">{{formatNomor(arr.angsur)}}</td>
                      <td class="text-right">{{formatNomor(arr.denda)}}</td>
                      <td class="text-right">{{formatNomor2(arr.total)}}</td>
                    </tr>
                  </tbody>
                  <tfoot>
                    <tr>
                      <td colspan="2" class="text-center"><b>TOTAL</b></td>
                      <td class="text-right">{{ list_lpp_rekap | sumByKey : 'lmbr' }}</td>
                      <!-- <td class="text-right">{{ list_lpp_rekap | sumByKey : 'pk' }} m<sup>3</sup></td> -->
                      <td class="text-right">{{ list_lpp_rekap | sumByKeyFloat : 'bya_pk' }}</td>
                      <td class="text-right">{{ list_lpp_rekap | sumByKey : 'adm' }}</td>
                      <td class="text-right">{{ list_lpp_rekap | sumByKey : 'pelihara' }}</td>
                      <td class="text-right">{{ list_lpp_rekap | sumByKey : 'ret' }}</td>
                      <td class="text-right" ng-if="showAngsur == true">{{ list_lpp_rekap | sumByKey : 'angsur' }}</td>
                      <td class="text-right">{{ list_lpp_rekap | sumByKey : 'denda' }}</td>
                      <td class="text-right">{{ list_lpp_rekap | sumByKeyFloat : 'total' }}</td>
                    </tr>
                  </tfoot>
                </table>
                </div>
              </div>

              <div class="table-responsive" ng-show="total_lpp_rekap_jenis > 0">

                <div id="tabel3" style="overflow:auto; height: 500px;">
                <table class="table table-bordered table-striped b-t b-light table-hover table-fixed">
                  <thead>
                    <tr>
                      <th class="text-center" style="width: 30px;"><a>No</a></th>
                      <th style="width: 100px;"><a ng-click="sort_by('jns');">Jenis</a></th>
                      <th style="width: 30px;"><a ng-click="sort_by('lmbr');" class="text-right">Lembar</a></th>
                      <th class="text-right" style="width: 80px;"><a ng-click="sort_by('total');">Total</a></th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr ng-repeat="arr in filtered_lpp_rekap_jenis = (list_lpp_rekap_jenis | filter:search) ">
                      <td class="text-center">{{$index+1}}</td>
                      <td>{{arr.jns}}</td>
                      <td class="text-right">{{arr.lmbr}}</td>
                      <td class="text-right">{{formatNomor2(arr.total)}}</td>
                    </tr>
                  </tbody>
                  <tfoot>
                    <tr>
                      <td colspan="2" class="text-center"><b>Total</b></td>
                      <td class="text-right">{{ list_lpp_rekap_jenis | sumByKey : 'lmbr' }}</td>
                      <td class="text-right">{{ list_lpp_rekap_jenis | sumByKeyFloat : 'total' }}</td>
                    </tr>
                  </tfoot>
                </table>
                </div>
              </div>


            </div>
        </div>
      </div>

  </div>

  <!-- <div class="fab bg-primary" id="masterfab" ng-click="showformacc()"><span>+</span></div> -->

  <script type="text/javascript">
    var saklar=1;
    $(document).ready(function(e) {
      $('#menu_bspay,#menu_lpp').addClass('active');
      ceklebarlayar();
      $("#panel-kanan2").click(function(){
          if(saklar==0){
          //if ($(".active")[0]){
              $("#panel-kanan2").removeClass("active");
              $("#panel-kanan1").removeClass("active");
              //alert("non aktif");
              saklar=1;
          } else {
              $("#panel-kanan2").addClass("active");
              $("#panel-kanan1").addClass("active");
              //alert("aktif");
              saklar=0;
          }
      });
      $('.saklar').attr('disabled', true).trigger("chosen:updated");
    });

    function aktifNonaktif(id, tipe){
      if( $('#'+id).prop('disabled') ) {
          $('#'+id).attr('disabled', false);
      }
      else {
          $('#'+id).val('');
          $('#'+id).attr('disabled', true);

          $("#"+id).change();
      }
      if (tipe == 'combo') {
          $('#'+id).trigger("chosen:updated");
      }
    }

    $( window ).resize(function() {
      ceklebarlayar();
    });

    function ceklebarlayar() {
      var lebar = $('.app').innerWidth();
      if (lebar <= 600){
        $(".click_mob").click();
      } else {
        $(".click_web").click();
      }
    }
  </script>

  <script type="text/javascript" src="jsku/jquery.number.min.js"></script>
  <script type="text/javascript" src="jsku/lpp.js"></script>
  <script src="./jsku/jquery.mask.min.js" type="text/javascript"></script>

  <!-- panel Kanan -->
  <div id="panel-kanan1" class="settings panel panel-default ng-scope" style="">
    <button target=".settings" id="panel-kanan2" ui-toggle-class="active" class="btn btn-default no-shadow pos-abt ng-scope">
      <i class="fa fa-search"></i>
    </button>
    <div class="panel-heading ng-scope">
      Pencarian
    </div>
    <div class="panel-body ng-scope">
    <form method="get" ng-submit="submitFilter()" id="form_filter" name="form_filter">
      <div class="m-b-sm">
        <select class="form-control" name="jenis" id="filter_jenis" ng-model="filter_jenis" ng-change="viewFilter()">
          <option value="">Pilih</option>
          <option value="lpp_rekap_gol">Rekap LPP Air (Golongan Tarif</option>
          <option value="lpp_rekap_rayon">Rekap LPP Air (Rayon)</option>
          <option value="lpp_rekap_wil">Rekap LPP Air (Wilayah Pelanggan)</option>
          <option value="lpp_rekap_loket">Rekap LPP Air (Loket Pembayaran)</option>
          <option value="lpp_rekap_kasir">Rekap LPP Air (Kasir)</option>
          <option value="lpp_rekap_periode_drd">Rekap LPP Air (Periode DRD)</option>
          <option value="lpp_rekap_non_air">Rekap LPP Non Air</option>
        </select>
      </div>

      <div class="m-b-sm kon_filter" id="kon_tgl">
        <div class="form-group">
          <label>Dari Tanggal</label>
          <input type="text" name="tgl1" id="filter_tgl1" class="form-control" value="01-<?=date('m-Y'); ?>" />
        </div>

        <div class="form-group">
          <label>Sampai Tanggal</label>
          <input type="text" name="tgl2" id="filter_tgl2" class="form-control" value="<?=date('d-m-Y'); ?>" />
        </div>
      </div>

      <div class="m-b-sm kon_filter" id="kon_loket">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_loket', 'combo');"><i></i> Loket
        </label>
        <select ui-jq="chosen" class="form-control saklar" id="filter_loket" name="loket">
          <?php
              $arr = $hublang->selectLoket();
              for($i=0; $i < count($arr); $i++) {
                echo '<option value="'. $arr[$i]['kode'] .'" >'. $arr[$i]['loket'] .'</option>';
              }
          ?>
        </select>
      </div>

      <div class="m-b-sm kon_filter" id="kon_kasir">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_kasir', 'combo');"><i></i> Kasir
        </label>
        <select ui-jq="chosen" class="form-control saklar" id="filter_kasir" name="kasir">
          <?php
              $arr = $hublang->selectKasir();
              for($i=0; $i < count($arr); $i++) {
                echo '<option value="'. $arr[$i]['nama'] .'" >'. $arr[$i]['nama'] .'</option>';
              }
          ?>
        </select>
      </div>

      <div class="m-b-sm kon_filter" id="kon_rayon">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_rayon', 'combo');"><i></i> Rayon
        </label>
        <select ui-jq="chosen" class="form-control saklar" id="filter_rayon" name="rayon">
          <?php
              $arr = $hublang->selectRayon();
              for($i=0; $i < count($arr); $i++) {
                echo '<option value="'. $arr[$i]['kode'] .'" >'. $arr[$i]['rayon'] .'</option>';
              }
          ?>
        </select>
      </div>

      <div class="m-b-sm kon_filter" id="kon_wilayah">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_wil', 'combo');"><i></i> Wilayah
        </label>
        <select ui-jq="chosen" class="form-control saklar" id="filter_wil" name="wilayah">
          <?php
              $arr = $hublang->selectWilayah();
              for($i=0; $i < count($arr); $i++) {
                echo '<option value="'. $arr[$i]['kode'] .'" >'. $arr[$i]['wil'] .'</option>';
              }
          ?>
        </select>
      </div>

      <div class="m-b-sm kon_filter" id="kon_golongan">
        <label class="i-checks">
          <input type="checkbox" onclick="aktifNonaktif('filter_gol', 'combo');"><i></i> Golongan
        </label>
        <select ui-jq="chosen" class="form-control saklar" id="filter_gol" name="golongan">
          <?php
              $arr = $hublang->selectGolongan();
              for($i=0; $i < count($arr); $i++) {
                echo '<option value="'. $arr[$i]['kode'] .'" >'. $arr[$i]['gol'] .'</option>';
              }
          ?>
        </select>
      </div>

      <div class="form-group">
        <button type="submit" class="btn btn-sm btn-primary dis_filter" ng-click="setZero()" ng-disabled="filter_jenis == '' ">Cari</button>
      </div>
    </form>


    </div>
  </div>

</div>
<?php
    //
    footer();
    footbd();
    //
  }
  else {
    echo '
    <script type="text/javascript">
      document.location.href = "./signin";
    </script>
    ';
  }
?>