<?php

include_once './db_connect.php';
include_once './FCM.php';
include_once './Firebase.php';

error_reporting(-1);
ini_set('display_errors', 'On');

class FCMSend {

    private $title;
    private $message;
    private $push_type;
    private $image;
    private $avatar;
	private $include_image;
    private $idpegawai;

    private $fcm;
    public $function;
    private $firebase;

    //private $payload;

    public function __construct(){
        $this->fcm = new FCM();
        //$this->function = new DB_CONNECT();
        $this->firebase = new Firebase();
    }
    
    public function sendMessage($title, $message, $image, $push_type, $include_image, $idpegawai) {
        $this->title = $title;
		$this->message = $message;
		$this->image = $image;
        //$this->avatar = $avatar;
		$this->push_type = $push_type;
		$this->include_image = $include_image;
        $this->idpegawai = $idpegawai;
        $this->setContent();
    }
    
    private function setContent() {
        //Set Body Content Message
        $this->fcm->setTitle($this->title);
        $this->fcm->setMessage($this->message);
        if ($this->include_image) {
            $this->fcm->setImage($this->image);
        } else {
            $this->fcm->setImage('');
        }
        //$this->fcm->setAvatar($this->avatar);
        $this->fcm->setIsBackground(FALSE);
        $this->sendData();
    }
    
    private function sendData() {
        $response = '';
        $regID = $this->function->getRegIdFromIdPegawai($this->idpegawai);
        if ($regID != '') {
            if ($this->push_type == 'topic') {
                $json = $this->fcm->getPush();
                $response = $this->firebase->sendToTopic('global', $json);
            } else if ($this->push_type == 'individual') {
                $json = $this->fcm->getPush();
                $response = $this->firebase->send($regID, $json);
            }
            if ($response) {
                echo "Sukses";
            } else {
                echo "Gagal";
            }
        }
        else {
            echo "Tidak ada user";
        }
    }
}

?>