<?php

    class FCMSend {

        private $title;
        private $message;
        private $idpegawai;
        private $regId;
        private $avatar;
        private $image;
        private $action;
        private $kodetabel;
        public $function;

        //
        public function sendMessage($title, $message, $idpegawai, $avatar, $image, $kodetabel, $action)
        {
            $this->title = $title;
            $this->message = $message;
            $this->avatar = $avatar;
            $this->image = $image;
            $this->action = $action;
            $this->kodetabel = $kodetabel;
            $this->regId = $this->function->getRegIdFromIdPegawai($idpegawai);
            if ($this->regId != '') {
                $this->sendPushNotification();
            } else {
                return "Tidak ada user";
            }
        }

        // setting header notifikasi
        private function getHeaders ()
        {
            require_once __DIR__ . '/db_config.php';
            $headers = array(
                'Authorization:key = '. FIREBASE_API_KEY,
                'Content-Type: application/json'
            );
            return $headers;
        }

        // setting pesan notifikasi
        private function getMsg ()
        {
            $msg = array
            (
                'body' => $this->message,
                'title' => $this->title,
                'icon' => $this->avatar,
                'sound' => "default",
                'click_action' => $this->action
            );
            return $msg;
        }

        //setting data notifikasi
        private function getData()
        {
            $data = array
            (
                'click_action' => $this->action,
                'sound' => "default",
                'image' => $this->image,
                'kodetabel' => $this->kodetabel,
                'timestamp' => date('Y-m-d G:i:s')
            );
            return $data;
        }

        // setting field notfikasi
        private function getFields ()
        {
            $fields = array
            (
                'registration_ids' => $this->regId,
                'notification' => $this->getMsg(),
                'data' => $this->getData()
            );
            return $fields;
        }

        // kirim pesan notifikasi
        private function sendPushNotification ()
        {
            $url = 'https://fcm.googleapis.com/fcm/send';
            //
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $this->getHeaders());
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($this->getFields()));
            $result = curl_exec($ch);
            if ($result === FALSE) {
                die('Curl failed: ' . curl_error($ch));
            }
            curl_close($ch);
            //return $result;
            if ($result) {
                return "Sukses";
            } else {
                return "Gagal";
            }
        }

    }
?>