<?php
// include db connect class
require_once __DIR__ . '/db_connect.php';
require_once './MCrypt.php';
require_once '../class/class_notifikasi_mobile.php';

$crypt = new MCrypt();
$db = new DB_CONNECT();
$conn = $db->connect();
$class_notif = new NotifikasiClass();

$param = base64_decode($_GET['param']);
$param = $crypt->decrypt($param);
$arr_param = explode(chr(0).chr(1),$param);
$category = $arr_param[1];

if($db){
	switch($category){

		//KEPEGAWAIAN
		case 1:
			$query = sprintf("SELECT * 
								FROM tb_kepegawaian_pegawai 
								ORDER BY nama_lengkap ASC");
			break;

		//USER PEGAWAI
		case 2:
			$query = sprintf("SELECT * 
								FROM tb_umum_user_pegawai");
			break;

		//PERUSAHAAN
		case 3:
			$query = sprintf("SELECT p.id_perusahaan, 
									 p.kode_perusahaan, 
									 p.nama_perusahaan, 
									 p.alamat, 
									 p.no_telpon, 
									 p.email, 
									 p.deskripsi_perusahaan, 
									 p.website, 
									 p.foto_logo, 
									 p.config_ftp, 
									 p.php_address, 
									 p.alias, 
									 p.latitude, 
									 p.longitude, 
									 p.timezone_php, 
									 p.timezone_mysql
								FROM tb_perusahaan p");
			break;

		//KEGAIATAN DR
		case 4:
			$query = sprintf("SELECT * 
								FROM tb_crm_kegiatandr
								WHERE aktif = '1' 
								ORDER BY kegiatan ASC");
			break;

		//JENIS DISPOSISI
		case 5:
			$query = sprintf("SELECT * 
								FROM tb_disposur_jenis");
			break;

		//KLASIFIKASI DISPOSISI
		case 6:
			$query = sprintf("SELECT * 
								FROM tb_disposur_klasifikasi");
			break;

		//BIDANG USAHA
		case 7;
			$query = sprintf("SELECT * 
								FROM tb_umum_customer_bidang_usaha 
								ORDER BY bidang_usaha ASC");
			break;

		//SUMBER LOKASI
		case 8;
			$query = sprintf("SELECT * 
								FROM tb_umum_customer_sumber 
								ORDER BY customer_sumber ASC");
			break;

		//TIPE LOKASI
		case 9:
			$query = sprintf("SELECT * 
								FROM tb_umum_customer_tipe");
			break;

		//PROVINSI
		case 10:
			$query = sprintf("SELECT * 
								FROM tb_umum_provinsi 
								ORDER BY provinsi ASC");
			break;

		//KABUPATEN KOTA
		case 11:
			$idprovinsi = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT * 
								FROM tb_umum_kabupatenkota 
								WHERE id_provinsi = '%s' 
								ORDER BY kabupatenkota ASC", $idprovinsi);
			break;

		//KECAMATAN
		case 12:
			$idkabupaten = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT * 
								FROM tb_umum_kecamatan 
								WHERE id_kabupatenkota = '%s' 
								ORDER BY kecamatan ASC", $idkabupaten);
			break;

		//STRUKTUR ORGANISASI
		case 13:
			$query = sprintf("SELECT * 
								FROM tb_umum_struktor");
			break;

		//JOB DESC SATUAN
		case 14:
			$query = sprintf("SELECT * FROM tb_jobdes_satuan");
			break;

		//DISPOSISI JENIS
		case 15:
			$query = sprintf("SELECT * 
									 FROM tb_disposur_jenis");
			break;

		//DISPOSISI KLASIFIKASI
		case 16:
			$query = sprintf("SELECT * 
									 FROM tb_disposur_klasifikasi");
			break;

		//GRUP PEGAWAI
		case 17:
			$query = sprintf("SELECT * 
									 FROM tb_grup_pegawai");
			break;

		//PEGAWAI BAWAHAN
		case 18:
			$idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
			$kodestruktor = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT * 
								FROM tb_kepegawaian_pegawai 
								ORDER BY nama_lengkap ASC 
								WHERE id_pegawai <> '%s' 
								AND kode_struktor_tingkatan LIKE '%s%%'", $idpegawai, $kodestruktor);
			break;

        //LOKASI AKTIVITAS
		case 19:
			$query = sprintf("SELECT kode_customer, 
									 nama, 
									 alamat, 
									 bidang_usaha, 
									 foto, 
									 no_telpon, 
									 email 
							  FROM tb_umum_customer
							  WHERE aktif = '1'");
			break;

        //TUGAS
        case 20:
            $query = sprintf("SELECT id_jobtask, 
                                      kode_jobtask, 
                                      nama 
                              FROM tb_crm_jobtask");
            break;

        //STRUKTUR ORGANISASI
        case 21:
            $query = sprintf("SELECT id_struktor, 
                                      kode_struktor, 
                                      nama_struktor, 
                                      otoritas, 
                                      manipulasi, 
                                      tipe_pegawai 
                              FROM tb_umum_struktor");
            break;

        //PENDIDIKAN TERAKHIR
        case 22:
            $query = sprintf("SELECT id_pendidikan_terakhir, 
                                      pendidikan_terakhir 
                              FROM tb_kepegawaian_pendidikan_terakhir");
            break;

        //TIPE PEGAWAI
        case 23:
            $query = sprintf("SELECT tipe_pegawai, 
                                      nama_tipe_pegawai, 
                                      tglwaktu_buat_data, 
                                      id_user_input, 
                                      nama_user_input 
                              FROM tb_umum_tipe_pegawai");
            break;

        //UNIT KERJA
		case 24:
            $query = sprintf("SELECT id_unit_kerja, 
                                      unit_kerja 
                              FROM tb_kepegawaian_unit_kerja");
			break;

        //JOB DESC MASTER
        case 25:
            $query = sprintf("SELECT id_jobdes, 
									  kode_jobdes, 
									  nama_jobdes 
							  FROM tb_jobdes_master");
            break;

        //DIVISI
        case 26:
            $query = sprintf("SELECT * 
                              FROM tb_divisi
                              WHERE aktif = '1'");
            break;

        //JUMLAH DIVISI BERDASARKAN KODE JOBDESK
        case 27:
            $iddivisi = mysqli_real_escape_string($conn, $arr_param[2]);
            $kodejobdesk = mysqli_real_escape_string($conn, $arr_param[3]);
            $query = sprintf("SELECT COUNT(id_jobdes_divisi) AS id_jobdes_divisi
                              FROM tb_jobdes_divisi 
                              WHERE id_divisi = '%d' 
                              AND kode_jobdes = '%s'", $iddivisi, $kodejobdesk);
            break;

        //NOTIFIKASI
		case 28:
			$idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
            $class_notif->id_user = $idpegawai;
			$query = sprintf("SELECT a.id_notif, 
									a.kode_notif, 
									a.tglwaktu, 
									a.link_isi,
									a.id_pegawai, 
									b.nama AS nama_pegawai, 
									b.foto AS foto_pegawai, 
									a.id_pegawai_kepada, 
									a.jenis, 
									a.kode_tabel, 
									a.isOpen 
							  FROM tb_crm_notif a 
							  LEFT JOIN tb_kepegawaian_pegawai b 
							  ON a.id_pegawai = b.id_pegawai 
							  WHERE a.id_pegawai_kepada = %d
							  ORDER BY a.tglwaktu DESC
							  LIMIT %d,8", $idpegawai, $limit);
			break;

        //PEGAWAI NON USER
		case 29:
			$idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT * 
								FROM tb_kepegawaian_pegawai
								WHERE id_pegawai <> %d 
								ORDER BY nama_lengkap ASC", $idpegawai);
			break;
			
		//JUMLAH STRUKTOR BERDASARKAN KODE STRUKTOR TINGKATAN
		case 30:
			$kodestruktor = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT 
								COUNT(id_struktor) AS jumlah 
								FROM tb_umum_struktor 
								WHERE kode_struktor LIKE '%s%%'");
			break;
			
		default:
			break;
	}
	if($category == 2 || $category == 3 || $category == 27){
		$select = $db->selectTBObject($query);
	} else {
		$select = $db->selectTBassoc($query);
        if ($category == 4) {
            $dataPilihan = array("id_kegiatan" => 0,
                "info_kegiatan" => '',
                "tipe_pegawai" => 1,
                "kegiatan" => '-- Pilih Jenis Kegiatan --',
                "bobot" => 0,
                "id_user_input" => '',
                "nama_user_input" => '',
                "alat_input" => '',
                "tglwaktu_buat_data" => '',
                "aktif" => '',
                "urut_laporan" => '',
                "marker" => '',
                "id_kegiatandr_bsamon" => '');
            array_unshift($select, $dataPilihan);
        }
	}
	if (count($select) > 0) {
		if ($category == 2 || $category == 3 || $category == 27) {
			$data = json_encode($select);
		} else if ($category == 28) {
            $class_notif->setZeroNotif();
			$data = "{data:".json_encode($select)."}";
		} else {
			$data = "{data:".json_encode($select)."}";
		}
		echo $data;
	} else {
		$response["success"] = 0;
		$response["message"] = "Terjadi kesalahan input. data ditolak database atau Query Error...";
		echo json_encode($response);
	}
}
$db->closeDB();
?>