<?php
// include db connect class
require_once __DIR__ . '/db_connect.php';
require_once './MCrypt.php';

$crypt = new MCrypt();
$db = new DB_CONNECT();
$conn = $db->connect();

$param = base64_decode($_GET['param']);
$param = $crypt->decrypt($param);
$arr_param = explode(chr(0).chr(1),$param);
$category = $arr_param[1];

if($db){
	switch($category){

		//DASHBOARD LOKASI
		case 1:
			$query = sprintf("SELECT id_customer, 
									kode_customer, 
									nama, 
									foto, 
									bidang_usaha 
									FROM tb_umum_customer 
									WHERE aktif = 1
									ORDER BY tglwaktu_buat_data 
									DESC LIMIT 5");
			break;

        //DASHBOARD AKTIVITAS
		case 2:
			$query = sprintf("SELECT a.id_aktivitas, 
									 a.kode_aktivitas, 
									 a.id_pegawai, 
									 p.nama AS nama_pegawai, 
									 p.foto AS foto_pegawai, 
									 a.kegiatan, 
									 a.foto AS fotoact ,
									 COALESCE(c.nama,'') AS nama_customer,
									 a.tglwaktu_buat_data 
									FROM tb_crm_aktivitas a
									INNER JOIN tb_kepegawaian_pegawai p ON p.id_pegawai = a.id_pegawai
									LEFT JOIN tb_umum_customer c ON c.kode_customer = a.kode_customer
									WHERE a.aktif = 1
									AND p.aktif = 1
									ORDER BY a.tglwaktu_buat_data 
									DESC LIMIT 5");
			//$kodestrtgtk

			break;

        //DASHBOARD TUGAS
		case 3:
			$query = sprintf("SELECT a.id_jobtask, 
									 a.kode_jobtask, 
									 a.id_pegawai_buatjob, 
									 p.nama AS nama_pegawai, 
									 p.foto AS foto_pegawai, 
									 a.kegiatan, 
									 COALESCE(c.nama,'') AS nama_customer, 
									 a.tglwaktu_buat_data 
									FROM tb_crm_jobtask a
									INNER JOIN tb_kepegawaian_pegawai p ON p.id_pegawai = a.id_pegawai_buatjob
									LEFT JOIN tb_umum_customer c ON c.kode_customer = a.kode_customer
									WHERE a.aktif = 1
									AND p.aktif = 1
									ORDER BY a.tglwaktu_buat_data
									DESC LIMIT 5");
			break;

        //DASHBOARD DISPOSISI
		case 4:
			$query = sprintf("SELECT a.id_disposisi_surat,
									 a.tglsurat,
									 a.nosurat,
									 p.foto AS foto_pegawai,
									 a.pengirim
							 FROM tb_disposur a, 
							 	  tb_kepegawaian_pegawai p
							 WHERE p.id_pegawai = a.id_pegawai
							 AND a.aktif = 1
							 ORDER BY a.tglsurat 
							 DESC LIMIT 5");
			break;

        //DASHBOARD JOBDESC AKTIVITAS ATASAN
		case 5:
			$query = sprintf("SELECT a.id_jobdes_aktivitas,
                                    a.kode_jobdes_aktivitas,
                                    a.kode_jobdes_pegawai,
                                    a.id_pegawai,
                                    p.nama_lengkap AS nama_pegawai, 
                                    p.foto AS foto_pegawai, 
                                    a.kode_jobdes,
                                    c.nama_jobdes,
                                    a.deskripsi,
                                    a.tglwaktu_buat_data,
                                    a.aktif,
                                    a.foto,
                                    a.berkas,
                                    a.tag_pegawai,
                                    a.kode_customer,
                                    d.nama AS nama_customer,
                                    a.isDisetujui,
                                    a.id_penilai,
                                    (SELECT COUNT(f.id_jd_ak_komen) 
										 FROM tb_jobdes_aktivitas_komen f
										 WHERE a.kode_jobdes_aktivitas = f.kode_jobdes_aktivitas) 
										 AS jumlahkomentar
                                    FROM tb_jobdes_aktivitas a
                                    INNER JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
                                    INNER JOIN tb_jobdes_master c ON a.kode_jobdes = c.kode_jobdes
                                    LEFT JOIN tb_umum_customer d ON a.kode_customer = d.kode_customer
                                    WHERE a.kode_struktor_tingkatan LIKE '%s%%'
                                    AND a.aktif = '1'
									AND p.aktif = 1
                                    ORDER BY a.tglwaktu_buat_data DESC LIMIT 5");
			//$kodestrtgtk);
			break;

		case 6:

			break;

		case 7:

			break;

        //DASHBOARD FILTER GRAFIK KTJ
		case 8:
			$query = sprintf("SELECT DATE(tglwaktu_buat_data) AS tglwaktu, COUNT(id_aktivitas) AS jumlah_aktivitas
									FROM tb_crm_aktivitas
									WHERE DATE(tglwaktu_buat_data) > DATE_SUB(CURDATE(), INTERVAL 1 WEEK)
									AND aktif = 1
									GROUP BY DATE(tglwaktu_buat_data)");
			
			break;

		case 9:
			$query = sprintf("SELECT COUNT(id_aktivitas) AS aktivitas, 
							(SELECT COUNT(B.id_jobtask) FROM tb_crm_jobtask B WHERE B.aktif = 1) AS tugas 
							FROM tb_crm_aktivitas WHERE aktif = 1");
			break;

		default:
			break;
	}
	$select = $db->selectTBassoc($query);
	if($category == 9){
		$select = $db->selectTBObject($query);
	}
	if ($category == 8) {
		$datenow = date("Y-m-d");
		$pastdate = date("Y-m-d", strtotime("-7 days", strtotime($datenow)));
		$no = 1;
		if (count($select) > 0) {
			foreach($select as $row){
				$arrtglwaktu[$no] = $row['tglwaktu'];
				$arrjumaktivitas[$no] = $row['jumlah_aktivitas'];
				$no++;
			}
		}
		//
		$select = "";
		for ($i=0;$i<7;$i++) {
			$pastdate = date("Y-m-d", strtotime("+1 days", strtotime($pastdate)));
			$noarr = @array_search($pastdate, $arrtglwaktu);
			if ($noarr > 0) {
				$jumlahaktivitas = $arrjumaktivitas[$noarr];
			} else {
				$jumlahaktivitas = 0;
			}
			$select[] = array("tglwaktu" => $pastdate, "jumlah_aktivitas" => $jumlahaktivitas);
		}
		$data = "{data:".json_encode($select)."}";
		echo $data;
	}
	else if (count($select) > 0) {
		if($category == 9){
			$data = json_encode($select);
		} else {
			$data = "{data:".json_encode($select)."}";
		}
		echo $data;
	} else {
		$response["success"] = 0;
		$response["message"] = "Terjadi kesalahan input. data ditolak database atau Query Error...";
		echo json_encode($response);
	}
	$db->closeDB();
}
?>