<?php
// include db connect class
require_once __DIR__ . '/db_connect.php';
require_once './MCrypt.php';

$crypt = new MCrypt();
$db = new DB_CONNECT();
$conn = $db->connect();

$param = base64_decode($_GET['param']);
$param = $crypt->decrypt($param);
$arr_param = explode(chr(0).chr(1),$param);
$category = $arr_param[1];

if($db){
	switch($category){
		case 1:
		//FILTER DISPOSISI NORMAL
		$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.aktif = 1
							 AND d.id_pegawai = p.id_pegawai
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $limit);
			break;
			
		case 2:
			//FILTER DISPOSISI DETAIL
			$kodedisposisi = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat, 
									 d.tglsurat, 
									 d.nosurat, 
									 d.id_pegawai, 
									p.nama AS nama_pegawai, 
									p.jabatan AS jabatan_pegawai, 
									p.foto AS foto_pegawai,
									d.id_disposur_jenis, 
									d.disposur_jenis, 
									d.id_disposur_klasifikasi, 
									d.disposur_klasifikasi, 
									d.pengirim, 
									d.tujuansurat, 
									d.perihal, 
									d.isi, 
									d.kepada, 
									d.filesurat, 
									d.aktif 
								FROM tb_disposur d, tb_kepegawaian_pegawai p
								WHERE d.kode_disposisi_surat = '%s'
								AND d.id_pegawai = p.id_pegawai
								AND d.aktif = 1", $kodedisposisi);
			break;
			
		case 3;
			//FILTER DISPOSISI NOMOR SURAT
			$nomorsurat = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.nosurat LIKE '%s%%'
							 AND d.id_pegawai = p.id_pegawai
							 AND d.aktif = 1
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $nomorsurat, $limit);
			break;
			
		case 4:
			//FILTER DISPOSISI TANGGAL SURAT
			$tglsurat = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.tglsurat LIKE '%s%%'
							 AND d.id_pegawai = p.id_pegawai
							 AND d.aktif = 1
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $tglsurat, $limit);
			break;
			
		case 5:
			//FILTER DISPOSISI PENGIRIM
			$pengirim = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE pengirim LIKE '%s%%'
							 AND d.id_pegawai = p.id_pegawai
							 AND d.aktif = 1
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $pengirim, $limit);
			break;
			
		case 6:
			//FILTER DISPOSISI PENERIMA
			$penerima = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE kepada LIKE '%s%%'
							 AND d.id_pegawai = p.id_pegawai
							 AND d.aktif = 1
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $penerima, $limit);
			break;
			
		case 7:
			//FILTER DISPOSISI TUJUAN SURAT
			$tujuan = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.tujuansurat LIKE '%s%%'
							 AND d.aktif = 1
							 AND d.id_pegawai = p.id_pegawai
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $tujuan, $limit);
			break;
			
		case 8:
			//FILTER DISPOSISI PERIHAL SURAT
			$perihal = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.perihal LIKE '%s%%'
							 AND d.aktif = 1
							 AND d.id_pegawai = p.id_pegawai
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $perihal, $limit);
			break;
			
		case 9:
			//FILTER DISPOSISI DESKRIPSI/ISI SURAT
			$isi = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.isi LIKE '%s%%'
							 AND d.aktif = 1
							 AND d.id_pegawai = p.id_pegawai
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $isi, $limit);
			break;
			
		case 10:
			//FILTER DISPOSISI PEGAWAI
			$idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.id_pegawai = '%s'
							 AND d.aktif = 1
							 AND d.id_pegawai = p.id_pegawai
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $idpegawai, $limit);
			break;
			
		default:
			break;
	}
	if($category == 2){
		$select = $db->selectTBObject($query);
	} else {
		$select = $db->selectTBassoc($query);
	}
	if (count($select) > 0) {
		if($category == 2){
			$data = json_encode($select);
		} else {
			$data = "{data:".json_encode($select)."}";
		}
		echo $data;
	} else {
		$response["success"] = 0;
		$response["message"] = "Terjadi kesalahan input. data ditolak database atau Query Error...";
		echo json_encode($response);
	}
}
$db->closeDB();
?>