<?php
// include db connect class
require_once __DIR__ . '/db_connect.php';
require_once './MCrypt.php';

$crypt = new MCrypt();
$db = new DB_CONNECT();
$conn = $db->connect();

$param = base64_decode($_GET['param']);
$param = $crypt->decrypt($param);
$arr_param = explode(chr(0).chr(1),$param);
$category = $arr_param[1];

if($db){
	switch($category){
		case 1:
			//Job Desk MASTER
			$query = sprintf("SELECT * FROM tb_jobdes_master");
			break;
			
		case 2:
			//FILTER JOBDESK AKTIVITAS PER JOBDESK PEGAWAI
			$kodejobdeskpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT a.id_jobdes_aktivitas,
                                    a.kode_jobdes_aktivitas,
                                    a.kode_jobdes_pegawai,
                                    a.id_pegawai,
                                    p.nama_lengkap AS nama_pegawai, 
                                    p.foto AS foto_pegawai, 
                                    a.kode_jobdes,
                                    c.nama_jobdes,
                                    a.deskripsi,
                                    a.tglwaktu_buat_data,
                                    a.aktif,
                                    a.foto,
                                    a.berkas,
                                    a.tag_pegawai,
                                    a.kode_customer,
                                    d.nama AS nama_customer,
                                    a.isDisetujui,
                                    a.id_penilai,
                                    (SELECT COUNT(f.id_jd_ak_komen) 
										 FROM tb_jobdes_aktivitas_komen f
										 WHERE a.kode_jobdes_aktivitas = f.kode_jobdes_aktivitas) 
										 AS jumlahkomentar
                                    FROM tb_jobdes_aktivitas a
                                    INNER JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
                                    INNER JOIN tb_jobdes_master c ON a.kode_jobdes = c.kode_jobdes
                                    LEFT JOIN tb_umum_customer d ON a.kode_customer = d.kode_customer
                                    WHERE a.kode_jobdes_pegawai = '%s'
									AND a.aktif = 1
									AND p.aktif = 1
                                    ORDER BY a.tglwaktu_buat_data DESC LIMIT %d,8", $kodejobdeskpegawai, $limit);
			break;

		case 9:
			//FILTER JOBDESK AKTIVITAS PER JOBDESK PEGAWAI BAWAHAN
			$kodejobdeskpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
			$idpegawai = mysqli_real_escape_string($conn, $arr_param[3]);
            $limit = mysqli_real_escape_string($conn, $arr_param[4]);
			$query = sprintf("SELECT a.id_jobdes_aktivitas,
                                    a.kode_jobdes_aktivitas,
                                    a.kode_jobdes_pegawai,
                                    a.id_pegawai,
                                    p.nama_lengkap AS nama_pegawai, 
                                    p.foto AS foto_pegawai, 
                                    a.kode_jobdes,
                                    c.nama_jobdes,
                                    a.deskripsi,
                                    a.tglwaktu_buat_data,
                                    a.aktif,
                                    a.foto,
                                    a.berkas,
                                    a.tag_pegawai,
                                    a.kode_customer,
                                    d.nama AS nama_customer,
                                    a.isDisetujui,
                                    a.id_penilai,
                                    (SELECT COUNT(f.id_jd_ak_komen) 
										 FROM tb_jobdes_aktivitas_komen f
										 WHERE a.kode_jobdes_aktivitas = f.kode_jobdes_aktivitas) 
										 AS jumlahkomentar
                                    FROM tb_jobdes_aktivitas a
                                    INNER JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
                                    INNER JOIN tb_jobdes_master c ON a.kode_jobdes = c.kode_jobdes
                                    LEFT JOIN tb_umum_customer d ON a.kode_customer = d.kode_customer
                                    WHERE a.kode_jobdes_pegawai = '%s'
                                    AND a.id_pegawai = '%s'
									AND a.aktif = 1
									AND p.aktif = 1
                                    ORDER BY a.tglwaktu_buat_data DESC LIMIT %d,8", $kodejobdeskpegawai,
                                                                            $idpegawai, $limit);
			break;

        case 3:
			//Job Desk Aktivitas Per JobDesk Pegawai
			$kodejobdeskpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT a.id_jobdes_aktivitas,
                                    a.kode_jobdes_aktivitas,
                                    a.kode_jobdes_pegawai,
                                    a.id_pegawai,
                                    p.nama_lengkap AS nama_pegawai, 
                                    p.jabatan AS jabatan_pegawai,
                                    p.foto AS foto_pegawai, 
                                    a.kode_jobdes,
                                    c.nama_jobdes,
                                    a.deskripsi,
                                    a.tglwaktu_buat_data,
                                    a.aktif,
                                    a.kode_struktor_atasan,
                                    a.kode_struktor_tingkatan,
                                    a.foto,
                                    a.tag_pegawai,
                                    a.kode_customer,
                                    d.nama AS nama_customer,
                                    (SELECT COUNT(f.id_jd_ak_komen) 
										 FROM tb_jobdes_aktivitas_komen f
										 WHERE a.kode_jobdes_aktivitas = f.kode_jobdes_aktivitas) 
										 AS jumlahkomentar
                                    FROM tb_jobdes_aktivitas a
                                    INNER JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
                                    INNER JOIN tb_jobdes_master c ON a.kode_jobdes = c.kode_jobdes
                                    LEFT JOIN tb_umum_customer d ON a.kode_customer = d.kode_customer
                                    LEFT JOIN tb_kepegawaian_pegawai e ON a.id_penilai = e.id_pegawai
                                    WHERE a.kode_jobdes_pegawai = '%s'
									AND a.aktif = 1
									AND p.aktif = 1", $kodejobdeskpegawai);
            break;

		case 4:
			//Job Desk Aktivitas Per Lokasi Aktivitas ATAS
			$kodelokasi = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT a.id_jobdes_aktivitas,
                                    a.kode_jobdes_aktivitas,
                                    a.kode_jobdes_pegawai,
                                    a.id_pegawai,
                                    p.nama_lengkap AS nama_pegawai, 
                                    p.jabatan AS jabatan_pegawai,
                                    p.foto AS foto_pegawai, 
                                    a.kode_jobdes,
                                    c.nama_jobdes,
                                    a.deskripsi,
                                    a.tglwaktu_buat_data,
                                    a.aktif,
                                    a.kode_struktor_atasan,
                                    a.kode_struktor_tingkatan,
                                    a.foto,
                                    a.tag_pegawai,
                                    a.kode_customer,
                                    d.nama AS nama_customer,
                                    (SELECT COUNT(f.id_jd_ak_komen) 
										 FROM tb_jobdes_aktivitas_komen f
										 WHERE a.kode_jobdes_aktivitas = f.kode_jobdes_aktivitas) 
										 AS jumlahkomentar
                                    FROM tb_jobdes_aktivitas a
                                    INNER JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
                                    INNER JOIN tb_jobdes_master c ON a.kode_jobdes = c.kode_jobdes
                                    LEFT JOIN tb_umum_customer d ON a.kode_customer = d.kode_customer
                                    LEFT JOIN tb_kepegawaian_pegawai e ON a.id_penilai = e.id_pegawai
                                    WHERE a.kode_customer = '%s'
									AND a.aktif = 1
									AND p.aktif = 1", $kodelokasi);
			break;

		case 5:

			break;

		case 6:
			//FILTER JOBDESK AKTIVITAS PER PEGAWAI
            $pegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $limit = mysqli_real_escape_string($conn, $arr_param[3]);
            $query = sprintf("SELECT a.id_jobdes_aktivitas,
                                    a.kode_jobdes_aktivitas,
                                    a.kode_jobdes_pegawai,
                                    a.id_pegawai,
                                    p.nama_lengkap AS nama_pegawai, 
                                    p.foto AS foto_pegawai, 
                                    a.kode_jobdes,
                                    c.nama_jobdes,
                                    a.deskripsi,
                                    a.tglwaktu_buat_data,
                                    a.aktif,
                                    a.foto,
                                    a.berkas,
                                    a.tag_pegawai,
                                    a.kode_customer,
                                    COALESCE(d.nama,'') AS nama_customer,
                                    a.isDisetujui,
                                    a.id_penilai,
                                    (SELECT COUNT(f.id_jd_ak_komen) 
										 FROM tb_jobdes_aktivitas_komen f
										 WHERE a.kode_jobdes_aktivitas = f.kode_jobdes_aktivitas) 
										 AS jumlahkomentar
                                    FROM tb_jobdes_aktivitas a
                                    INNER JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
                                    INNER JOIN tb_jobdes_master c ON a.kode_jobdes = c.kode_jobdes
                                    LEFT JOIN tb_umum_customer d ON a.kode_customer = d.kode_customer
                                    WHERE a.id_pegawai = '%s'
									AND a.aktif = 1
									AND p.aktif = 1
                                    ORDER BY a.tglwaktu_buat_data DESC LIMIT %d,8", $pegawai, $limit);
			break;

        case 7:
            //SUNTING DATA JDA
            
            break;
			
		default:
			break;
	}
	$select = $db->selectTBassoc($query);
	if (count($select) > 0){
		$data = "{data:".json_encode($select)."}";
		echo $data;
	} else {
		$response["success"] = 0;
		$response["message"] = "Terjadi kesalahan input. data ditolak database atau Query Error...";
        echo json_encode($response);
	}
}
$db->closeDB();
?>