<?php
// include db connect class
require_once __DIR__ . '/db_connect.php';

$db = new DB_CONNECT();
$conn = $db->connect();

$param = base64_decode(mysqli_real_escape_string($conn, $_GET['param']));
$arr_param = explode(chr(0).chr(1),$param);
$category = $arr_param[1];

if($db){
	switch($category){
		case 1:
			//FILTER JOBDESK PEGAWAI ATASAN NORMAL
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT z.* FROM (SELECT a.id_jobdes_pegawai, 
									a.kode_jobdes_pegawai,
									a.kode_jobdes,
									a.id_pegawai,
									p.nama_lengkap AS nama_pegawai, 
									p.foto, 
									a.jml_dikerjakan,
									j.nama_jobdes, 
									a.tahun_jobdes,
									a.tgl_wkt,
									a.tglwkt_buat_data,
									a.kuantitas,
									a.satuan,
									a.biaya,
									a.target_kerja,
									a.kualitas,
									a.ak,
									a.isDisetujuiPenilai,
									a.id_pegawai_penilai,
									b.id_jobdes_divisi,
									COALESCE(b.id_divisi,'') AS id_divisi,
									COALESCE(b.nama_divisi,'') AS nama_divisi,
									a.isDisetujuiPenilaiAtasan,
									a.id_pegawai_penilai_atasan,
									a.aktif
									FROM tb_jobdes_pegawai a
									LEFT JOIN tb_jobdes_master j ON a.kode_jobdes = j.kode_jobdes
									LEFT JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
									LEFT JOIN tb_jobdes_divisi b ON a.kode_jobdes = b.kode_jobdes) z
									WHERE z.aktif = '1' 
									LIMIT %d,8", $limit);
			break;
			
		case 2:
			//FILTER JOBDESK PEGAWAI BAWAHAN NORMAL
			$idpegawai = mysqli_real_escape_string($conn, $arr_param[3]);
			$limit = mysqli_real_escape_string($conn, $arr_param[4]);
			$query = sprintf("SELECT z.* FROM (SELECT a.id_jobdes_pegawai, 
									a.kode_jobdes_pegawai,
									a.kode_jobdes,
									a.id_pegawai,
									p.nama_lengkap AS nama_pegawai, 
									p.foto, 
									a.jml_dikerjakan,
									j.nama_jobdes, 
									a.tahun_jobdes,
									a.tgl_wkt,
									a.tglwkt_buat_data,
									a.kuantitas,
									a.satuan,
									a.biaya,
									a.target_kerja,
									a.kualitas,
									a.ak,
									a.isDisetujuiPenilai,
									a.id_pegawai_penilai,
									b.id_jobdes_divisi,
									COALESCE(b.id_divisi,'') AS id_divisi,
									COALESCE(b.nama_divisi,'') AS nama_divisi,
									a.isDisetujuiPenilaiAtasan,
									a.id_pegawai_penilai_atasan,
									a.aktif
									FROM tb_jobdes_pegawai a
									LEFT JOIN tb_jobdes_master j ON a.kode_jobdes = j.kode_jobdes
									LEFT JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
									LEFT JOIN tb_jobdes_divisi b ON a.kode_jobdes = b.kode_jobdes) z
									WHERE z.aktif = '1' 
									AND z.id_pegawai = %d
									LIMIT %d,8", $idpegawai, $limit);
			break;

		case 3:
			//FILTER JOBDESK PEGAWAI ATASAN NAMA JOBDESK
			$nama = mysqli_real_escape_string($conn, $arr_param[3]);
			$limit = mysqli_real_escape_string($conn, $arr_param[4]);
			$query = sprintf("SELECT z.* FROM (SELECT a.id_jobdes_pegawai, 
									a.kode_jobdes_pegawai,
									a.kode_jobdes,
									a.id_pegawai,
									p.nama_lengkap AS nama_pegawai, 
									p.foto, 
									a.jml_dikerjakan,
									j.nama_jobdes, 
									a.tahun_jobdes,
									a.tgl_wkt,
									a.tglwkt_buat_data,
									a.kuantitas,
									a.satuan,
									a.biaya,
									a.target_kerja,
									a.kualitas,
									a.ak,
									a.isDisetujuiPenilai,
									a.id_pegawai_penilai,
									b.id_jobdes_divisi,
									COALESCE(b.id_divisi,'') AS id_divisi,
									COALESCE(b.nama_divisi,'') AS nama_divisi,
									a.isDisetujuiPenilaiAtasan,
									a.id_pegawai_penilai_atasan,
									a.aktif
									FROM tb_jobdes_pegawai a
									LEFT JOIN tb_jobdes_master j ON a.kode_jobdes = j.kode_jobdes
									LEFT JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
									LEFT JOIN tb_jobdes_divisi b ON a.kode_jobdes = b.kode_jobdes) z
									WHERE z.aktif = '1'
									AND z.nama_jobdes LIKE '%s'
									LIMIT %d,8", $nama, $limit);
			break;

		case 4:
			//FILTER JOBDESK PEGAWAI BAWAHAN NAMA JOBDESK
			$idpegawai = mysqli_real_escape_string($conn, $arr_param[3]);
			$nama = mysqli_real_escape_string($conn, $arr_param[4]);
			$limit = mysqli_real_escape_string($conn, $arr_param[4]);
			$query = sprintf("SELECT z.* FROM (SELECT a.id_jobdes_pegawai, 
									a.kode_jobdes_pegawai,
									a.kode_jobdes,
									a.id_pegawai,
									p.nama_lengkap AS nama_pegawai, 
									p.foto, 
									a.jml_dikerjakan,
									j.nama_jobdes, 
									a.tahun_jobdes,
									a.tgl_wkt,
									a.tglwkt_buat_data,
									a.kuantitas,
									a.satuan,
									a.biaya,
									a.target_kerja,
									a.kualitas,
									a.ak,
									a.isDisetujuiPenilai,
									a.id_pegawai_penilai,
									b.id_jobdes_divisi,
									COALESCE(b.id_divisi,'') AS id_divisi,
									COALESCE(b.nama_divisi,'') AS nama_divisi,
									a.isDisetujuiPenilaiAtasan,
									a.id_pegawai_penilai_atasan,
									a.aktif
									FROM tb_jobdes_pegawai a
									LEFT JOIN tb_jobdes_master j ON a.kode_jobdes = j.kode_jobdes
									LEFT JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
									LEFT JOIN tb_jobdes_divisi b ON a.kode_jobdes = b.kode_jobdes) z
									WHERE z.aktif = '1' 
									AND z.id_pegawai = %d
									AND z.nama_jobdes LIKE '%s'
									LIMIT %d,8", $idpegawai, $nama, $limit);
			break;

		case 5:
			//FILTER JOBDESK PEGAWAI ATASAN PEGAWAI
			$idpegawai = mysqli_real_escape_string($conn, $arr_param[3]);
			$limit = mysqli_real_escape_string($conn, $arr_param[4]);
			$query = sprintf("SELECT z.* FROM (SELECT a.id_jobdes_pegawai, 
									a.kode_jobdes_pegawai,
									a.kode_jobdes,
									a.id_pegawai,
									p.nama_lengkap AS nama_pegawai, 
									p.foto, 
									a.jml_dikerjakan,
									j.nama_jobdes, 
									a.tahun_jobdes,
									a.tgl_wkt,
									a.tglwkt_buat_data,
									a.kuantitas,
									a.satuan,
									a.biaya,
									a.target_kerja,
									a.kualitas,
									a.ak,
									a.isDisetujuiPenilai,
									a.id_pegawai_penilai,
									b.id_jobdes_divisi,
									COALESCE(b.id_divisi,'') AS id_divisi,
									COALESCE(b.nama_divisi,'') AS nama_divisi,
									a.isDisetujuiPenilaiAtasan,
									a.id_pegawai_penilai_atasan,
									a.aktif
									FROM tb_jobdes_pegawai a
									LEFT JOIN tb_jobdes_master j ON a.kode_jobdes = j.kode_jobdes
									LEFT JOIN tb_kepegawaian_pegawai p ON a.id_pegawai = p.id_pegawai
									LEFT JOIN tb_jobdes_divisi b ON a.kode_jobdes = b.kode_jobdes) z
									WHERE z.aktif = '1' 
									AND z.id_pegawai = %d
									LIMIT %d,8", $idpegawai, $limit);
			break;
			
		default:
			break;
	}
	$select = $db->selectTBassoc($query);
	if (count($select) > 0){
		$data = "{data:".json_encode($select)."}";
		echo $data;
	} else {
		$response["success"] = 0;
		$response["message"] = "Terjadi kesalahan input. data ditolak database atau Query Error...";
		echo $query;
	}
}
$db->closeDB();
?>