<?php
// include db connect class
require_once __DIR__ . '/db_connect.php';

$db = new DB_CONNECT();
$conn = $db->connect();

$param = base64_decode(mysqli_real_escape_string($conn, $_GET['param']));
$arr_param = explode(chr(0).chr(1),$param);
$category = $arr_param[1];

if($db){
	switch($category){
		case 1:
			//FILTER LOKASI NORMAL
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
								FROM tb_umum_customer
								WHERE aktif = 1
								ORDER BY nama ASC
								LIMIT %s,8", $limit);
			break;

		case 2:
			//FILTER LOKASI DETAIL
			$kodeaccount = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT a.id_customer,
									 a.kode_customer,
									 a.nama,
									 a.foto,
									 a.alamat, 
									 a.no_telpon, 
									 a.fax, 
									 a.email, 
									 a.bidang_usaha, 
									 a.deskripsi_usaha, 
									 a.kode_segmentasi, 
									 a.customer_sumber, 
									 a.latitude,
									 a.longitude,
									 a.tglwaktu,
									 (SELECT COUNT(b.id_aktivitas) 
									 FROM tb_crm_aktivitas b
									 WHERE b.kode_customer = a.kode_customer) AS c_aktivitas,
									 (SELECT COUNT(c.id_jobtask)
									 FROM tb_crm_jobtask c
									 WHERE c.kode_customer = a.kode_customer) AS c_tugas,
									 (SELECT COUNT(d.id_jobdes_aktivitas)
									 FROM tb_jobdes_aktivitas d
									 WHERE d.kode_customer = a.kode_customer) AS c_jobdesk_aktivitas
								FROM tb_umum_customer a
								WHERE a.kode_customer = '%s'", $kodeaccount);
			break;

		case 3:
			//FILTER LOKASI NAMA
			$filter = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
							FROM tb_umum_customer
							WHERE nama LIKE '%%%s%%' 
							AND aktif = 1
							ORDER BY nama ASC
							LIMIT %s,8", $filter, $limit);
			break;

		case 4:
			//FILTER LOKASI DESKRIPSI
			$filter = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
							FROM tb_umum_customer
							WHERE deskripsi_usaha LIKE '%%%s%%'
							AND aktif = 1
							ORDER BY nama ASC
							LIMIT %s,8", $filter, $limit);
			break;

		case 5:
			//FILTER LOKASI ALAMAT
			$filter = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
							FROM tb_umum_customer
							WHERE alamat LIKE '%%%s%%'
							AND aktif = 1
							ORDER BY nama ASC
							LIMIT %s,8", $filter, $limit);
			break;

		case 6:
			//FILTER LOKASI BIDANG USAHA
			$filter = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
								FROM tb_umum_customer
								WHERE id_bidang_usaha IN (%s)
								AND aktif = 1
								ORDER BY nama ASC
								LIMIT %s,8", $filter, $limit);
			break;

		case 7:
			//FILTER LOKASI TANGGAL
			$filter = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
							FROM tb_umum_customer
							WHERE tglwaktu LIKE '%%%s%%'
							AND aktif = 1
							ORDER BY nama ASC
							LIMIT %s,8", $filter, $limit);
			break;

		case 8:
			//FILTER LOKASI SUMBER
			$filter = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
								FROM tb_umum_customer
								WHERE id_customer_sumber IN (%s)
								AND aktif = 1
								ORDER BY nama ASC
								LIMIT %s,8", $filter, $limit);
			break;

		case 9:
			//FILTER LOKASI PROVINSI
			$filter = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
								FROM tb_umum_customer
								WHERE id_provinsi = '%s'
								AND aktif = 1
								ORDER BY nama ASC
								LIMIT %s,8", $filter, $limit);
			break;

		case 10:
			//FILTER LOKASI KABUPATEN
			$filter = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
								FROM tb_umum_customer
								WHERE id_kabupatenkota = '%s'
								AND aktif = 1
								ORDER BY nama ASC
								LIMIT %s,8", $filter, $limit);
			break;

		case 11:
			//FILTER LOKASI KECAMATAN
			$filter = mysqli_real_escape_string($conn, $arr_param[2]);
			$limit = mysqli_real_escape_string($conn, $arr_param[3]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
								FROM tb_umum_customer
								WHERE id_kecamatan = '%s'
								AND aktif = 1
								ORDER BY nama ASC
								LIMIT %s,8", $filter, $limit);
			break;

		case 12:
            //FILTER LOKASI CHART BAWAHAN
            $kode = mysqli_real_escape_string($conn, $arr_param[2]);
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[3]);
            $query = sprintf("SELECT(SELECT COUNT(id_aktivitas)
							  FROM tb_crm_aktivitas 
							  WHERE kode_customer = '%s' 
							  AND id_pegawai = '%s') AS aktivitas,
							  (SELECT COUNT(id_jobtask) 
							  FROM tb_crm_jobtask 
							  WHERE kode_customer = '%s' 
							  AND id_pegawai_buatjob = '%s')
							  AS jobtask", $kode, $idpegawai, $kode, $idpegawai);
			break;

		case 13:
            //FILTER LOKASI CHART ATASAN
            $kode = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT(SELECT COUNT(id_aktivitas)
							  FROM tb_crm_aktivitas 
							  WHERE kode_customer = '%s') AS aktivitas,
							  (SELECT COUNT(id_jobtask)
							  FROM tb_crm_jobtask
							  WHERE kode_customer = '%s')
							  AS jobtask", $kode, $kode);
			break;

		default:
			break;
	}
	if($category == 2 || $category == 12 || $category == 13){
		$select = $db->selectTBObject($query);
		$data = json_encode($select);
	} else {
		$select = $db->selectTBassoc($query);
		if (count($select) > 0) {
			$data = "{data:".json_encode($select)."}";
		}
	}
	echo $data;
} else {
	echo($query);
	$response["success"] = 0;
	$response["message"] = "Terjadi kesalahan input. data ditolak database atau Query Error...";
	echo json_encode($response);
}
$db->closeDB();
?>