<?php
// include db connect class
require_once __DIR__ . '/db_connect.php';
require_once './MCrypt.php';

$crypt = new MCrypt();
$db = new DB_CONNECT();
$conn = $db->connect();

$param = base64_decode($_GET['param']);
$param = $crypt->decrypt($param);
$arr_param = explode(chr(0).chr(1),$param);
$category = $arr_param[1];

if($db){
    switch($category){
        case 1:
            //PEGAWAI DETAIL
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT p.id_pegawai,
                                    p.nama,
                                    p.nama_lengkap,
                                    p.alamat,
                                    p.tgl_lahir,
                                    p.foto,
                                    p.no_telpon,
                                    p.email,
                                    p.id_kecamatan,
                                    p.kecamatan,
                                    p.id_kabupatenkota,
                                    p.kabupatenkota,
                                    p.id_provinsi,
                                    p.provinsi,
                                    p.jabatan,
                                    p.id_pendidikan_terakhir,
                                    p.pendidikan_terakhir,
                                    p.id_struktor_atasan,
                                    p.kode_struktor_atasan,
                                    p.id_struktor_tingkatan,
                                    p.kode_struktor_tingkatan,
                                    p.tipe_pegawai,
                                    p.warna,
                                    p.id_user_input,
                                    p.nama_user_input,
                                    p.alat_input,
                                    p.tglwaktu_buat_data,
                                    p.aktif,
                                    p.no_pegawai,
                                    p.pangkat,
                                    p.id_unit_kerja,
                                    (SELECT COUNT(a.id_crm_aktivitas_komen_detail) 
										 FROM tb_crm_aktivitas_komen_detail a
										 WHERE a.id_pegawai = p.id_pegawai
										 AND a.aktif = 1) 
										 AS komentar_aktivitas,
									(SELECT COUNT(t.id_jobtask_komen) 
										 FROM tb_crm_jobtask_komen t
										 WHERE t.id_pegawai = p.id_pegawai
										 AND t.aktif = 1) 
										 AS komentar_tugas,
									(SELECT COUNT(d.id_disposur_komen) 
										 FROM tb_disposur_komen d
										 WHERE d.id_pegawai = p.id_pegawai
										 AND d.aktif = 1) 
										 AS komentar_disposisi,
									(SELECT COUNT(j.id_jd_ak_komen) 
										 FROM tb_jobdes_aktivitas_komen j
										 WHERE j.id_pegawai = p.id_pegawai
										 AND j.aktif = 1) 
										 AS komentar_jobdesk
                                    FROM tb_kepegawaian_pegawai p
                                    WHERE p.id_pegawai = '%s'", $idpegawai);
            break;

        case 2:
            //CHART PERSONAL
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT (SELECT COUNT(a.id_aktivitas) 
                                          FROM tb_crm_aktivitas a 
                                          WHERE a.id_pegawai = p.id_pegawai
                                          AND a.aktif = 1) AS aktivitas,
                                     (SELECT COUNT(t.id_jobtask) 
                                          FROM tb_crm_jobtask t 
                                          WHERE t.id_pegawai_buatjob = p.id_pegawai
                                          AND t.aktif = 1) AS tugas,
                                     (SELECT COUNT(ja.id_jobdes_aktivitas) 
                                          FROM tb_jobdes_aktivitas ja 
                                          WHERE ja.id_pegawai = p.id_pegawai
                                          AND ja.aktif = 1) AS jobdesk_aktivitas,
                                     (SELECT COUNT(lt.id_jobtask_laporan) 
                                          FROM tb_crm_jobtask_laporan lt 
                                          WHERE lt.id_pegawai = p.id_pegawai
                                          AND lt.aktif = 1) AS laporan_tugas
                                      FROM tb_kepegawaian_pegawai p WHERE p.id_pegawai = '%s'", $idpegawai);
            break;

        case 3:
            //AKTIVITAS 7 HARI TERAKHIR
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT A.*, IFNULL(C.aktivitas, 0) AS aktivitas FROM 
                                    (SELECT DATE(DATE_ADD(NOW(), INTERVAL -0 DAY)) AS tglwaktu, 
                                    id_pegawai
                                      FROM tb_crm_aktivitas 
                                      WHERE aktif = 1
                                      UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -1 DAY)) AS tglwaktu, 
                                      id_pegawai
                                      FROM tb_crm_aktivitas 
                                      WHERE aktif = 1
                                      UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -2 DAY)) AS tglwaktu, 
                                      id_pegawai
                                      FROM tb_crm_aktivitas 
                                      WHERE aktif = 1
                                      UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -3 DAY)) AS tglwaktu, 
                                      id_pegawai
                                      FROM tb_crm_aktivitas 
                                      WHERE aktif = 1
                                      UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -4 DAY)) AS tglwaktu, 
                                      id_pegawai
                                      FROM tb_crm_aktivitas 
                                      WHERE aktif = 1
                                      UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -5 DAY)) AS tglwaktu, 
                                      id_pegawai
                                      FROM tb_crm_aktivitas 
                                      WHERE aktif = 1
                                      UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -6 DAY)) AS tglwaktu, 
                                      id_pegawai
                                      FROM tb_crm_aktivitas 
                                      WHERE aktif = 1) A
                                    LEFT JOIN 
                                    (SELECT COUNT(B.kode_aktivitas) AS aktivitas, 
                                    B.tglwaktu_buat_data 
                                    FROM tb_crm_aktivitas B 
                                    WHERE B.aktif = 1 
                                    GROUP BY B.tglwaktu_buat_data) AS C
                                    ON A.tglwaktu = DATE(C.tglwaktu_buat_data) 
                                    WHERE A.id_pegawai = %d 
                                    GROUP BY A.tglwaktu", $idpegawai);
            break;

        case 4:
            //TUGAS 7 HARI TERAKHIR
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT A.*, IFNULL(C.tugas, 0) AS tugas FROM 
                                    (SELECT DATE(DATE_ADD(NOW(), INTERVAL -0 DAY)) AS tglwaktu, 
                                        id_pegawai_buatjob
                                        FROM tb_crm_jobtask 
                                        WHERE aktif = 1
                                        UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -1 DAY)) AS tglwaktu, 
                                        id_pegawai_buatjob
                                        FROM tb_crm_jobtask 
                                        WHERE aktif = 1
                                        UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -2 DAY)) AS tglwaktu, 
                                        id_pegawai_buatjob
                                        FROM tb_crm_jobtask 
                                        WHERE aktif = 1
                                        UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -3 DAY)) AS tglwaktu, 
                                        id_pegawai_buatjob
                                        FROM tb_crm_jobtask 
                                        WHERE aktif = 1
                                        UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -4 DAY)) AS tglwaktu, 
                                        id_pegawai_buatjob
                                        FROM tb_crm_jobtask 
                                        WHERE aktif = 1
                                        UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -5 DAY)) AS tglwaktu, 
                                        id_pegawai_buatjob
                                        FROM tb_crm_jobtask 
                                        WHERE aktif = 1
                                        UNION 
                                    SELECT DATE(DATE_ADD(NOW(), INTERVAL -6 DAY)) AS tglwaktu, 
                                        id_pegawai_buatjob
                                        FROM tb_crm_jobtask 
                                        WHERE aktif = 1) A
                                    LEFT JOIN 
                                    (SELECT COUNT(B.kode_jobtask) AS tugas, 
                                    B.tglwaktu_buat_data 
                                    FROM tb_crm_jobtask B 
                                    WHERE B.aktif = 1 
                                    GROUP BY B.tglwaktu_buat_data) AS C
                                    ON A.tglwaktu = DATE(C.tglwaktu_buat_data) 
                                    WHERE A.id_pegawai_buatjob = %d 
                                    GROUP BY A.tglwaktu", $idpegawai);
            break;

        case 5:
            //DISPOSISI SURAT 7 HARI TERAKHIR
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT b.id_pegawai, 
                                  DATE(b.tglwaktu1) AS tglwaktu, 
                                  COALESCE(a.jml,0) AS disposisi FROM (
                                SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktubuatdata),
                                  INTERVAL -6 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_disposur a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktubuatdata),
                                  INTERVAL -5 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_disposur a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktubuatdata),
                                  INTERVAL -4 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_disposur a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktubuatdata),
                                  INTERVAL -3 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_disposur a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktubuatdata),
                                  INTERVAL -2 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_disposur a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktubuatdata),
                                  INTERVAL -1 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_disposur a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  MAX(a.tglwaktu) AS tglwaktu1,
                                  0 AS jml FROM tb_disposur a 
                                  GROUP BY id_pegawai
                                ORDER BY id_pegawai,tglwaktu1 ) b LEFT JOIN (
                                SELECT id_pegawai, 
                                    tglwaktubuatdata, 
                                    COUNT(id_pegawai) AS jml FROM tb_disposur 
                                    GROUP BY id_pegawai,
                                    DATE(tglwaktubuatdata)) a ON DATE(b.tglwaktu1) = DATE(a.tglwaktubuatdata) 
                                    WHERE b.id_pegawai = '%s' 
                                    ORDER BY tglwaktu ASC", $idpegawai);
            break;

        case 6:
            //JOBDESK PEGAWAI 7 HARI TERAKHIR
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT b.id_pegawai, 
                                  DATE(b.tglwaktu1) AS tglwaktu, 
                                  COALESCE(a.jml,0) AS jobdesk_pegawai FROM (
                                SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwkt_buat_data),
                                  INTERVAL -6 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_pegawai a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwkt_buat_data),
                                  INTERVAL -5 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_pegawai a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwkt_buat_data),
                                  INTERVAL -4 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_pegawai a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwkt_buat_data),
                                  INTERVAL -3 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_pegawai a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwkt_buat_data),
                                  INTERVAL -2 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_pegawai a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwkt_buat_data),
                                  INTERVAL -1 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_pegawai a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                MAX(a.tglwkt_buat_data) AS tglwaktu1,
                                0 AS jml FROM tb_jobdes_pegawai a 
                                GROUP BY id_pegawai
                                  ORDER BY id_pegawai,tglwaktu1 ) b LEFT JOIN (
                                  SELECT id_pegawai, 
                                  tglwkt_buat_data, 
                                  COUNT(id_pegawai) AS jml FROM tb_jobdes_pegawai 
                                  GROUP BY id_pegawai, 
                                  DATE(tglwkt_buat_data)) a ON DATE(b.tglwaktu1) = DATE(a.tglwkt_buat_data) 
                                  WHERE b.id_pegawai = '%s' 
                                  ORDER BY tglwaktu ASC", $idpegawai);
            break;

        case 7:
            //JOBDESK AKTIVITAS 7 HARI TERAKHIR
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT b.id_pegawai, 
                                  DATE(b.tglwaktu1) AS tglwaktu, 
                                  COALESCE(a.jml,0) AS jobdesk_aktivitas FROM (
                                SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktu_buat_data),
                                  INTERVAL -6 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_aktivitas a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktu_buat_data),
                                  INTERVAL -5 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_aktivitas a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktu_buat_data),
                                  INTERVAL -4 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_aktivitas a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktu_buat_data),
                                  INTERVAL -3 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_aktivitas a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktu_buat_data),
                                  INTERVAL -2 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_aktivitas a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  DATE_ADD(MAX(a.tglwaktu_buat_data),
                                  INTERVAL -1 DAY) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_aktivitas a 
                                  GROUP BY id_pegawai
                                UNION SELECT a.id_pegawai, 
                                  MAX(a.tglwaktu_buat_data) AS tglwaktu1,
                                  0 AS jml FROM tb_jobdes_aktivitas a 
                                  GROUP BY id_pegawai
                                ORDER BY id_pegawai,tglwaktu1) b LEFT JOIN (
                                SELECT id_pegawai, 
                                  tglwaktu_buat_data, 
                                  COUNT(id_pegawai) AS jml FROM tb_jobdes_aktivitas 
                                  GROUP BY id_pegawai,
                                  DATE(tglwaktu_buat_data)) a ON DATE(b.tglwaktu1) = DATE(a.tglwaktu_buat_data) 
                                  WHERE b.id_pegawai = '%s' 
                                  ORDER BY tglwaktu ASC", $idpegawai);
            break;

        case 8:
            //LAPORAN TUGAS 7 HARI TERAKHIR
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT b.id_pegawai, 
                                DATE(b.tglwaktu1) AS tglwaktu, 
                                COALESCE(a.jml,0) AS laporan_tugas FROM (
                              SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -6 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_crm_jobtask_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -5 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_crm_jobtask_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -4 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_crm_jobtask_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -3 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_crm_jobtask_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -2 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_crm_jobtask_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -1 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_crm_jobtask_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                MAX(a.tglwaktu_buat_data) AS tglwaktu1,
                                0 AS jml FROM tb_crm_jobtask_laporan a 
                                GROUP BY id_pegawai
                              ORDER BY id_pegawai,tglwaktu1 ) b LEFT JOIN (
                              SELECT id_pegawai, 
                                tglwaktu_buat_data, 
                                COUNT(id_pegawai) AS jml FROM tb_crm_jobtask_laporan 
                                GROUP BY id_pegawai,
                                DATE(tglwaktu_buat_data)) a ON DATE(b.tglwaktu1) = DATE(a.tglwaktu_buat_data) 
                                WHERE b.id_pegawai = '%s' 
                                ORDER BY tglwaktu ASC", $idpegawai);
            break;

        case 9:
            //LAPORAN DISPOSISI 7 HARI TERAKHIR
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT b.id_pegawai, 
                                DATE(b.tglwaktu1) AS tglwaktu, 
                                COALESCE(a.jml,0) AS laporan_disposisi FROM (
                              SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -6 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_disposur_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -5 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_disposur_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -4 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_disposur_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -3 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_disposur_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -2 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_disposur_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                DATE_ADD(MAX(a.tglwaktu_buat_data),
                                INTERVAL -1 DAY) AS tglwaktu1,
                                0 AS jml FROM tb_disposur_laporan a 
                                GROUP BY id_pegawai
                              UNION SELECT a.id_pegawai, 
                                MAX(a.tglwaktu_buat_data) AS tglwaktu1,
                                0 AS jml FROM tb_disposur_laporan a 
                                GROUP BY id_pegawai
                              ORDER BY id_pegawai,tglwaktu1 ) b LEFT JOIN (
                              SELECT id_pegawai, 
                                tglwaktu_buat_data, 
                                COUNT(id_pegawai) AS jml FROM tb_disposur_laporan 
                                GROUP BY id_pegawai,
                                DATE(tglwaktu_buat_data)) a ON DATE(b.tglwaktu1) = DATE(a.tglwaktu_buat_data) 
                                WHERE b.id_pegawai = '%s' ORDER BY tglwaktu ASC", $idpegawai);
            break;

        case 10:
            //UPDATE PEGAWAI NORMAL
            $idpegawai = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT id_pegawai, 
                                      nama, 
                                      nama_lengkap, 
                                      alamat, 
                                      tgl_lahir, 
                                      foto, 
                                      no_telpon, 
                                      email, 
                                      id_kecamatan, 
                                      id_kabupatenkota, 
                                      id_provinsi, 
                                      id_pendidikan_terakhir, 
                                      id_struktor_tingkatan, 
                                      no_pegawai,
                                      pangkat
                              FROM tb_kepegawaian_pegawai
                              WHERE id_pegawai = '%s'", $idpegawai);
            break;

        default:
            break;
    }
    if($category == 1 || $category == 2 || $category == 10){
        $select = $db->selectTBObject($query);
    } else {
        $select = $db->selectTBassoc($query);
    }
    if (count($select) > 0) {
        if($category == 1 || $category == 2 || $category == 10){
            $data = json_encode($select);
        } else {
            $data = "{data:".json_encode($select)."}";
        }
        echo $data;
    } else {
        $response["success"] = 0;
        $response["message"] = "Terjadi kesalahan input. data ditolak database atau Query Error...";
        echo json_encode($response);
    }
}
$db->closeDB();
?>