<?php
// include db connect class
require_once __DIR__ . '/db_connect.php';

$db = new DB_CONNECT();
$conn = $db->connect();

$param = base64_decode(mysqli_real_escape_string($conn, $_GET['param']));
$arr_param = explode(chr(0).chr(1),$param);
$category = $arr_param[1];

if($db){
	switch($category){
		
		case 1:
			//SORT DISPOSISI TANGGAL SURAT ASC
			$limit = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.aktif = 1
							 AND d.id_pegawai = p.id_pegawai
							 ORDER BY d.tglsurat ASC
							 LIMIT %s,8", $limit);
			break;
			
		case 2:
			//SORT DISPOSISI TANGGAL SURAT DESC
			$limit = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.aktif = 1
							 AND d.id_pegawai = p.id_pegawai
							 ORDER BY d.tglsurat DESC
							 LIMIT %s,8", $limit);
			break;
			
		case 3:
			//SORT DISPOSISI NOMOR SURAT ASC
			$limit = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.aktif = 1
							 AND d.id_pegawai = p.id_pegawai
							 ORDER BY d.nosurat ASC
							 LIMIT %s,8", $limit);
			break;
			
		case 4:
			//SORT DISPOSISI NOMOR SURAT DESC
			$limit = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT d.id_disposisi_surat, 
									 d.kode_disposisi_surat,
									 d.tglsurat,
									 d.nosurat,
									 d.id_pegawai,
									 p.nama_lengkap AS nama_pegawai,
									 p.foto AS foto_pegawai,
									 d.pengirim,
									 d.tujuansurat,
									 d.perihal,
									 d.isi,
									 d.kepada,
									 d.aktif
							 FROM tb_disposur d, tb_kepegawaian_pegawai p
							 WHERE d.aktif = 1
							 AND d.id_pegawai = p.id_pegawai
							 ORDER BY d.nosurat DESC
							 LIMIT %s,8", $limit);
			break;
			
		default:
			break;
	}
	$select = $db->selectTBassoc($query);
	if (count($select) > 0) {
		$data = "{data:".json_encode($select)."}";
		echo $data;
	} else {
		$response["success"] = 0;
		$response["message"] = "Terjadi kesalahan input. data ditolak database atau Query Error...";
		echo json_encode($response);
	}
}
$db->closeDB();
?>