<?php
// include db connect class
require_once __DIR__ . '/db_connect.php';

$db = new DB_CONNECT();
$conn = $db->connect();

$param = base64_decode(mysqli_real_escape_string($conn, $_GET['param']));
$arr_param = explode(chr(0).chr(1),$param);
$category = $arr_param[1];

if($db){
	switch($category){
		
		case 1:
			//SORT LOKASI NAMA ASC
			$limit = mysqli_real_escape_string($conn, $arr_param[2]);
			$query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
							FROM tb_umum_customer
							WHERE aktif = 1
							ORDER BY nama ASC
							LIMIT %s,8", $limit);
			break;

		case 2:
            //SORT LOKASI NAMA DESC
            $limit = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
							FROM tb_umum_customer
							WHERE aktif = 1
							ORDER BY nama DESC
							LIMIT %s,8", $limit);
			break;

        case 3:
            //SORT LOKASI TANGGAL ASC
            $limit = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
							FROM tb_umum_customer
							WHERE aktif = 1
							ORDER BY tglwaktu ASC
							LIMIT %s,8", $limit);
            break;

        case 4:
            //SORT LOKASI TANGGAL DESC
            $limit = mysqli_real_escape_string($conn, $arr_param[2]);
            $query = sprintf("SELECT id_customer, 
									 kode_customer, 
									 nama, 
									 tglwaktu, 
									 foto, 
									 alamat,
									 kecamatan,
									 kabupatenkota,
									 provinsi,
									 no_telpon,
									 email,
									 bidang_usaha,
									 latitude,
									 longitude,
									 aktif
							FROM tb_umum_customer
							WHERE aktif = 1
							ORDER BY tglwaktu DESC
							LIMIT %s,8", $limit);
            break;
			
		default:
			break;
	}
    $select = $db->selectTBassoc($query);
    if (count($select) > 0) {
        $data = "{data:".json_encode($select)."}";
        echo $data;
    } else {
        $response["success"] = 0;
        $response["message"] = "Terjadi kesalahan input. data ditolak database atau Query Error...";
        echo json_encode($response);
    }
} 
$db->closeDB();
?>