<?php
	session_start();
	require_once 'auth/config.php';

	$_SESSION['can_add_prod_hukum'] = 1;

	if(empty($_SESSION['id_pegawai'])){
	    $current_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	    header("Location: ". $current_link);
	    exit();
	}

	if(empty($_SESSION['can_add_prod_hukum'])) {
		header("Location: dashboard");
	    exit();
	}

	include "./function/template.php";
	include "./class/class_produk_hukum.php";

	$ph = new ProdukHukumClass();
	$ph->id_user = $_SESSION['id_pegawai'];
	$status = 1;

	headbd();
	// header
	head();
	// menu
	aside('produk-hukum', '');

    $db = new class_connectDB;
    $con = $db->connectDB();
?>

<link rel="stylesheet" type="text/css" href="./css/global.css">
<link rel="stylesheet" type="text/css" href="./plugin/sweetalert/dist/sweetalert.css">
<link href="./css/fileinput.css" media="all" rel="stylesheet" type="text/css" />
<script src="./js/fileinput.js" type="text/javascript"></script>
<script src="./jsku/jquery.mask.min.js" type="text/javascript"></script>
<script src="./jsku/fungsi-global-lengkap.js" type="text/javascript"></script>

<script src="./plugin/sweetalert/dist/sweetalert.min.js"></script>



<?php
	$data_ph = "";
	if (!empty($_GET['id'])) {
		$data_ph = $ph->selectDetailProdukHukum($_GET['id']);
		// date_format(date_create_from_format('Y-m-j', $row['tgl_berlaku']),"d-m-Y");

	}
?>

<div>
    <div class="bg-light lter b-b wrapper-sm">
    	<h1 class="m-n font-thin h3">Produk Hukum</h1>
    </div>

    <div class="wrapper-md">
    	<div class="row" id="divformadd">

    		<div class="col-sm-12">
    			<div class="panel panel-default">
    				<div class="panel-heading">
    					<span class="text-xs text-muted pull-right">
    						<i class="fa fa-chevron-down" id="btnadd" style="cursor:pointer;" onclick="showpanel('paneladd', 'btnadd')"></i> &nbsp;&nbsp;
    					</span>
    					<span class="h4">
    					<?php
	    					if (isset($_GET['edit'])) {
	    						echo "Edit Produk Hukum";
	    					}
	    					else {
	    						echo "Tambah Produk Hukum";
	    					}
    					?>
    					</span>
    				</div>

                    <div class="panel-body" id="paneladd">
            			<div class="form-horizontal">
	                        <form action="manipulation/man-produk_hukum.php" method="post" name="form_produk_hukum" id="form_produk_hukum" enctype="multipart/form-data">
	                        <input type="hidden" name="kode_produk_hukum" id="kph" />

	                        <div class="form-group" id="kon_error_kategori">
	                            <label class="col-sm-2 control-label">Kategori</label>
	                            <div class="col-md-5 col-sm-7">
	                            	<select name="kategori" id="kategori" class="form-control" ui-jq="chosen">
	                            		<?php
	                            			$arr_kat = $ph->selectKategori();
	                            			if (!empty($arr_kat)) {
		                            			for ($i=0; $i < count($arr_kat); $i++) {
		                            				echo '<option value="'. $arr_kat[$i]['ikat'] .'">'. $arr_kat[$i]['kat'] .'</option>';
		                            			}
	                            			}
	                            		?>
	                            	</select>
	                            </div>
	                        </div>

	                        <div class="form-group" id="kon_error_nomor">
	                            <label class="col-sm-2 control-label">Nomor</label>
	                            <div class="col-sm-8">
	                            	<input type="text" name="nomor" id="nomor" class="form-control" />
	                            </div>
	                        </div>

	                        <div class="form-group" id="kon_error_tahun">
	                            <label class="col-sm-2 control-label">Tahun</label>
	                            <div class="col-sm-8">
	                            	<input type="text" name="tahun" id="tahun" class="form-control" />
	                            </div>
	                        </div>

	                        <div class="form-group" id="kon_error_perihal">
	                            <label class="col-sm-2 control-label">Tentang</label>
	                            <div class="col-sm-8">
	                            	<input type="text" name="perihal" id="perihal" class="form-control" />
	                            </div>
	                        </div>


	                        <div class="form-group" id="kon_error_berkas">
	                            <label class="col-sm-2 control-label">File Berkas</label>
	                            <div class="col-sm-8">
	                            	<div style="width:100px; height:100px; display: none;" id="view_box_berkas" class="thumbnail text-center"></div>
	                            	<span id="kon_berkas"><input type="file" class="file" data-show-upload="false" name="berkas" id="berkas" /></span>
							        <script>
							            $("#berkas").fileinput({
							              allowedFileExtensions: ["doc", "docx", "pdf", "xls", "xlsx"],
							              maxFileSize: 10000,
			      						  showCaption: false
							            });
							        </script>
	                            </div>
	                        </div>

	                        <div class="form-group">
	                            <label class="col-sm-2 control-label">Status</label>
	                            <div class="col-sm-8">
	                            	<div class="radio">
										<label class="i-checks checkbox-inline">
			                              <input type="radio" name="status" id="aktif" value="1" checked>
			                              <i></i> Aktif
			                            </label>
									</div>
									<div class="radio">
										<label class="i-checks checkbox-inline">
			                              <input type="radio" name="status" id="nonaktif" value="0">
			                              <i></i> Nonaktif
			                            </label>
									</div>
	                            </div>
	                        </div>
	                        <div class="form-group" id="kon_error_keterangan">
	                            <label class="col-sm-2 control-label">Keterangan</label>
	                            <div class="col-sm-8">
	                            	<textarea id="keterangan" name="keterangan" class="form-control"><?php echo $keterangan; ?></textarea>
	                            	<br />
	                            	<button type="submit" class="btn btn-md btn-primary" id="btn_simpan"><?php if(isset($_GET['edit'])){ echo "Simpan Perubahan"; } else { echo "Simpan"; } ?> <i class="fa fa-refresh" id="l_fph" style="display: none;"></i></button>
	                            </div>
	                        </div>
	                        </form>

            			</div>

                    </div>
                </div>
            </div>


    	</div>

    </div>
</div>
<script src="./jsku/jquery.form.min.js" type="text/javascript"></script>
<script type="text/javascript">
	var data_edit = <?=json_encode($data_ph); ?>;
	var isResetForm = true;
	if (data_edit != "" && data_edit.kph !== null) {
		$('#kph').val(data_edit.kph);
		$('#kategori').val(data_edit.ikat);
		$('#nomor').val(data_edit.nomor);
		$('#tahun').val(data_edit.tahun);
		$('#perihal').val(data_edit.perihal);
		$('#keterangan').val(data_edit.ket);

		if (data_edit.status == 0) {
			$('#nonaktif').click();
		}

		isResetForm = false;

		$('#view_box_berkas').show();
		$('#view_box_berkas').attr('title', data_edit.berkas).append(tBox({
			berkas: data_edit.berkas,
		}) );
	}

	function tBox(arr) {
		var ikon = ikonDoc(getExtentsionOfFile(arr.berkas));
		return '<a href="<?php echo $_SESSION['folder_perusahaan'] . "berkas/produk_hukum/"; ?>'+ arr.berkas +'"><i class="fa '+ ikon +' " style="font-size: 60px; margin-top: 17px;"></i></a>';
	}

	var input_ph = {
	    biasa: ["kategori", "nomor", "tahun", "perihal"],
	    file:  ["berkas"]
	};
	$(document).ready(function(e) {
	    $('#form_produk_hukum').ajaxForm({
	        dataType: 'json',
	        beforeSubmit: function (formData, jqForm, options) {
	        	var isNoError = false;
				isNoError = tandaErrorInputBiasa(input_ph.biasa);
				// console.log(data_edit.berkas);
				if (data_edit.berkas === null) {
					isNoError = forceIsFalse(isNoError, tandaErrorFileUpload("berkas"));
				}
				if (isNoError == true) {
		          $('#form_produk_hukum :input').prop('disabled', true);
		        }
		        $('#l_fph').show();
		        return isNoError;
	        },
	        success: function (res, statusText, xhr, $form)  {
	        	// console.log(xhr);
	        	if (res.status == "oke") {
	        		defaultSwalSuccess();
	        	}
	        	else if (res.status == "error") {
	        		defaultSwalError();
	        	}

	        	// Edit
	        	if (data_edit.berkas !== null) {
	        		$('#berkas').fileinput('reset');
	        		if (res.berkas === null) {
		        		$('#view_box_berkas').attr('title', res.berkas).html( tBox({
							berkas: res.berkas,
						}) );
	        		}
				}

	        	$('#form_produk_hukum :input').prop('disabled', false);
	        	$('#l_fph').hide();
	        },
	        resetForm: isResetForm
	    });
	});
</script>

<?php
	footer();
	footbd();
?>