<?php
	session_start();
  require_once 'auth/config.php';

  $_SESSION['can_add_prod_hukum'] = 1;

  if(empty($_SESSION['id_pegawai'])){
      $current_link = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
      header("Location: ". $current_link);
      exit();
  }

  $_SESSION['isShowProdukHukum'] = 1;

  if(empty($_SESSION['isShowProdukHukum'])) {
    header("Location: dashboard");
      exit();
  }

  include "./function/template.php";
	include "./class/class_produk_hukum.php";

  $ph = new ProdukHukumClass();
	//
	//
	headbd();
	// header
	head();
	// menu

	aside('produk-hukum', '');
?>
<link rel="stylesheet" type="text/css" href="./plugin/sweetalert/dist/sweetalert.css">
<link rel="stylesheet" type="text/css" href="./css/global.css">

<div ng-controller="customersCrtl">
    <div class="bg-light lter b-b wrapper-sm">
      <h1 class="m-n font-thin h3">Produk Hukum</h1>
    </div>
    <div class="wrapper-md kon-post-act">
       <div id="divlistacc">
          <div class="panel panel-default">
            <div class="panel-heading">
              <span class="text-xs text-muted pull-right">
                <i class="fa fa-chevron-down" id="btndaftar" style="cursor:pointer;" onclick="showpanel('panellist', 'btndaftar')"></i> &nbsp;&nbsp;
              </span>
              <span class="h4">Daftar Produk Hukum</span>
            </div>
            <div id="panellist">
                <div class="row wrapper">
                  <div class="col-sm-1 kon-post-act margin-bottom-10">
                    <select ng-model="entryLimit" class="form-control">
                      <option>5</option>
                      <option>10</option>
                      <option>20</option>
                      <option>50</option>
                      <option>100</option>
                    </select>
                  </div>
                  <div class="col-sm-7 kon-post-act margin-bottom-10">
                    <input type="text" ng-model="search.$" ng-change="filter()" placeholder="Filter" class="form-control" />
                  </div>

                  <div class="col-sm-4 kon-post-act">
                      <span class="btn-group pull-right">
                          <i class="btn btn-md btn-default fa fa-table click_web" style="cursor:pointer;" ng-click="showviewacc('tabel')"></i> &nbsp;&nbsp;
                          <i class="btn btn-md btn-default fa fa-list click_mob" style="cursor:pointer;" ng-click="showviewacc('list')"></i> &nbsp;
                      </span>
                  </div>
                </div>
                <div ng-show="loading" class="loading" align="center">
                   <img src="./img/loading.gif" />
                   <div class="clearfix">&nbsp;</div>
                </div>

                <div class="table-responsive" ng-show="filteredItems > 0">
                  <!-- dalam bentuk list -->
                  <div id="viewlist" style="display:none; max-height:500px; overflow:auto;">
                    <ul class="list-group list-group-lg no-bg auto">
                      <li ng-repeat="data in filtered = (list | filter:search ) | startFrom:(currentPage-1)*entryLimit | limitTo:entryLimit" id="tabel{{data.kph}}" class="list-group-item clearfix">
                        <span class="clear">
                          <div>{{data.kat}} {{data.nomor}} tahun {{data.tahun}}</div>
                          <div>{{data.tentang}}</div>
                          <div ng-show="data.ket !== null" ng-bind-html="data.ket"></div>
                          <a href="<?php echo $_SESSION['folder_perusahaan'] . "berkas/produk_hukum/" ?>{{data.berkas}}" class="text-danger"><i class="fa fa-download"></i> Unduh Berkas</a>

                          <div style="margin-top: 20px;">
                            <?php if(!empty($_SESSION['can_add_prod_hukum'])) { ?>
                              <button class="btn btn-xs btn-success" ng-click="showaction('edit', data.kph, '')" title="Edit Produk Hukum"><i class="fa fa-edit icon"></i> Edit</button>
                              <button class="btn btn-xs btn-danger" ng-click="showaction('delete', [data.kph, $index], data.nomor + ' tahun ' + data.tahun)" title="Hapus Produk Hukum"><i class="fa fa-trash-o icon"></i> Hapus</button>
                            <?php } ?>
                          </div>
                        </span>
                      </li>
                    </ul>
                  </div>
                  <!-- dalam bentuk tabel -->
                  <div id="viewtabel" style="max-height:500px; overflow:auto;">
                  <table class="table table-striped b-t b-light">
                    <thead>
                      <tr>
                        <?php if(!empty($_SESSION['can_add_prod_hukum'])) { ?>
                        <th style="width: 50px;"></th>
                        <?php } ?>
                        <th style="width: 10%;"><a ng-click="sort_by('kategori');">Kategori &nbsp;<i class="fa fa-sort"></i></a></th>
                        <th style="width: 30%;"><a ng-click="sort_by('nomor');">Nomor/Tahun &nbsp;<i class="fa fa-sort"></i></a></th>
                        <th style="width: 60%;"><a ng-click="sort_by('tentang');">Tentang/File &nbsp;<i class="fa fa-sort"></i></a></th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr ng-repeat="data in filtered = (list | filter:search ) | startFrom:(currentPage-1)*entryLimit | limitTo:entryLimit" id="tabel{{data.kph}}">
                        <?php if(!empty($_SESSION['can_add_prod_hukum'])) { ?>
                        <td>
                        <button class="btn btn-xs btn-success" ng-click="showaction('edit', data.kph, '')" style="width:20px;" title="Edit Produk Hukum"><i class="fa fa-edit icon"></i></button>
                        <button class="btn btn-xs btn-danger" ng-click="showaction('delete', [data.kph, $index], data.nomor + ' tahun ' + data.tahun)" style="width:20px;" title="Hapus Produk Hukum"><i class="fa fa-trash-o icon"></i></button>
                        </td>
                        <?php } ?>
                        <td>{{data.kat}}</td>
                        <td>{{data.nomor}} tahun {{data.tahun}}</td>
                        <td>
                          <div>{{data.tentang}}</div>
                          <div ng-show="data.ket !== null" ng-bind-html="data.ket"></div>
                          <a href="<?php echo $_SESSION['folder_perusahaan'] . "berkas/produk_hukum/" ?>{{data.berkas}}" class="text-danger"><i class="fa fa-download"></i> Unduh berkas</a>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                  </div>
                </div>
                <footer class="panel-footer" ng-show="filteredItems > 0">
                  <div class="row">
                    <div class="col-sm-12 text-right">
                        <div pagination="" page="currentPage" max-size="5" on-select-page="setPage(page)" boundary-links="true" total-items="filteredItems" items-per-page="entryLimit" class="pagination-small" previous-text="&laquo;" next-text="&raquo;"></div>
                    </div>
                  </div>
                </footer>

                <div ng-show="filteredItems == 0">
                  <div class="text-center"><img src="img/nothing_found.png" alt="...." /></div>
                </div>
              </div>
          </div>
      </div>
      <?php if($_SESSION['can_add_prod_hukum']) { ?>
        <div class="fab bg-primary" id="masterfab" ng-click="showformadd()"><span>+</span></div>
      <?php } ?>

    </div>

<script src="./plugin/sweetalert/dist/sweetalert.min.js"></script>
<script src="./jsku/fungsi-global-lengkap.js" type="text/javascript"></script>

<script type="text/javascript">
  var saklar=1;
  $(document).ready(function(e) {
    ceklebarlayar();
    $("#panel-kanan2").click(function(){
      if(saklar==0){
      //if ($(".active")[0]){
          $("#panel-kanan2").removeClass("active");
          $("#panel-kanan1").removeClass("active");
          //alert("non aktif");
          saklar=1;
      } else {
          $("#panel-kanan2").addClass("active");
          $("#panel-kanan1").addClass("active");
          //alert("aktif");
          saklar=0;
      }
    });
    $('.saklar').attr('disabled', true).trigger("chosen:updated");
  });

  app.filter('startFrom', function() {
    return function(input, start) {
      if(input) {
        start = +start; //parse to int
        return input.slice(start);
      }
      return [];
    }
  });
  app.filter('unsafe', function($sce) {
    return function(val) {
    return $sce.trustAsHtml(val);
    };
  });
  app.controller('customersCrtl', function ($scope, $http, $timeout, $log) {
    //$('#page-loader').show();
    $scope.$log = $log;
    $scope.loading = true;
    $http.get('event/getproduk-hukum.php?list=true').success(function(data){
      //$('#page-loader').hide();
      if (data != "\"\"") {
        $scope.list = data;
        $scope.filteredItems = $scope.list.length; //Initially for no filter
        $scope.totalItems = $scope.list.length;
      }
      else {
        $scope.filteredItems = 0;
        $scope.totalItems = 0;
      }
      $scope.currentPage = 1; //current page
      $scope.entryLimit = 10; //max no of items to display in a page
      $scope.loading = false;
      $log.log(JSON.stringify($scope.list) );
    });
    $scope.predicate = '-tglw_update';
    $scope.setPage = function(pageNo) {
      $scope.currentPage = pageNo;
    };
    $scope.filter = function() {
      $timeout(function() {
        $scope.filteredItems = $scope.filtered.length;
      }, 10);
    };
    $scope.sort_by = function(predicate) {
      $scope.predicate = predicate;
      $scope.reverse = !$scope.reverse;
    };
    $scope.showformadd = function() {
      document.location.href = "./legal-product-new";
    };
    $scope.showviewacc = function(tipe) {
      if (tipe == 'tabel') {
        $("#viewtabel").show();
        $("#viewlist").hide();
        $(".click_web").addClass("active");
        $(".click_mob").removeClass("active");
      } else if (tipe == 'list') {
        $("#viewtabel").hide();
        $("#viewlist").show();
        $(".click_mob").addClass("active");
        $(".click_web").removeClass("active");
      }
    };
    /*$scope.splitProvinsi = function(provinsi) {
      if(provinsi == '0|'){
        return '-';
      } else {
        var a = provinsi.split('|');
        return a[1].toUpperCase();
      }
    };*/
    $scope.formattgl = function(tgl){
      var tmp_arr = tgl.split("-");
      return tmp_arr[2] + " " + month[parseInt(tmp_arr[1] -1)] + " " + tmp_arr[0];
    }
    $scope.showaction = function(tipe, id, nama) {
      // $log.log(id);
      if (tipe == 'edit') {
        document.location.href = "./legal-product-edit?edit=true&id="+ encodeURIComponent(id);
      }
      else if (tipe == 'delete') {
        swal({
          title: "PERINGATAN",
          text: "Apakah anda yakin menghapus produk hukum nomor "+nama+"?",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Ya, Hapus",
          cancelButtonText: "Batal",
          closeOnConfirm: false,
          showLoaderOnConfirm: true,
        },
        function(){
          // $log.log('./manipulation/man-produk_hukum.php?action=delete&id='+id[0]);
          $http.get('./manipulation/man-produk_hukum.php?action=delete&id='+id[0]).success(function(data){
            if(data.status=="oke"){
              swal({
                title: "Aksi Sukses",
                type: "success",
                showCancelButton: false,
                closeOnConfirm: true
              },
              function(){
                if ($scope.totalItems > 0) {
                  // $scope.list.slice(id[1], 1);
                  $scope.list.splice(id[1], 1);
                  // $log.log(JSON.stringify($scope.list) );
                  $scope.filteredItems = $scope.filteredItems - 1;
                  $scope.totalItems = $scope.totalItems - 1;
                  $scope.$apply();
                }
                defaultSwalSuccess();
              });
            } else if(data.status=="error"){
                defaultSwalError();
            }
          });
        });

      }
    };
  });

  $( window ).resize(function() {
    ceklebarlayar();
  });

  function ceklebarlayar() {
    var lebar = $('.app').innerWidth();
    if (lebar <= 600){
      $(".click_mob").click();
    } else {
      $(".click_web").click();
    }
  }
</script>

<script type="text/javascript">
  function aktifNonaktif(id, tipe){
    if( $('#'+id).prop('disabled') ) {
        $('#'+id).attr('disabled', false);
    }
    else {
        $('#'+id).val('');
        $('#'+id).attr('disabled', true);

        $("#"+id).change();
    }
    if (tipe == 'combo') {
        $('#'+id).trigger("chosen:updated");
    }
  }
</script>
<!-- panel Kanan -->
<div id="panel-kanan1" class="settings panel panel-default ng-scope" style="">
  <button target=".settings" id="panel-kanan2" ui-toggle-class="active" class="btn btn-default no-shadow pos-abt ng-scope">
    <i class="fa fa-search"></i>
  </button>
  <div class="panel-heading ng-scope">
    Pencarian
  </div>
  <div class="panel-body ng-scope" style="height:500px; overflow-x: hidden;">

    <div class="m-b-sm">
      <label class="i-checks">
        <input type="checkbox" onclick="aktifNonaktif('filter_kategori', 'combo');"><i></i> Kategori
      </label>
      <select ui-jq="chosen" ng-model="search.ikat" ng-change="filter()" class="form-control saklar" id="filter_kategori">
         <option value="">Semua</option>
         <?php
            $data = $ph->selectKategori();
            for ($i=0; $i < count($data); $i++) {
              echo '<option value="'. $data[$i]['ikat'] .'">'. $data[$i]['kat'] .'</option>';
            }
         ?>
     </select>
    </div>

    <div class="m-b-sm">
      <label class="i-checks">
        <input type="checkbox" onclick="aktifNonaktif('filter_nomor', 'text');"><i></i> Nomor
      </label>
      <input type="text" ng-model="search.nomor" ng-change="filter()" class="form-control saklar" id="filter_nomor" />
    </div>

    <div class="m-b-sm">
      <label class="i-checks">
        <input type="checkbox" onclick="aktifNonaktif('filter_tentang', 'text');"><i></i> Tentang
      </label>
      <input type="text" ng-model="search.perihal" ng-change="filter()" class="form-control saklar" id="filter_tentang" />
    </div>

    <div class="m-b-sm">
      <label>Status</label>
      <span class="radio">
        <label class="i-checks checkbox-inline">
          <input type="radio" name="status" id="aktif" value="" ng-model="search.status" ng-change="filter()" checked="true">
          <i></i> Semua
        </label>
      </span>
      <span class="radio">
        <label class="i-checks checkbox-inline">
          <input type="radio" name="status" id="aktif" value="1" ng-model="search.status" ng-change="filter()">
          <i></i> Aktif
        </label>
      </span>
      <span class="radio">
        <label class="i-checks checkbox-inline">
          <input type="radio" name="status" id="nonaktif" value="0" ng-model="search.status" ng-change="filter()">
          <i></i> Nonaktif
        </label>
      </span>
    </div>

  </div>
</div>
<?php
	footer();
	footbd();
?>